/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.storage;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.storage.DebugStorageScreen;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public final class DebugStorageEntity
extends QpEntity
implements ClientSync {
    @NotNull
    MachineStorage storage;
    private final Set<ServerPlayer> players = new HashSet<ServerPlayer>();

    public DebugStorageEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        this.storage = MachineStorage.of();
        this.setStorage(this.storage);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.toClientTag(output);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.fromClientTag(input);
    }

    @Override
    public ValueOutput toClientTag(ValueOutput output) {
        output.store("storage", MachineStorage.CODEC.codec(), (Object)this.storage);
        return output;
    }

    @Override
    public void fromClientTag(ValueInput input) {
        this.setStorage(input.read("storage", MachineStorage.CODEC.codec()).orElseGet(MachineStorage::of));
    }

    void setStorage(MachineStorage storage) {
        this.storage = storage;
        this.storage.onUpdate(this::syncToOpeningPlayers);
        if (this.level != null && this.level.isClientSide()) {
            this.updateScreenList();
        }
    }

    void updateScreenList() {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof DebugStorageScreen) {
            DebugStorageScreen screen2 = (DebugStorageScreen)screen;
            if (screen2.itemCountList != null) {
                screen2.itemCountList.refreshEntries();
            }
        }
    }

    void startOpen(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.players.add(serverPlayer);
        }
    }

    void stopOpen(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.players.remove(serverPlayer);
        }
    }

    void syncToOpeningPlayers() {
        ClientSyncMessage message = new ClientSyncMessage(this);
        for (ServerPlayer player : this.players) {
            PlatformAccess.getAccess().packetHandler().sendToClientPlayer(message, player);
        }
    }
}

