/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.storage;

import com.yogpc.qp.machine.storage.DebugStorageContainer;
import com.yogpc.qp.machine.storage.ItemCountList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class DebugStorageScreen
extends AbstractContainerScreen<DebugStorageContainer> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"textures/gui/marker.png");
    ItemCountList itemCountList;

    public DebugStorageScreen(DebugStorageContainer menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 217;
        this.imageHeight = 188;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int pX = this.leftPos;
        int pY = this.topPos;
        graphics.blit(RenderPipelines.GUI_TEXTURED, LOCATION, pX, pY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void init() {
        super.init();
        this.itemCountList = new ItemCountList(this.minecraft, 205, this.inventoryLabelY - 20, this.topPos + 18, ((DebugStorageContainer)this.getMenu()).storage);
        this.itemCountList.setX(this.leftPos + (this.imageWidth - 205) / 2);
        this.addRenderableWidget((GuiEventListener)this.itemCountList);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        if (this.itemCountList.isMouseOver(mouseX, mouseY) && this.itemCountList.mouseDragged(event, mouseX, mouseY)) {
            return true;
        }
        return super.mouseDragged(event, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return this.getChildAt(mouseX, mouseY).filter(listener -> listener.mouseScrolled(mouseX, mouseY, scrollX, scrollY)).isPresent();
    }
}

