/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.neoforge;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.neoforge.machine.MachineStorageNeoForge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class TransferNeoForge
implements PlatformAccess.Transfer {
    @Override
    public ItemStack transferItem(Level level, BlockPos pos, ItemStack stack, Direction side, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        ResourceHandler handler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, pos, (Object)side);
        if (handler == null) {
            return stack;
        }
        try (Transaction transaction = Transaction.openRoot();){
            int inserted = handler.insert((Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            if (stack.getCount() <= inserted) {
                ItemStack itemStack = ItemStack.EMPTY;
                return itemStack;
            }
            ItemStack itemStack = stack.copyWithCount(stack.getCount() - inserted);
            return itemStack;
        }
    }

    @Override
    public FluidStackLike transferFluid(Level level, BlockPos pos, FluidStackLike stack, Direction side, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        ResourceHandler handler = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, pos, (Object)side);
        if (handler == null) {
            return stack;
        }
        FluidStack fluidStack = MachineStorageNeoForge.toForge(stack);
        FluidResource fluidResource = FluidResource.of((FluidStack)fluidStack);
        if (fluidResource.isEmpty()) {
            return stack;
        }
        try (Transaction transaction = Transaction.openRoot();){
            int inserted = handler.insert((Resource)fluidResource, fluidStack.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            if (inserted == 0) {
                FluidStackLike fluidStackLike = stack;
                return fluidStackLike;
            }
            if (stack.amount() <= (long)inserted) {
                FluidStackLike fluidStackLike = FluidStackLike.EMPTY;
                return fluidStackLike;
            }
            FluidStackLike fluidStackLike = stack.withAmount(stack.amount() - MachineStorageNeoForge.fromForgeAmount(inserted));
            return fluidStackLike;
        }
    }
}

