/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.neoforge.machine;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.MachineStorageFactory;
import com.yogpc.qp.machine.MachineStorageHolder;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class MachineStorageNeoForge
extends MachineStorage {
    public static FluidStack toForge(FluidStackLike f) {
        return new FluidStack(f.fluid(), Math.clamp(f.amount() * 1000L / 81000L, 0, Integer.MAX_VALUE), f.patch());
    }

    public static FluidStackLike toCommon(FluidStack f) {
        return new FluidStackLike(f.getFluid(), MachineStorageNeoForge.fromForgeAmount(f.getAmount()), f.getComponentsPatch());
    }

    public static long fromForgeAmount(int fluidStackAmount) {
        return (long)fluidStackAmount * 81000L / 1000L;
    }

    public static <T> ResourceHandler<ItemResource> createItemHandler(MachineStorageHolder<T> holder, T object) {
        return new ItemStorageImpl<T>(holder, object);
    }

    public static <T> ResourceHandler<FluidResource> createFluidHandler(MachineStorageHolder<T> holder, T object) {
        return new FluidStorageImpl<T>(holder, object);
    }

    private static final class ItemStorageImpl<T>
    extends SnapshotJournal<Object2LongLinkedOpenHashMap<MachineStorage.ItemKey>>
    implements ResourceHandler<ItemResource> {
        private final MachineStorageHolder<T> holder;
        private final T object;

        private ItemStorageImpl(MachineStorageHolder<T> holder, T object) {
            this.holder = holder;
            this.object = object;
        }

        private MachineStorageNeoForge storage() {
            return (MachineStorageNeoForge)this.holder.getMachineStorage(this.object);
        }

        public int size() {
            return this.storage().itemSlots() + 1;
        }

        public ItemResource getResource(int index) {
            return ItemResource.of((ItemStack)this.storage().getItemByIndex(index));
        }

        public long getAmountAsLong(int index) {
            return this.storage().getItemByIndex(index).getCount();
        }

        public long getCapacityAsLong(int index, ItemResource resource) {
            return Long.MAX_VALUE;
        }

        public boolean isValid(int index, ItemResource resource) {
            return true;
        }

        public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            this.storage().addItem(resource.toStack(amount));
            return amount;
        }

        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            return this.storage().extractItemByIndex(index, amount, true).getCount();
        }

        protected Object2LongLinkedOpenHashMap<MachineStorage.ItemKey> createSnapshot() {
            return this.storage().items;
        }

        protected void revertToSnapshot(Object2LongLinkedOpenHashMap<MachineStorage.ItemKey> snapshot) {
            this.storage().items.clear();
            this.storage().items.putAll(snapshot);
        }
    }

    private static final class FluidStorageImpl<T>
    extends SnapshotJournal<Object2LongLinkedOpenHashMap<MachineStorage.FluidKey>>
    implements ResourceHandler<FluidResource> {
        private final MachineStorageHolder<T> holder;
        private final T object;

        private FluidStorageImpl(MachineStorageHolder<T> holder, T object) {
            this.holder = holder;
            this.object = object;
        }

        private MachineStorageNeoForge storage() {
            return (MachineStorageNeoForge)this.holder.getMachineStorage(this.object);
        }

        public int size() {
            return this.storage().fluidTanks() + 1;
        }

        public FluidResource getResource(int index) {
            FluidStackLike fluidStackLike = this.storage().getFluidByIndex(index);
            if (fluidStackLike.isEmpty()) {
                return FluidResource.EMPTY;
            }
            return FluidResource.of((FluidStack)MachineStorageNeoForge.toForge(fluidStackLike));
        }

        public long getAmountAsLong(int index) {
            return MachineStorageNeoForge.toForge(this.storage().getFluidByIndex(index)).getAmount();
        }

        public long getCapacityAsLong(int index, FluidResource resource) {
            return Long.MAX_VALUE;
        }

        public boolean isValid(int index, FluidResource resource) {
            return true;
        }

        public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            FluidStack fluidStack = resource.toStack(amount);
            MachineStorage.FluidKey key = new MachineStorage.FluidKey(fluidStack.getFluid(), fluidStack.getComponentsPatch());
            this.storage().fluids.addTo((Object)key, MachineStorageNeoForge.fromForgeAmount(amount));
            return amount;
        }

        public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            FluidStackLike drained = this.storage().drainFluidByIndex(index, MachineStorageNeoForge.fromForgeAmount(amount), true);
            return MachineStorageNeoForge.toForge(drained).getAmount();
        }

        protected Object2LongLinkedOpenHashMap<MachineStorage.FluidKey> createSnapshot() {
            return this.storage().fluids;
        }

        protected void revertToSnapshot(Object2LongLinkedOpenHashMap<MachineStorage.FluidKey> snapshot) {
            this.storage().fluids.clear();
            this.storage().fluids.putAll(snapshot);
        }
    }

    public static class Factory
    implements MachineStorageFactory {
        @Override
        public MachineStorage createMachineStorage() {
            return new MachineStorageNeoForge();
        }
    }
}

