/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machine.marker.FlexibleMarkerEntity;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.RenderMarker;
import com.yogpc.qp.render.Sprites;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RenderFlexibleMarker
implements BlockEntityRenderer<FlexibleMarkerEntity, RenderFlexibleMarkerState> {
    public RenderFlexibleMarker(BlockEntityRendererProvider.Context context) {
    }

    public RenderFlexibleMarkerState createRenderState() {
        return new RenderFlexibleMarkerState();
    }

    public void extractRenderState(FlexibleMarkerEntity blockEntity, RenderFlexibleMarkerState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.extract(blockEntity);
    }

    public void submit(RenderFlexibleMarkerState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("quarryplus");
        profiler.push("flexible_marker");
        FlexibleMarkerEntity marker = renderState.marker;
        poseStack.pushPose();
        BlockPos markerPos = marker.getBlockPos();
        poseStack.translate((float)(-markerPos.getX()), (float)(-markerPos.getY()), (float)(-markerPos.getZ()));
        nodeCollector.submitCustomGeometry(poseStack, RenderType.cutout(), (pose, vertexConsumer) -> {
            Direction direction = marker.getDirection();
            double a = 0.5;
            double c = 0.375;
            if (direction != null) {
                AABB bb = direction.getAxis() == Direction.Axis.X ? new AABB((double)markerPos.getX() - 0.375 + 0.5, (double)markerPos.getY() + 0.5, (double)markerPos.getZ() + 0.5, (double)markerPos.getX() + 0.375 + 0.5, (double)markerPos.getY() + 0.5, (double)markerPos.getZ() + 0.5) : new AABB((double)markerPos.getX() + 0.5, (double)markerPos.getY() + 0.5, (double)markerPos.getZ() - 0.375 + 0.5, (double)markerPos.getX() + 0.5, (double)markerPos.getY() + 0.5, (double)markerPos.getZ() + 0.375 + 0.5);
                Box directionBox = Box.apply(bb.move(Vec3.atLowerCornerOf((Vec3i)direction.getUnitVec3i()).scale(0.5)), 0.125, 0.125, 0.125, true, true);
                directionBox.render(vertexConsumer, pose, Sprites.INSTANCE.getWhite(), ColorBox.blueColor);
            }
            marker.getLink().ifPresent(link -> RenderMarker.renderLink(pose, vertexConsumer, link, ColorBox.redColor));
        });
        poseStack.popPose();
        profiler.pop();
        profiler.pop();
    }

    public static class RenderFlexibleMarkerState
    extends BlockEntityRenderState {
        private FlexibleMarkerEntity marker;

        void extract(FlexibleMarkerEntity marker) {
            this.marker = marker;
        }
    }
}

