/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.marker.NormalMarkerEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RenderMarker
implements BlockEntityRenderer<NormalMarkerEntity, RenderMarkerState> {
    private static final double a = 0.5;
    private static final double b = 0.625;
    private static final double c = 0.375;

    public RenderMarker(BlockEntityRendererProvider.Context context) {
    }

    public RenderMarkerState createRenderState() {
        return new RenderMarkerState();
    }

    public void extractRenderState(NormalMarkerEntity blockEntity, RenderMarkerState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.extract(blockEntity);
    }

    public void submit(RenderMarkerState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("quarryplus");
        profiler.push("RenderMarker");
        NormalMarkerEntity blockEntity = renderState.marker;
        if (blockEntity.getStatus() == NormalMarkerEntity.Status.CONNECTED_MASTER) {
            BlockPos markerPos = blockEntity.getBlockPos();
            poseStack.pushPose();
            poseStack.translate((float)(-markerPos.getX()), (float)(-markerPos.getY()), (float)(-markerPos.getZ()));
            nodeCollector.submitCustomGeometry(poseStack, RenderType.cutout(), (pose, vertexConsumer) -> blockEntity.getLink().ifPresent(link -> RenderMarker.renderLink(pose, vertexConsumer, link, ColorBox.markerBlueColor)));
            poseStack.popPose();
        }
        profiler.pop();
        profiler.pop();
    }

    static void renderLink(PoseStack.Pose pose, VertexConsumer buffer, QuarryMarker.Link link, ColorBox color) {
        TextureAtlasSprite sprite = Sprites.INSTANCE.getWhite();
        for (Box box : RenderMarker.getRenderBox(link.area())) {
            box.render(buffer, pose, sprite, color);
        }
    }

    public static List<Box> getRenderBox(Area area) {
        int flag = 0;
        int xMin = area.minX();
        int yMin = area.minY();
        int zMin = area.minZ();
        int xMax = area.maxX();
        int yMax = area.maxY();
        int zMax = area.maxZ();
        if (xMin != xMax) {
            flag |= 1;
        }
        if (yMin != yMax) {
            flag |= 2;
        }
        if (zMin != zMax) {
            flag |= 4;
        }
        ArrayList<AABB> boxes = new ArrayList<AABB>(12);
        if ((flag & 1) == 1) {
            boxes.add(new AABB((double)xMin + 0.625, (double)yMin + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMin + 0.5));
        }
        if ((flag & 2) == 2) {
            boxes.add(new AABB((double)xMin + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMin + 0.5));
        }
        if ((flag & 4) == 4) {
            boxes.add(new AABB((double)xMin + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMin + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 3) == 3) {
            boxes.add(new AABB((double)xMin + 0.625, (double)yMax + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMin + 0.5));
            boxes.add(new AABB((double)xMax + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMin + 0.5));
        }
        if ((flag & 5) == 5) {
            boxes.add(new AABB((double)xMin + 0.625, (double)yMin + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMax + 0.5));
            boxes.add(new AABB((double)xMax + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMin + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 6) == 6) {
            boxes.add(new AABB((double)xMin + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMax + 0.5));
            boxes.add(new AABB((double)xMin + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMax + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 7) == 7) {
            boxes.add(new AABB((double)xMin + 0.625, (double)yMax + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMax + 0.5));
            boxes.add(new AABB((double)xMax + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMax + 0.5));
            boxes.add(new AABB((double)xMax + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMax + 0.5, (double)zMax + 0.375));
        }
        return boxes.stream().map(range -> Box.apply(range, Math.max(range.getXsize(), 0.126), Math.max(range.getYsize(), 0.126), Math.max(range.getZsize(), 0.126), true, true)).toList();
    }

    public static class RenderMarkerState
    extends BlockEntityRenderState {
        private NormalMarkerEntity marker;

        void extract(NormalMarkerEntity marker) {
            this.marker = marker;
        }
    }
}

