/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.forge;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.InCreativeTabs;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.config.ConfigHolder;
import com.yogpc.qp.config.EnableMap;
import com.yogpc.qp.config.QuarryConfig;
import com.yogpc.qp.forge.MiningForge;
import com.yogpc.qp.forge.TransferForge;
import com.yogpc.qp.forge.machine.advquarry.AdvQuarryEntityForge;
import com.yogpc.qp.forge.machine.marker.ChunkMarkerEntityForge;
import com.yogpc.qp.forge.machine.marker.FlexibleMarkerEntityForge;
import com.yogpc.qp.forge.machine.marker.NormalMarkerEntityForge;
import com.yogpc.qp.forge.machine.misc.CheckerItemForge;
import com.yogpc.qp.forge.machine.misc.YSetterItemForge;
import com.yogpc.qp.forge.machine.quarry.QuarryBlockForge;
import com.yogpc.qp.forge.machine.quarry.QuarryEntityForge;
import com.yogpc.qp.forge.packet.PacketHandler;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.MachineLootFunction;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.advquarry.AdvQuarryBlock;
import com.yogpc.qp.machine.advquarry.AdvQuarryContainer;
import com.yogpc.qp.machine.exp.ExpModuleItem;
import com.yogpc.qp.machine.marker.ChunkMarkerBlock;
import com.yogpc.qp.machine.marker.FlexibleMarkerBlock;
import com.yogpc.qp.machine.marker.MarkerContainer;
import com.yogpc.qp.machine.marker.NormalMarkerBlock;
import com.yogpc.qp.machine.misc.FrameBlock;
import com.yogpc.qp.machine.misc.GeneratorBlock;
import com.yogpc.qp.machine.misc.GeneratorEntity;
import com.yogpc.qp.machine.misc.SoftBlock;
import com.yogpc.qp.machine.misc.YSetterContainer;
import com.yogpc.qp.machine.module.BedrockModuleItem;
import com.yogpc.qp.machine.module.FilterModuleContainer;
import com.yogpc.qp.machine.module.FilterModuleItem;
import com.yogpc.qp.machine.module.ModuleContainer;
import com.yogpc.qp.machine.module.PumpModuleItem;
import com.yogpc.qp.machine.module.RepeatTickModuleItem;
import com.yogpc.qp.machine.mover.MoverBlock;
import com.yogpc.qp.machine.mover.MoverContainer;
import com.yogpc.qp.machine.mover.MoverEntity;
import com.yogpc.qp.machine.placer.PlacerBlock;
import com.yogpc.qp.machine.placer.PlacerContainer;
import com.yogpc.qp.machine.placer.PlacerEntity;
import com.yogpc.qp.machine.placer.RemotePlacerBlock;
import com.yogpc.qp.machine.placer.RemotePlacerEntity;
import com.yogpc.qp.machine.quarry.QuarryBlock;
import com.yogpc.qp.machine.storage.DebugStorageBlock;
import com.yogpc.qp.machine.storage.DebugStorageContainer;
import com.yogpc.qp.machine.storage.DebugStorageEntity;
import com.yogpc.qp.recipe.FilterModuleExpandRecipe;
import com.yogpc.qp.recipe.InstallBedrockModuleRecipe;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.util.Lazy;

public final class PlatformAccessForge
implements PlatformAccess {
    private final Lazy<PlatformAccess.RegisterObjects> itemsLazy = Lazy.lazy(RegisterObjectsForge::new);
    private final Lazy<PacketHandler> packetHandlerLazy = Lazy.lazy(PacketHandler::new);
    private final Lazy<TransferForge> transferLazy = Lazy.lazy(TransferForge::new);
    private final ConfigHolder configLazy = new ConfigHolder(() -> QuarryConfig.load(this.configPath(), this::isInDevelopmentEnvironment));
    private final Lazy<PlatformAccess.Mining> miningLazy = Lazy.lazy(MiningForge::new);

    public PlatformAccessForge() {
        ServerStoppedEvent.BUS.addListener(this::onWorldUnload);
    }

    @Override
    public String platformName() {
        return "Forge";
    }

    @Override
    public PlatformAccess.RegisterObjects registerObjects() {
        return (PlatformAccess.RegisterObjects)this.itemsLazy.get();
    }

    @Override
    public PlatformAccess.Packet packetHandler() {
        return (PlatformAccess.Packet)this.packetHandlerLazy.get();
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get().resolve("%s.toml".formatted("quarryplus"));
    }

    @Override
    public Supplier<? extends QuarryConfig> getConfig() {
        return this.configLazy;
    }

    @Override
    public boolean isInDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    @Override
    public PlatformAccess.Transfer transfer() {
        return (PlatformAccess.Transfer)this.transferLazy.get();
    }

    @Override
    public FluidStackLike getFluidInItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            if (!stack.is(Items.BUCKET)) {
                return new FluidStackLike(bucketItem.getFluid(), 81000L, DataComponentPatch.EMPTY);
            }
        }
        return FluidStackLike.EMPTY;
    }

    @Override
    public Component getFluidName(FluidStackLike stack) {
        FluidStack s = new FluidStack(stack.fluid(), Math.clamp(stack.amount(), 0, Integer.MAX_VALUE));
        return s.getDisplayName();
    }

    @Override
    public <T extends AbstractContainerMenu> void openGui(ServerPlayer player, GeneralScreenHandler<T> handler) {
        player.openMenu(handler, handler.pos());
    }

    @Override
    public PlatformAccess.Mining mining() {
        return (PlatformAccess.Mining)this.miningLazy.get();
    }

    public void onWorldUnload(ServerStoppedEvent event) {
        this.configLazy.reset();
    }

    public static class RegisterObjectsForge
    implements PlatformAccess.RegisterObjects {
        private static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"quarryplus");
        private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"quarryplus");
        private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"quarryplus");
        private static final DeferredRegister<RecipeSerializer<?>> RECIPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"quarryplus");
        private static final DeferredRegister<IIngredientSerializer<?>> INGREDIENT_REGISTER = DeferredRegister.create((DeferredRegister.RegistryHolder)ForgeRegistries.INGREDIENT_SERIALIZERS, (String)"quarryplus");
        private static final DeferredRegister<CreativeModeTab> CREATIVE_TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"quarryplus");
        private static final DeferredRegister<LootItemFunctionType<?>> LOOT_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)"quarryplus");
        private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"quarryplus");
        private static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"quarryplus");
        static final List<DeferredRegister<?>> REGISTER_LIST = List.of(BLOCK_REGISTER, ITEM_REGISTER, BLOCK_ENTITY_REGISTER, RECIPE_REGISTER, INGREDIENT_REGISTER, CREATIVE_TAB_REGISTER, LOOT_TYPE_REGISTER, DATA_COMPONENT_TYPE_REGISTER, MENU_TYPE_REGISTER);
        private static final Map<ResourceLocation, Supplier<? extends InCreativeTabs>> TAB_ITEMS = new HashMap<ResourceLocation, Supplier<? extends InCreativeTabs>>();
        private static final Map<String, EnableMap.EnableOrNot> ENABLE_MAP = new HashMap<String, EnableMap.EnableOrNot>();
        public static final RegistryObject<QuarryBlockForge> BLOCK_QUARRY = RegisterObjectsForge.registerBlock("quarry", QuarryBlockForge::new);
        public static final RegistryObject<AdvQuarryBlock> BLOCK_ADV_QUARRY = RegisterObjectsForge.registerBlock("adv_quarry", AdvQuarryBlock::new);
        public static final RegistryObject<GeneratorBlock> BLOCK_GENERATOR = RegisterObjectsForge.registerBlock("creative_generator", GeneratorBlock::new);
        public static final RegistryObject<MoverBlock> BLOCK_MOVER = RegisterObjectsForge.registerBlock("mover", MoverBlock::new);
        public static final RegistryObject<PlacerBlock> BLOCK_PLACER = RegisterObjectsForge.registerBlock("placer_plus", PlacerBlock::new);
        public static final RegistryObject<RemotePlacerBlock> BLOCK_REMOTE_PLACER = RegisterObjectsForge.registerBlock("remote_placer", RemotePlacerBlock::new);
        public static final RegistryObject<NormalMarkerBlock> BLOCK_MARKER = RegisterObjectsForge.registerBlock("marker", NormalMarkerBlock::new);
        public static final RegistryObject<FlexibleMarkerBlock> BLOCK_FLEXIBLE_MARKER = RegisterObjectsForge.registerBlock("flexible_marker", FlexibleMarkerBlock::new);
        public static final RegistryObject<ChunkMarkerBlock> BLOCK_CHUNK_MARKER = RegisterObjectsForge.registerBlock("chunk_marker", ChunkMarkerBlock::new);
        public static final RegistryObject<PumpModuleItem> ITEM_PUMP_MODULE = RegisterObjectsForge.registerItem("pump_module", PumpModuleItem::new, EnableMap.EnableOrNot.CONFIG_ON);
        public static final RegistryObject<BedrockModuleItem> ITEM_BEDROCK_MODULE = RegisterObjectsForge.registerItem("remove_bedrock_module", BedrockModuleItem::new, EnableMap.EnableOrNot.CONFIG_ON);
        public static final RegistryObject<ExpModuleItem> ITEM_EXP_MODULE = RegisterObjectsForge.registerItem("exp_module", ExpModuleItem::new, EnableMap.EnableOrNot.CONFIG_ON);
        public static final RegistryObject<RepeatTickModuleItem> ITEM_REPEAT_MODULE = RegisterObjectsForge.registerItem("repeat_tick_module", RepeatTickModuleItem::new, EnableMap.EnableOrNot.CONFIG_OFF);
        public static final RegistryObject<FilterModuleItem> ITEM_FILTER_MODULE = RegisterObjectsForge.registerItem("filter_module", FilterModuleItem::new, EnableMap.EnableOrNot.CONFIG_ON);
        public static final RegistryObject<CheckerItemForge> ITEM_CHECKER = RegisterObjectsForge.registerItem("status_checker", CheckerItemForge::new, EnableMap.EnableOrNot.ALWAYS_ON);
        public static final RegistryObject<YSetterItemForge> ITEM_Y_SET = RegisterObjectsForge.registerItem("y_setter", YSetterItemForge::new, EnableMap.EnableOrNot.ALWAYS_ON);
        public static final RegistryObject<FrameBlock> BLOCK_FRAME = RegisterObjectsForge.registerBlock("frame", FrameBlock::new);
        public static final RegistryObject<SoftBlock> BLOCK_SOFT = RegisterObjectsForge.registerBlock("soft_block", SoftBlock::new, b -> b.blockItem);
        public static final RegistryObject<DebugStorageBlock> BLOCK_DEBUG_STORAGE = RegisterObjectsForge.registerBlock("debug_storage", DebugStorageBlock::new);
        private static final Map<Class<? extends QpBlock>, Supplier<BlockEntityType<?>>> BLOCK_ENTITY_TYPES = new HashMap();
        public static final RegistryObject<BlockEntityType<QuarryEntityForge>> QUARRY_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"quarry", BLOCK_QUARRY, QuarryEntityForge::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new QuarryBlockForge[0]);
        public static final RegistryObject<BlockEntityType<GeneratorEntity>> GENERATOR_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"creative_generator", BLOCK_GENERATOR, GeneratorEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.ALWAYS_ON, (QpBlock[])new GeneratorBlock[0]);
        public static final RegistryObject<BlockEntityType<NormalMarkerEntityForge>> MARKER_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"marker", BLOCK_MARKER, NormalMarkerEntityForge::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.ALWAYS_ON, (QpBlock[])new NormalMarkerBlock[0]);
        public static final RegistryObject<BlockEntityType<MoverEntity>> MOVER_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"mover", BLOCK_MOVER, MoverEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new MoverBlock[0]);
        public static final RegistryObject<BlockEntityType<FlexibleMarkerEntityForge>> FLEXIBLE_MARKER_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"flexible_marker", BLOCK_FLEXIBLE_MARKER, FlexibleMarkerEntityForge::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new FlexibleMarkerBlock[0]);
        public static final RegistryObject<BlockEntityType<ChunkMarkerEntityForge>> CHUNK_MARKER_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"chunk_marker", BLOCK_CHUNK_MARKER, ChunkMarkerEntityForge::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new ChunkMarkerBlock[0]);
        public static final RegistryObject<BlockEntityType<DebugStorageEntity>> DEBUG_STORAGE_TYPE = RegisterObjectsForge.registerBlockEntity((String)"debug_storage", BLOCK_DEBUG_STORAGE, DebugStorageEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.ALWAYS_ON, (QpBlock[])new DebugStorageBlock[0]);
        public static final RegistryObject<BlockEntityType<AdvQuarryEntityForge>> ADV_QUARRY_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"adv_quarry", BLOCK_ADV_QUARRY, AdvQuarryEntityForge::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new AdvQuarryBlock[0]);
        public static final RegistryObject<BlockEntityType<PlacerEntity>> PLACER_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"placer_plus", BLOCK_PLACER, PlacerEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new PlacerBlock[0]);
        public static final RegistryObject<BlockEntityType<RemotePlacerEntity>> REMOTE_PLACER_ENTITY_TYPE = RegisterObjectsForge.registerBlockEntity((String)"remote_placer", BLOCK_REMOTE_PLACER, RemotePlacerEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_OFF, (QpBlock[])new RemotePlacerBlock[0]);
        public static final RegistryObject<MenuType<? extends YSetterContainer>> Y_SET_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_y_setter", YSetterContainer::new);
        public static final RegistryObject<MenuType<? extends MoverContainer>> MOVER_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_mover", MoverContainer::new);
        public static final RegistryObject<MenuType<? extends ModuleContainer>> MODULE_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_quarry_module", ModuleContainer::new);
        public static final RegistryObject<MenuType<? extends MarkerContainer>> FLEXIBLE_MARKER_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_flexible_marker", MarkerContainer::createFlexibleMarkerContainer);
        public static final RegistryObject<MenuType<? extends MarkerContainer>> CHUNK_MARKER_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_chunk_marker", MarkerContainer::createChunkMarkerContainer);
        public static final RegistryObject<MenuType<? extends DebugStorageContainer>> DEBUG_STORAGE_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_debug_storage", DebugStorageContainer::new);
        public static final RegistryObject<MenuType<? extends AdvQuarryContainer>> ADV_QUARRY_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_adv_quarry", AdvQuarryContainer::new);
        public static final RegistryObject<MenuType<? extends FilterModuleContainer>> FILTER_MODULE_MENU_TYPE = MENU_TYPE_REGISTER.register("gui_filter_module", () -> IForgeMenuType.create((windowId, inv, data) -> new FilterModuleContainer(windowId, inv, inv.getSelectedItem())));
        public static final RegistryObject<MenuType<? extends PlacerContainer>> PLACER_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_placer_plus", PlacerContainer::createPlacerContainer);
        public static final RegistryObject<MenuType<? extends PlacerContainer>> REMOTE_PLACER_MENU_TYPE = RegisterObjectsForge.registerMenu("gui_remote_placer", PlacerContainer::createRemotePlacerContainer);
        public static final RegistryObject<LootItemFunctionType<? extends MachineLootFunction>> MACHINE_LOOT_FUNCTION = LOOT_TYPE_REGISTER.register("machine_loot_function", () -> new LootItemFunctionType(MachineLootFunction.SERIALIZER));
        public static final RegistryObject<CreativeModeTab> CREATIVE_MODE_TAB = CREATIVE_TAB_REGISTER.register("quarryplus", () -> QuarryPlus.buildCreativeModeTab(CreativeModeTab.builder()).build());
        public static final RegistryObject<RecipeSerializer<InstallBedrockModuleRecipe>> INSTALL_BEDROCK_MODULE_RECIPE = RECIPE_REGISTER.register("install_bedrock_module_recipe", () -> InstallBedrockModuleRecipe.SERIALIZER);
        public static final RegistryObject<RecipeSerializer<FilterModuleExpandRecipe>> FILTER_MODULE_EXPAND_RECIPE = RECIPE_REGISTER.register(FilterModuleExpandRecipe.LOCATION.getPath(), () -> FilterModuleExpandRecipe.SERIALIZER);

        private static <T extends QpBlock> RegistryObject<T> registerBlock(String name, Supplier<T> supplier) {
            return RegisterObjectsForge.registerBlock(name, supplier, b -> b.blockItem);
        }

        private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> supplier, Function<T, ? extends BlockItem> itemGetter) {
            RegistryObject block = BLOCK_REGISTER.register(name, supplier);
            ITEM_REGISTER.register(name, () -> (BlockItem)itemGetter.apply((Block)block.get()));
            TAB_ITEMS.put(ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)name), (Supplier<? extends InCreativeTabs>)block);
            return block;
        }

        private static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> supplier, EnableMap.EnableOrNot enableOrNot) {
            RegistryObject item = ITEM_REGISTER.register(name, supplier);
            TAB_ITEMS.put(ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)name), (Supplier<? extends InCreativeTabs>)item);
            ENABLE_MAP.put(name, enableOrNot);
            return item;
        }

        @SafeVarargs
        private static <T extends QpBlock, U extends BlockEntity> RegistryObject<BlockEntityType<U>> registerBlockEntity(String name, RegistryObject<T> block, BlockEntityType.BlockEntitySupplier<U> factory, EnableMap.EnableOrNot enableOrNot, T ... dummy) {
            RegistryObject entityType = BLOCK_ENTITY_REGISTER.register(name, () -> new BlockEntityType(factory, Set.of((Block)block.get())));
            BLOCK_ENTITY_TYPES.put((Class<? extends QpBlock>)dummy.getClass().componentType(), (Supplier)entityType);
            ENABLE_MAP.put(name, enableOrNot);
            return entityType;
        }

        private static <T extends AbstractContainerMenu> RegistryObject<MenuType<? extends T>> registerMenu(String name, GeneralScreenHandler.ContainerFactory<T> factory) {
            return MENU_TYPE_REGISTER.register(name, () -> IForgeMenuType.create((i, inventory, friendlyByteBuf) -> factory.create(i, inventory, friendlyByteBuf.readBlockPos())));
        }

        @Override
        public Supplier<? extends QuarryBlock> quarryBlock() {
            return BLOCK_QUARRY;
        }

        @Override
        public Supplier<? extends FrameBlock> frameBlock() {
            return BLOCK_FRAME;
        }

        @Override
        public Supplier<? extends GeneratorBlock> generatorBlock() {
            return BLOCK_GENERATOR;
        }

        @Override
        public Supplier<? extends NormalMarkerBlock> markerBlock() {
            return BLOCK_MARKER;
        }

        @Override
        public Supplier<? extends MoverBlock> moverBlock() {
            return BLOCK_MOVER;
        }

        @Override
        public Supplier<? extends FlexibleMarkerBlock> flexibleMarkerBlock() {
            return BLOCK_FLEXIBLE_MARKER;
        }

        @Override
        public Supplier<? extends ChunkMarkerBlock> chunkMarkerBlock() {
            return BLOCK_CHUNK_MARKER;
        }

        @Override
        public Supplier<? extends DebugStorageBlock> debugStorageBlock() {
            return BLOCK_DEBUG_STORAGE;
        }

        @Override
        public Supplier<? extends AdvQuarryBlock> advQuarryBlock() {
            return BLOCK_ADV_QUARRY;
        }

        @Override
        public Supplier<? extends SoftBlock> softBlock() {
            return BLOCK_SOFT;
        }

        @Override
        public Supplier<? extends PlacerBlock> placerBlock() {
            return BLOCK_PLACER;
        }

        @Override
        public Supplier<? extends RemotePlacerBlock> remotePlacerBlock() {
            return BLOCK_REMOTE_PLACER;
        }

        @Override
        public Optional<BlockEntityType<?>> getBlockEntityType(QpBlock block) {
            Supplier<BlockEntityType<?>> t = BLOCK_ENTITY_TYPES.get(block.getClass());
            if (t == null) {
                QuarryPlus.LOGGER.warn("Unknown block type: {}", (Object)block.name);
                return Optional.empty();
            }
            return Optional.of(t.get());
        }

        @Override
        public Map<String, EnableMap.EnableOrNot> defaultEnableSetting() {
            return ENABLE_MAP;
        }

        @Override
        public Supplier<? extends BedrockModuleItem> bedrockModuleItem() {
            return ITEM_BEDROCK_MODULE;
        }

        @Override
        public Supplier<? extends FilterModuleItem> filterModuleItem() {
            return ITEM_FILTER_MODULE;
        }

        @Override
        public Stream<Map.Entry<ResourceLocation, Supplier<? extends InCreativeTabs>>> allItems() {
            return TAB_ITEMS.entrySet().stream();
        }

        @Override
        public Supplier<MenuType<? extends YSetterContainer>> ySetterContainer() {
            return Y_SET_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends MoverContainer>> moverContainer() {
            return MOVER_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends ModuleContainer>> moduleContainer() {
            return MODULE_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends MarkerContainer>> flexibleMarkerContainer() {
            return FLEXIBLE_MARKER_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends MarkerContainer>> chunkMarkerContainer() {
            return CHUNK_MARKER_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends DebugStorageContainer>> debugStorageContainer() {
            return DEBUG_STORAGE_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends AdvQuarryContainer>> advQuarryContainer() {
            return ADV_QUARRY_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends FilterModuleContainer>> filterModuleContainer() {
            return FILTER_MODULE_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends PlacerContainer>> placerContainer() {
            return PLACER_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends PlacerContainer>> remotePlacerContainer() {
            return REMOTE_PLACER_MENU_TYPE;
        }

        @Override
        public Supplier<LootItemFunctionType<? extends MachineLootFunction>> machineLootFunction() {
            return MACHINE_LOOT_FUNCTION;
        }

        static {
            for (Map.Entry<ResourceLocation, DataComponentType<?>> e : QuarryDataComponents.ALL.entrySet()) {
                DATA_COMPONENT_TYPE_REGISTER.register(e.getKey().getPath(), e::getValue);
            }
        }
    }
}

