/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.forge.integration;

import com.yogpc.qp.machine.PowerEntity;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnergyIntegration {
    public static final ResourceLocation POWER_ENTITY_STORAGE = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"power_entity_storage");

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent.BlockEntities event) {
        BlockEntity blockEntity = event.getObject();
        if (blockEntity instanceof PowerEntity) {
            PowerEntity e = (PowerEntity)blockEntity;
            event.addCapability(POWER_ENTITY_STORAGE, (ICapabilityProvider)new PowerEntityStorage(e));
        }
    }

    record PowerEntityStorage(PowerEntity entity) implements IEnergyStorage,
    ICapabilityProvider
    {
        static int clamp(long value) {
            return Math.clamp(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            long received = this.entity.addEnergy((long)maxReceive * 1000000000L, simulate);
            return PowerEntityStorage.clamp(received / 1000000000L);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return PowerEntityStorage.clamp(this.entity.getEnergy() / 1000000000L);
        }

        public int getMaxEnergyStored() {
            return PowerEntityStorage.clamp(this.entity.getMaxEnergy() / 1000000000L);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, LazyOptional.of(() -> this));
        }
    }
}

