/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.forge.integration;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.MachineStorageHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MachineStorageHandler<T>(MachineStorageHolder<T> holder, T object) implements IItemHandler,
IFluidHandler,
ICapabilityProvider
{
    private MachineStorage storage() {
        return this.holder.getMachineStorage(this.object);
    }

    static FluidStack toForge(FluidStackLike f) {
        return new FluidStack(f.fluid(), Math.clamp(f.amount() * 1000L / 81000L, 0, Integer.MAX_VALUE));
    }

    static FluidStackLike toCommon(FluidStack f) {
        return new FluidStackLike(f.getFluid(), (long)f.getAmount() * 81000L / 1000L, DataComponentPatch.EMPTY);
    }

    public int getTanks() {
        return this.storage().fluidTanks() + 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        FluidStackLike f = this.storage().getFluidByIndex(tank);
        return MachineStorageHandler.toForge(f);
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (action.execute()) {
            this.storage().addFluid(resource.getFluid(), resource.getAmount());
        }
        return resource.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStackLike drained = this.storage().drainFluid(MachineStorageHandler.toCommon(resource), action.execute());
        return MachineStorageHandler.toForge(drained);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStackLike drained = this.storage().drainFluidByIndex(0, maxDrain, action.execute());
        return MachineStorageHandler.toForge(drained);
    }

    public int getSlots() {
        return this.storage().itemSlots() + 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.storage().getItemByIndex(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!simulate) {
            this.storage().addItem(stack);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.storage().extractItemByIndex(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public <S> LazyOptional<S> getCapability(@NotNull Capability<S> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> this));
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> this));
        }
        return LazyOptional.empty();
    }
}

