/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.forge.machine;

import com.yogpc.qp.machine.QuarryFakePlayerCommon;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class QuarryFakePlayer {
    private static final Map<ServerLevel, ServerPlayer> players;

    public static ServerPlayer get(ServerLevel serverLevel) {
        return players.computeIfAbsent(serverLevel, key -> QuarryFakePlayerCommon.getOwnImplementation(key, s -> ServerLifecycleHooks.getCurrentServer()));
    }

    @SubscribeEvent(priority=127)
    public static void unloadLevel(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            players.entrySet().removeIf(entry -> ((ServerPlayer)entry.getValue()).level() == level);
        }
    }

    static {
        LevelEvent.Unload.BUS.addListener(QuarryFakePlayer::unloadLevel);
        players = new HashMap<ServerLevel, ServerPlayer>();
    }
}

