/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.forge.packet;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.advquarry.AdvActionActionMessage;
import com.yogpc.qp.machine.advquarry.AdvActionSyncMessage;
import com.yogpc.qp.machine.advquarry.AdvQuarryInitialAskMessage;
import com.yogpc.qp.machine.marker.ChunkMarkerMessage;
import com.yogpc.qp.machine.marker.FlexibleMarkerMessage;
import com.yogpc.qp.machine.mover.MoverMessage;
import com.yogpc.qp.machine.placer.RemotePlacerMessage;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import com.yogpc.qp.packet.YSetterMessage;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.network.simple.SimpleFlow;
import org.jetbrains.annotations.NotNull;

public final class PacketHandler
implements PlatformAccess.Packet {
    private static final int PROTOCOL = 1;
    private static final SimpleChannel CHANNEL = ((SimpleFlow)ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"main")).networkProtocolVersion(1).acceptedVersions(Channel.VersionTest.exact((int)1)).simpleChannel().play().bidirectional()).addMain(ClientSyncMessage.class, ClientSyncMessage.STREAM_CODEC, PacketHandler::onReceive).addMain(YSetterMessage.class, YSetterMessage.STREAM_CODEC, PacketHandler::onReceive).addMain(MoverMessage.class, MoverMessage.STREAM_CODEC, PacketHandler::onReceive).addMain(FlexibleMarkerMessage.class, FlexibleMarkerMessage.STREAM_CODEC, PacketHandler::onReceive).addMain(ChunkMarkerMessage.class, ChunkMarkerMessage.STREAM_CODEC, PacketHandler::onReceive).addMain(AdvActionActionMessage.class, AdvActionActionMessage.STREAM_CODEC, PacketHandler::onReceive).addMain(AdvActionSyncMessage.class, AdvActionSyncMessage.STREAM_CODEC, PacketHandler::onReceive).addMain(AdvQuarryInitialAskMessage.class, AdvQuarryInitialAskMessage.STREAM_CODEC, PacketHandler::onReceive).addMain(RemotePlacerMessage.class, RemotePlacerMessage.STREAM_CODEC, PacketHandler::onReceive).build();
    private static final Proxy PROXY = ProxyProvider.getInstance();

    public static void init() {
    }

    private static void onReceive(OnReceiveWithLevel message, CustomPayloadEvent.Context context) {
        PROXY.getPacketPlayer(context).ifPresent(player -> message.onReceive(player.level(), (Player)player));
    }

    @Override
    public void sendToClientWorld(@NotNull CustomPacketPayload message, @NotNull Level level) {
        if (level.getServer() instanceof GameTestServer) {
            QuarryPlus.LOGGER.debug("PacketHandler#sendToClientWorld is called in GameTestServer for {}", (Object)message.getClass().getSimpleName());
            return;
        }
        CHANNEL.send((Object)message, PacketDistributor.DIMENSION.with((Object)level.dimension()));
    }

    @Override
    public void sendToClientPlayer(@NotNull CustomPacketPayload message, @NotNull ServerPlayer player) {
        if (player.level().getServer() instanceof GameTestServer) {
            QuarryPlus.LOGGER.debug("PacketHandler#sendToClientPlayer is called in GameTestServer for {}", (Object)message.getClass().getSimpleName());
            return;
        }
        CHANNEL.send((Object)message, PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public void sendToServer(@NotNull CustomPacketPayload message) {
        CHANNEL.send((Object)message, PacketDistributor.SERVER.noArg());
    }

    private static abstract class Proxy {
        private Proxy() {
        }

        @NotNull
        abstract Optional<Player> getPacketPlayer(@NotNull CustomPayloadEvent.Context var1);
    }

    private static class ProxyProvider {
        private ProxyProvider() {
        }

        @NotNull
        private static Proxy getInstance() {
            return switch (FMLLoader.getDist()) {
                default -> throw new MatchException(null, null);
                case Dist.CLIENT -> new ClientSupplier().get();
                case Dist.DEDICATED_SERVER -> new ServerSupplier().get();
            };
        }

        private static class ClientSupplier {
            private ClientSupplier() {
            }

            Proxy get() {
                return new ProxyClient();
            }
        }

        private static class ServerSupplier {
            private ServerSupplier() {
            }

            Proxy get() {
                return new ProxyServer();
            }
        }
    }

    private static class ProxyClient
    extends Proxy {
        private ProxyClient() {
        }

        @Override
        @NotNull
        Optional<Player> getPacketPlayer(@NotNull CustomPayloadEvent.Context context) {
            return Optional.ofNullable(context.getSender()).or(() -> Optional.ofNullable(Minecraft.getInstance().player));
        }
    }

    private static class ProxyServer
    extends Proxy {
        private ProxyServer() {
        }

        @Override
        @NotNull
        Optional<Player> getPacketPlayer(@NotNull CustomPayloadEvent.Context context) {
            return Optional.ofNullable(context.getSender());
        }
    }
}

