/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.mover;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.packet.ClientSync;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class MoverEntity
extends QpEntity
implements ClientSync {
    final SimpleContainer inventory = new Inventory(2);
    List<Holder<Enchantment>> movableEnchantments = List.of();

    public MoverEntity(BlockPos pos, BlockState blockState) {
        super(PlatformAccess.getAccess().registerObjects().getBlockEntityType((QpBlock)blockState.getBlock()).orElseThrow(), pos, blockState);
        this.inventory.addListener(container -> this.setChanged());
    }

    protected void loadAdditional(ValueInput input) {
        this.inventory.fromItemList(input.listOrEmpty("inventory", ItemStack.CODEC));
        super.loadAdditional(input);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.inventory.storeAsItemList(output.list("inventory", ItemStack.CODEC));
    }

    @Override
    public void fromClientTag(ValueInput input) {
        this.movableEnchantments = input.listOrEmpty("enchantments", Enchantment.CODEC).stream().toList();
    }

    @Override
    public ValueOutput toClientTag(ValueOutput output) {
        ValueOutput.TypedOutputList enchantmentList = output.list("enchantments", Enchantment.CODEC);
        this.movableEnchantments.forEach(arg_0 -> ((ValueOutput.TypedOutputList)enchantmentList).add(arg_0));
        return output;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState blockState) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.inventory);
        }
    }

    public void setChanged() {
        super.setChanged();
        this.updateMovableEnchantments();
    }

    void updateMovableEnchantments() {
        if (this.level != null && !this.level.isClientSide() && this.enabled) {
            List<Holder<Enchantment>> pre = this.movableEnchantments;
            this.movableEnchantments = MoverEntity.getMovable(this.inventory.getItem(0), this.inventory.getItem(1), e -> true);
            if (!pre.equals(this.movableEnchantments)) {
                this.syncToClient();
            }
        }
    }

    @VisibleForTesting
    static List<Holder<Enchantment>> getMovable(ItemStack from, ItemStack to, Predicate<Holder<Enchantment>> predicate) {
        if (from.isEmpty() || to.isEmpty()) {
            return List.of();
        }
        ItemEnchantments given = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)to);
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)from).keySet().stream().filter(e -> MoverEntity.canMoveEnchantment(predicate, given, (Holder<Enchantment>)e)).sorted(Comparator.comparing(Holder::getRegisteredName)).toList();
    }

    @VisibleForTesting
    static boolean canMoveEnchantment(@Nullable Predicate<Holder<Enchantment>> predicate, ItemEnchantments given, Holder<Enchantment> toMove) {
        return (predicate == null || predicate.test(toMove)) && given.getLevel(toMove) < ((Enchantment)toMove.value()).getMaxLevel() && given.keySet().stream().filter(Predicate.isEqual(toMove).negate()).allMatch(e -> Enchantment.areCompatible((Holder)e, (Holder)toMove));
    }

    void moveEnchant(Holder<Enchantment> enchantment) {
        Pair<ItemStack, ItemStack> moved = MoverEntity.moveEnchantment(enchantment, this.inventory.getItem(0), this.inventory.getItem(1), this::updateMovableEnchantments);
        this.inventory.setItem(0, (ItemStack)moved.getLeft());
        this.inventory.setItem(1, (ItemStack)moved.getRight());
    }

    static Pair<ItemStack, ItemStack> moveEnchantment(@Nullable Holder<Enchantment> enchantment, ItemStack from, ItemStack to, Runnable after) {
        return MoverEntity.moveEnchantment(enchantment, from, to, null, after);
    }

    @VisibleForTesting
    static Pair<ItemStack, ItemStack> moveEnchantment(@Nullable Holder<Enchantment> enchantment, ItemStack from, ItemStack to, @Nullable Predicate<Holder<Enchantment>> predicate, Runnable after) {
        if (enchantment == null || from.isEmpty() || to.isEmpty()) {
            return Pair.of((Object)from, (Object)to);
        }
        if (MoverEntity.canMoveEnchantment(predicate, EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)to), enchantment)) {
            ItemStack right = MoverEntity.upLevel(enchantment, to);
            ItemStack left = MoverEntity.downLevel(enchantment, from);
            after.run();
            return Pair.of((Object)left, (Object)right);
        }
        return Pair.of((Object)from, (Object)to);
    }

    @VisibleForTesting
    static ItemStack downLevel(Holder<Enchantment> enchantment, ItemStack stack) {
        EnchantmentHelper.updateEnchantments((ItemStack)stack, mutable -> mutable.set(enchantment, mutable.getLevel(enchantment) - 1));
        if (stack.is(Items.ENCHANTED_BOOK) && EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).isEmpty()) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @VisibleForTesting
    static ItemStack upLevel(Holder<Enchantment> enchantment, ItemStack stack) {
        EnchantmentHelper.updateEnchantments((ItemStack)stack, mutable -> mutable.set(enchantment, mutable.getLevel(enchantment) + 1));
        return stack;
    }

    private static class Inventory
    extends SimpleContainer {
        public Inventory(int size) {
            super(size);
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.is(Items.ENCHANTED_BOOK)) {
                        yield true;
                    }
                    if (!stack.isEnchanted()) {
                        yield false;
                    }
                    if (stack.getItem() instanceof BowItem) {
                        yield true;
                    }
                    if (stack.has(DataComponents.TOOL) && stack.getMaxDamage() >= ToolMaterial.DIAMOND.durability()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (stack.is((Item)PlatformAccess.getAccess().registerObjects().quarryBlock().get().blockItem) || stack.is((Item)PlatformAccess.getAccess().registerObjects().advQuarryBlock().get().blockItem)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

