/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet;

import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientSyncMessage
implements CustomPacketPayload,
OnReceiveWithLevel {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"client_sync_message");
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSyncMessage.class);
    public static final CustomPacketPayload.Type<ClientSyncMessage> TYPE = new CustomPacketPayload.Type(NAME);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientSyncMessage> STREAM_CODEC = CustomPacketPayload.codec(ClientSyncMessage::write, ClientSyncMessage::new);
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final CompoundTag tag;

    public ClientSyncMessage(BlockPos pos, ResourceKey<Level> dim, CompoundTag tag) {
        this.pos = pos;
        this.dim = dim;
        this.tag = tag;
    }

    public <T extends BlockEntity> ClientSyncMessage(T t) {
        this.pos = t.getBlockPos();
        this.dim = Objects.requireNonNull(t.getLevel()).dimension();
        try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(t.problemPath(), LOGGER);){
            TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)t.getLevel().registryAccess());
            ((ClientSync)t).toClientTag((ValueOutput)out);
            this.tag = out.buildResult();
        }
    }

    ClientSyncMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.dim = buffer.readResourceKey(Registries.DIMENSION);
        this.tag = buffer.readNbt();
    }

    void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos).writeResourceKey(this.dim);
        buffer.writeNbt((Tag)this.tag);
    }

    @Override
    public void onReceive(Level level, Player player) {
        if (!level.dimension().equals(this.dim)) {
            return;
        }
        BlockEntity entity = level.getBlockEntity(this.pos);
        if (entity instanceof ClientSync) {
            ClientSync clientSync = (ClientSync)entity;
            try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(entity.problemPath(), LOGGER);){
                ValueInput input = TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)this.tag);
                clientSync.fromClientTag(input);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

