/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yogpc.qp.render.ColorBox;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

final class Buffer {
    private final VertexConsumer bufferBuilder;
    private final PoseStack.Pose matrix;
    private final Vector4f vector4f = new Vector4f();
    private final ColorBox colorBox;

    Buffer(VertexConsumer bufferBuilder, PoseStack.Pose matrix, ColorBox colorBox) {
        this.bufferBuilder = bufferBuilder;
        this.matrix = matrix;
        this.colorBox = colorBox;
    }

    Buffer pos(double x, double y, double z) {
        Matrix4f matrix4f = this.matrix.pose();
        this.vector4f.set((float)x, (float)y, (float)z, 1.0f);
        this.vector4f.mul((Matrix4fc)matrix4f);
        this.bufferBuilder.addVertex(this.vector4f.x(), this.vector4f.y(), this.vector4f.z());
        return this;
    }

    Buffer colored() {
        return this.color(this.colorBox);
    }

    Buffer color(int red, int green, int blue, int alpha) {
        this.bufferBuilder.setColor(red, green, blue, alpha);
        return this;
    }

    Buffer color(ColorBox colors) {
        return this.color(colors.red(), colors.green(), colors.blue(), colors.alpha());
    }

    Buffer tex(float u, float v) {
        this.bufferBuilder.setUv(u, v);
        return this;
    }

    void lightedAndEnd() {
        this.bufferBuilder.setUv1(10, 10).setUv2(240, 0).setNormal(0.0f, 1.0f, 0.0f);
    }
}

