/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RenderAdvQuarry
implements BlockEntityRenderer<AdvQuarryEntity, RenderAdvQuarryState> {
    public RenderAdvQuarry(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public RenderAdvQuarryState createRenderState() {
        return new RenderAdvQuarryState();
    }

    public void extractRenderState(AdvQuarryEntity blockEntity, RenderAdvQuarryState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.extract(blockEntity);
    }

    public void submit(RenderAdvQuarryState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("quarryplus");
        AdvQuarryEntity quarry = renderState.quarry;
        if (quarry.renderMode().equals("frame")) {
            profiler.push("adv_quarry");
            Area range = quarry.getArea();
            if (range != null) {
                profiler.push("rendering");
                double d = 0.0625;
                TextureAtlasSprite sprite = Sprites.INSTANCE.getWhite();
                ColorBox color = new ColorBox(255, 255, 0, 255);
                BlockPos pos = quarry.getBlockPos();
                LocalPlayer player = Minecraft.getInstance().player;
                double playerX = player == null ? (double)pos.getX() : player.getX();
                double playerZ = player == null ? (double)pos.getZ() : player.getZ();
                poseStack.pushPose();
                poseStack.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
                double startX = (double)range.minX() + 0.5;
                double startZ = (double)range.minZ() + 0.5;
                double endZ = (double)range.maxZ() + 0.5;
                double endX = (double)range.maxX() + 0.5;
                boolean b1 = Math.abs(playerZ - startZ) < 256.0;
                boolean b2 = Math.abs(playerZ - endZ) < 256.0;
                boolean b3 = Math.abs(playerX - startX) < 256.0;
                boolean b4 = Math.abs(playerX - endX) < 256.0;
                double xMin = Math.max(startX, playerX - 128.0);
                double xMax = Math.min(endX, playerX + 128.0);
                double zMin = Math.max(startZ, playerZ - 128.0);
                double zMax = Math.min(endZ, playerZ + 128.0);
                nodeCollector.submitCustomGeometry(poseStack, RenderType.cutout(), (pose, vertexConsumer) -> {
                    if (b1) {
                        Box.apply(xMin, range.minY(), startZ, xMax, range.minY(), startZ, xMax - xMin, 0.0625, 0.0625, false, false).render(vertexConsumer, pose, sprite, color);
                    }
                    if (b2) {
                        Box.apply(xMin, range.minY(), endZ, xMax, range.minY(), endZ, xMax - xMin, 0.0625, 0.0625, false, false).render(vertexConsumer, pose, sprite, color);
                    }
                    if (b3) {
                        Box.apply(startX, range.minY(), zMin, startX, range.minY(), zMax, 0.0625, 0.0625, zMax - zMin, false, false).render(vertexConsumer, pose, sprite, color);
                    }
                    if (b4) {
                        Box.apply(endX, range.minY(), zMin, endX, range.minY(), zMax, 0.0625, 0.0625, zMax - zMin, false, false).render(vertexConsumer, pose, sprite, color);
                    }
                });
                poseStack.popPose();
                profiler.pop();
            }
            profiler.pop();
        }
        profiler.pop();
    }

    public static class RenderAdvQuarryState
    extends BlockEntityRenderState {
        AdvQuarryEntity quarry;

        void extract(AdvQuarryEntity quarry) {
            this.quarry = quarry;
        }
    }
}

