/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machine.marker.ChunkMarkerEntity;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.RenderMarker;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RenderChunkMarker
implements BlockEntityRenderer<ChunkMarkerEntity, RenderChunkMarkerState> {
    public RenderChunkMarker(BlockEntityRendererProvider.Context context) {
    }

    public RenderChunkMarkerState createRenderState() {
        return new RenderChunkMarkerState();
    }

    public void extractRenderState(ChunkMarkerEntity blockEntity, RenderChunkMarkerState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.extract(blockEntity);
    }

    public void submit(RenderChunkMarkerState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("quarryplus");
        profiler.push("chunk_marker");
        ChunkMarkerEntity marker = renderState.marker;
        poseStack.pushPose();
        BlockPos markerPos = marker.getBlockPos();
        poseStack.translate((float)(-markerPos.getX()), (float)(-markerPos.getY()), (float)(-markerPos.getZ()));
        nodeCollector.submitCustomGeometry(poseStack, RenderType.cutout(), (pose, vertexConsumer) -> marker.getLink().ifPresent(link -> RenderMarker.renderLink(pose, vertexConsumer, link, ColorBox.redColor)));
        poseStack.popPose();
        profiler.pop();
        profiler.pop();
    }

    public static class RenderChunkMarkerState
    extends BlockEntityRenderState {
        private ChunkMarkerEntity marker;

        void extract(ChunkMarkerEntity marker) {
            this.marker = marker;
        }
    }
}

