/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yogpc.qp.machine.quarry.QuarryEntity;
import com.yogpc.qp.render.Buffer;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RenderQuarry
implements BlockEntityRenderer<QuarryEntity, RenderQuarryState> {
    private static final double d1 = 0.0625;
    private static final double d4 = 0.25;

    public RenderQuarry(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public RenderQuarryState createRenderState() {
        return new RenderQuarryState();
    }

    public void extractRenderState(QuarryEntity blockEntity, RenderQuarryState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.extract(blockEntity, partialTick);
    }

    public void submit(RenderQuarryState renderState, PoseStack matrices, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        String renderMode;
        ProfilerFiller profiler = Profiler.get();
        profiler.push("quarryplus");
        profiler.push("RenderQuarry");
        QuarryEntity quarry = renderState.quarry;
        float tickDelta = renderState.partialTick;
        matrices.pushPose();
        BlockPos pos = quarry.getBlockPos();
        matrices.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
        if (quarry.getArea() != null && (renderMode = quarry.renderMode()) != null) {
            matrices.pushPose();
            switch (renderMode) {
                case "frame": {
                    matrices.translate(0.5, 0.5, 0.5);
                    nodeCollector.submitCustomGeometry(matrices, RenderType.cutout(), (pose, vertexConsumer) -> this.renderFrame(quarry, pose, vertexConsumer));
                    break;
                }
                case "drill": {
                    matrices.translate(0.5, 1.0, 0.5);
                    nodeCollector.submitCustomGeometry(matrices, RenderType.cutout(), (pose, vertexConsumer) -> this.renderDrill(quarry, pose, tickDelta, vertexConsumer));
                }
            }
            matrices.popPose();
        }
        matrices.popPose();
        profiler.pop();
        profiler.pop();
    }

    Buffer getBuffer(VertexConsumer vertexConsumer, PoseStack.Pose matrices) {
        return new Buffer(vertexConsumer, matrices, ColorBox.white);
    }

    private void renderFrame(QuarryEntity quarry, PoseStack.Pose matrices, VertexConsumer vertexConsumer) {
        double n;
        int i;
        assert (quarry.getArea() != null);
        Buffer buffer = this.getBuffer(vertexConsumer, matrices);
        int minX = quarry.getArea().minX();
        int minY = quarry.getArea().minY();
        int minZ = quarry.getArea().minZ();
        int maxX = quarry.getArea().maxX();
        int maxY = quarry.getArea().maxY();
        int maxZ = quarry.getArea().maxZ();
        Vec3i subtract = new Vec3i(maxX - minX, maxY - minY, maxZ - minZ);
        double mXm = (double)minX - 0.0625;
        double mXP = (double)minX + 0.0625;
        double mYm = (double)minY - 0.0625;
        double mYP = (double)minY + 0.0625;
        double mZm = (double)minZ - 0.0625;
        double mZP = (double)minZ + 0.0625;
        double MXm = (double)maxX - 0.0625;
        double MXP = (double)maxX + 0.0625;
        double MYm = (double)maxY - 0.0625;
        double MYP = (double)maxY + 0.0625;
        double MZm = (double)maxZ - 0.0625;
        double MZP = (double)maxZ + 0.0625;
        TextureAtlasSprite spriteV = Sprites.INSTANCE.getFrameV();
        TextureAtlasSprite spriteH = Sprites.INSTANCE.getFrameH();
        TextureAtlasSprite boxStripe = Sprites.INSTANCE.getBoxBlueStripe();
        float V_minU = spriteV.getU0();
        float V_minV = spriteV.getV0();
        float V_maxU = spriteV.getU(0.5f);
        float V_maxV = spriteV.getV(0.5f);
        float B_minU = boxStripe.getU0();
        float B_minV = boxStripe.getV0();
        float B_maxU = boxStripe.getU1();
        float B_maxV = boxStripe.getV1();
        for (i = 0; i < subtract.getX(); ++i) {
            n = i == subtract.getX() - 1 ? 0.875 : 1.0;
            double mXi = mXP + (double)i + 0.0;
            double mXn = mXP + (double)i + n;
            RenderQuarry.tempYFrameX(minY, buffer, mXi, mXn, mZm, mZP, MZm, MZP, V_minU, V_maxU, V_minV, V_maxV);
            RenderQuarry.tempYFrameX(maxY, buffer, mXi, mXn, mZm, mZP, MZm, MZP, V_minU, V_maxU, V_minV, V_maxV);
            RenderQuarry.tempZFrameX(minZ, buffer, mXi, mXn, mYm, mYP, MYm, MYP, V_minU, V_maxU, V_minV, V_maxV);
            RenderQuarry.tempZFrameX(maxZ, buffer, mXi, mXn, mYm, mYP, MYm, MYP, V_minU, V_maxU, V_minV, V_maxV);
        }
        for (i = 0; i < subtract.getY(); ++i) {
            n = i == subtract.getY() - 1 ? 0.875 : 1.0;
            float H_minU = spriteH.getU0();
            float H_minV = spriteH.getV0();
            float H_maxU = spriteH.getU(0.5f);
            float H_maxV = spriteH.getV(0.5f);
            double y0 = mYP + (double)i + 0.0;
            double yn = mYP + (double)i + n;
            RenderQuarry.tempFrameY(buffer, y0, yn, mXm, mXP, mZm, mZP, MXm, MXP, MZm, MZP, H_minU, H_maxU, H_minV, H_maxV);
        }
        for (i = 0; i < subtract.getZ(); ++i) {
            n = i == subtract.getZ() - 1 ? 0.875 : 1.0;
            double mZi = mZP + (double)i + 0.0;
            double mZn = mZP + (double)i + n;
            RenderQuarry.tempYFrameZ(minY, buffer, mXm, mXP, mZi, mZn, MXm, MXP, V_minU, V_maxU, V_minV, V_maxV);
            RenderQuarry.tempYFrameZ(maxY, buffer, mXm, mXP, mZi, mZn, MXm, MXP, V_minU, V_maxU, V_minV, V_maxV);
            RenderQuarry.tempXFrameZ(minX, buffer, mYm, mYP, mZi, mZn, MYm, MYP, V_minU, V_maxU, V_minV, V_maxV);
            RenderQuarry.tempXFrameZ(maxX, buffer, mYm, mYP, mZi, mZn, MYm, MYP, V_minU, V_maxU, V_minV, V_maxV);
        }
        RenderQuarry.renderMiniBoxFrame(buffer, mXm, mXP, mYm, mYP, mZm, mZP, MXm, MXP, MYm, MYP, MZm, MZP, B_minU, B_maxU, B_minV, B_maxV);
    }

    private static void tempYFrameX(double y, Buffer buffer, double mXi, double mXn, double mZm, double mZP, double MZm, double MZP, float V_minU, float V_maxU, float V_minV, float V_maxV) {
        double ymd = y - 0.0625;
        double yPd = y + 0.0625;
        buffer.pos(mXi, ymd, mZm).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXn, ymd, mZm).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(mXn, ymd, mZP).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXi, ymd, mZP).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXi, ymd, MZm).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXn, ymd, MZm).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(mXn, ymd, MZP).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXi, ymd, MZP).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXi, yPd, mZm).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXi, yPd, mZP).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXn, yPd, mZP).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXn, yPd, mZm).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(mXi, yPd, MZm).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXi, yPd, MZP).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXn, yPd, MZP).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXn, yPd, MZm).colored().tex(V_maxU, V_minV).lightedAndEnd();
    }

    private static void tempZFrameX(double z, Buffer buffer, double mXi, double mXn, double mYm, double mYP, double MYm, double MYP, float V_minU, float V_maxU, float V_minV, float V_maxV) {
        double zmd = z - 0.0625;
        double zPd = z + 0.0625;
        buffer.pos(mXi, mYP, zmd).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXn, mYP, zmd).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(mXn, mYm, zmd).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXi, mYm, zmd).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXi, MYP, zmd).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXn, MYP, zmd).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(mXn, MYm, zmd).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXi, MYm, zmd).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXi, mYP, zPd).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXi, mYm, zPd).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXn, mYm, zPd).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXn, mYP, zPd).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(mXi, MYP, zPd).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXi, MYm, zPd).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXn, MYm, zPd).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXn, MYP, zPd).colored().tex(V_maxU, V_minV).lightedAndEnd();
    }

    private static void tempFrameY(Buffer buffer, double y0, double yn, double mXm, double mXP, double mZm, double mZP, double MXm, double MXP, double MZm, double MZP, float H_minU, float H_maxU, float H_minV, float H_maxV) {
        buffer.pos(mXm, y0, mZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(mXm, yn, mZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, yn, mZm).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, y0, mZm).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(MXm, y0, mZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(MXm, yn, mZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(MXP, yn, mZm).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(MXP, y0, mZm).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(mXm, y0, MZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(mXm, yn, MZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, yn, MZm).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, y0, MZm).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(MXm, y0, MZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(MXm, yn, MZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(MXP, yn, MZm).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(MXP, y0, MZm).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(mXm, y0, mZP).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(mXP, y0, mZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(mXP, yn, mZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(mXm, yn, mZP).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(MXm, y0, mZP).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(MXP, y0, mZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(MXP, yn, mZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(MXm, yn, mZP).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(mXm, y0, MZP).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(mXP, y0, MZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(mXP, yn, MZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(mXm, yn, MZP).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(MXm, y0, MZP).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(MXP, y0, MZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(MXP, yn, MZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(MXm, yn, MZP).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(mXm, y0, mZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(mXm, y0, mZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(mXm, yn, mZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(mXm, yn, mZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(MXm, y0, mZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(MXm, y0, mZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(MXm, yn, mZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(MXm, yn, mZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(mXm, y0, MZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(mXm, y0, MZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(mXm, yn, MZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(mXm, yn, MZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(MXm, y0, MZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(MXm, y0, MZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(MXm, yn, MZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(MXm, yn, MZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, y0, mZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(mXP, yn, mZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, yn, mZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, y0, mZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(MXP, y0, mZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(MXP, yn, mZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(MXP, yn, mZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(MXP, y0, mZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(mXP, y0, MZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(mXP, yn, MZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, yn, MZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(mXP, y0, MZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
        buffer.pos(MXP, y0, MZm).colored().tex(H_minU, H_minV).lightedAndEnd();
        buffer.pos(MXP, yn, MZm).colored().tex(H_minU, H_maxV).lightedAndEnd();
        buffer.pos(MXP, yn, MZP).colored().tex(H_maxU, H_maxV).lightedAndEnd();
        buffer.pos(MXP, y0, MZP).colored().tex(H_maxU, H_minV).lightedAndEnd();
    }

    private static void tempYFrameZ(double y, Buffer buffer, double mXm, double mXP, double mZi, double mZn, double MXm, double MXP, float V_minU, float V_maxU, float V_minV, float V_maxV) {
        double ymd = y - 0.0625;
        double yPd = y + 0.0625;
        buffer.pos(mXm, ymd, mZi).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXP, ymd, mZi).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(mXP, ymd, mZn).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXm, ymd, mZn).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(MXm, ymd, mZi).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(MXP, ymd, mZi).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(MXP, ymd, mZn).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(MXm, ymd, mZn).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(mXm, yPd, mZi).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(mXm, yPd, mZn).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(mXP, yPd, mZn).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(mXP, yPd, mZi).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(MXm, yPd, mZi).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(MXm, yPd, mZn).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(MXP, yPd, mZn).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(MXP, yPd, mZi).colored().tex(V_minU, V_maxV).lightedAndEnd();
    }

    private static void tempXFrameZ(double x, Buffer buffer, double mYm, double mYP, double mZi, double mZn, double MYm, double MYP, float V_minU, float V_maxU, float V_minV, float V_maxV) {
        double xmd = x - 0.0625;
        double xPd = x + 0.0625;
        buffer.pos(xmd, mYP, mZi).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(xmd, mYm, mZi).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(xmd, mYm, mZn).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(xmd, mYP, mZn).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(xmd, MYP, mZi).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(xmd, MYm, mZi).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(xmd, MYm, mZn).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(xmd, MYP, mZn).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(xPd, mYP, mZi).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(xPd, mYP, mZn).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(xPd, mYm, mZn).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(xPd, mYm, mZi).colored().tex(V_minU, V_maxV).lightedAndEnd();
        buffer.pos(xPd, MYP, mZi).colored().tex(V_minU, V_minV).lightedAndEnd();
        buffer.pos(xPd, MYP, mZn).colored().tex(V_maxU, V_minV).lightedAndEnd();
        buffer.pos(xPd, MYm, mZn).colored().tex(V_maxU, V_maxV).lightedAndEnd();
        buffer.pos(xPd, MYm, mZi).colored().tex(V_minU, V_maxV).lightedAndEnd();
    }

    private static void renderMiniBoxFrame(Buffer buffer, double mXm, double mXP, double mYm, double mYP, double mZm, double mZP, double MXm, double MXP, double MYm, double MYP, double MZm, double MZP, float B_minU, float B_maxU, float B_minV, float B_maxV) {
        buffer.pos(mXP, mYP, mZm).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXP, mYm, mZm).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, mYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYP, mZm).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXP, mYm, mZm).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXm, mYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXm, mYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, mYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYP, MZP).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, mYm, MZP).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, mYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, mYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXm, mYP, MZP).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXm, mYm, MZP).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXP, MYP, mZm).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXP, MYm, mZm).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXm, MYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, MYP, mZm).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYm, mZm).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXm, MYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXm, MYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, MYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXm, MYP, MZP).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYm, MZP).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, MYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXm, MYP, MZP).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXm, MYm, MZP).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, MYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYP, mZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, mYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, mYm, mZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYP, MZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, mYm, MZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, mYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXm, MYP, mZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXm, MYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYm, mZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXm, MYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXm, MYP, MZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYm, MZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, mYP, mZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXP, mYm, mZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, mYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXP, mYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, mYm, MZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYP, MZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, MYP, mZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYm, mZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, MYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, MYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYm, MZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, MYP, MZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, mYm, mZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYm, mZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, mYm, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYm, mZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXm, mYm, mZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXm, mYm, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYm, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, mYm, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXm, mYm, MZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, mYm, MZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYm, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXm, mYm, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXm, mYm, MZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXP, mYm, MZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXP, MYP, mZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXP, MYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYP, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYP, mZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYP, mZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYP, mZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXm, MYP, mZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXm, MYP, mZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(mXP, MYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(mXP, MYP, MZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYP, MZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(mXm, MYP, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYP, MZP).colored().tex(B_minU, B_minV).lightedAndEnd();
        buffer.pos(MXP, MYP, MZm).colored().tex(B_minU, B_maxV).lightedAndEnd();
        buffer.pos(MXm, MYP, MZm).colored().tex(B_maxU, B_maxV).lightedAndEnd();
        buffer.pos(MXm, MYP, MZP).colored().tex(B_maxU, B_minV).lightedAndEnd();
    }

    private void renderDrill(QuarryEntity quarry, PoseStack.Pose matrices, float tickDelta, VertexConsumer vertexConsumer) {
        assert (quarry.getArea() != null);
        Buffer buffer = this.getBuffer(vertexConsumer, matrices);
        int minX = quarry.getArea().minX();
        int minZ = quarry.getArea().minZ();
        int maxX = quarry.getArea().maxX();
        double maxY = (double)quarry.getArea().maxY() - 0.5;
        int maxZ = quarry.getArea().maxZ();
        Vec3 head = quarry.head.lerp(quarry.targetHead, (double)tickDelta);
        double headPosX = head.x;
        double headPosY = head.y;
        double headPosZ = head.z;
        TextureAtlasSprite drillStripe = Sprites.INSTANCE.getDrillStripe();
        TextureAtlasSprite headSprite = Sprites.INSTANCE.getDrillHeadStripe();
        float D_minU = drillStripe.getU0();
        float D_minV = drillStripe.getV0();
        float D_maxU = drillStripe.getU(0.5f);
        float D_maxV = drillStripe.getV1();
        double hXmd = headPosX - 0.25;
        double hXPd = headPosX + 0.25;
        double MYmd = maxY - 0.25;
        double MYPd = maxY + 0.25;
        double hZmd = headPosZ - 0.25;
        double hZPd = headPosZ + 0.25;
        double xp_length = (double)maxX - headPosX - 0.5;
        int xp_floor = Mth.floor((double)xp_length);
        RenderQuarry.xLineDrill(buffer, true, xp_floor, xp_length, headPosX, drillStripe, MYmd, MYPd, hZmd, hZPd, D_minU, D_maxU, D_minV, D_maxV);
        double xn_length = headPosX - (double)minX - 0.5;
        int xn_floor = Mth.floor((double)xn_length);
        RenderQuarry.xLineDrill(buffer, false, xn_floor, xn_length, headPosX, drillStripe, MYmd, MYPd, hZmd, hZPd, D_minU, D_maxU, D_minV, D_maxV);
        double zp_length = (double)maxZ - headPosZ - 0.5;
        int zp_floor = Mth.floor((double)zp_length);
        RenderQuarry.zLineDrill(buffer, true, zp_floor, zp_length, headPosZ, drillStripe, hXmd, hXPd, MYmd, MYPd, D_minU, D_maxU, D_minV, D_maxV);
        double zn_length = headPosZ - (double)minZ - 0.5;
        int zn_floor = Mth.floor((double)zn_length);
        RenderQuarry.zLineDrill(buffer, false, zn_floor, zn_length, headPosZ, drillStripe, hXmd, hXPd, MYmd, MYPd, D_minU, D_maxU, D_minV, D_maxV);
        double y_length = maxY - headPosY - 0.75;
        int y_floor = Mth.floor((double)y_length);
        RenderQuarry.yLineDrill(buffer, y_floor, y_length, drillStripe, headSprite, headPosX, headPosY, headPosZ, hXmd, hXPd, MYPd, hZmd, hZPd, D_minU, D_maxU, D_minV);
    }

    private static void xLineDrill(Buffer buffer, boolean plus, int floor, double length, double headPosX, TextureAtlasSprite drillStripe, double MYmd, double MYPd, double hZmd, double hZPd, float D_minU, float D_maxU, float D_minV, float D_maxV) {
        double xL;
        for (int i1 = 0; i1 < floor; ++i1) {
            double fX2;
            int i2 = i1 + 1;
            double fX1 = plus ? headPosX + (0.25 + (double)i1) : headPosX - (0.25 + (double)i1);
            double d = fX2 = plus ? headPosX + (0.25 + (double)i2) : headPosX - (0.25 + (double)i2);
            if (plus) {
                buffer.pos(fX1, MYPd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
                buffer.pos(fX1, MYPd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
                buffer.pos(fX2, MYPd, hZPd).colored().tex(D_maxU, D_maxV).lightedAndEnd();
                buffer.pos(fX2, MYPd, hZmd).colored().tex(D_minU, D_maxV).lightedAndEnd();
                buffer.pos(fX1, MYmd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
                buffer.pos(fX2, MYmd, hZmd).colored().tex(D_minU, D_maxV).lightedAndEnd();
                buffer.pos(fX2, MYmd, hZPd).colored().tex(D_maxU, D_maxV).lightedAndEnd();
                buffer.pos(fX1, MYmd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
                buffer.pos(fX2, MYPd, hZmd).colored().tex(D_maxU, D_maxV).lightedAndEnd();
                buffer.pos(fX2, MYmd, hZmd).colored().tex(D_minU, D_maxV).lightedAndEnd();
                buffer.pos(fX1, MYmd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
                buffer.pos(fX1, MYPd, hZmd).colored().tex(D_maxU, D_minV).lightedAndEnd();
                buffer.pos(fX2, MYPd, hZPd).colored().tex(D_maxU, D_maxV).lightedAndEnd();
                buffer.pos(fX1, MYPd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
                buffer.pos(fX1, MYmd, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
                buffer.pos(fX2, MYmd, hZPd).colored().tex(D_minU, D_maxV).lightedAndEnd();
                continue;
            }
            buffer.pos(fX1, MYPd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(fX2, MYPd, hZmd).colored().tex(D_minU, D_maxV).lightedAndEnd();
            buffer.pos(fX2, MYPd, hZPd).colored().tex(D_maxU, D_maxV).lightedAndEnd();
            buffer.pos(fX1, MYPd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(fX1, MYmd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(fX1, MYmd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(fX2, MYmd, hZPd).colored().tex(D_maxU, D_maxV).lightedAndEnd();
            buffer.pos(fX2, MYmd, hZmd).colored().tex(D_minU, D_maxV).lightedAndEnd();
            buffer.pos(fX2, MYPd, hZmd).colored().tex(D_maxU, D_maxV).lightedAndEnd();
            buffer.pos(fX1, MYPd, hZmd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(fX1, MYmd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(fX2, MYmd, hZmd).colored().tex(D_minU, D_maxV).lightedAndEnd();
            buffer.pos(fX2, MYPd, hZPd).colored().tex(D_maxU, D_maxV).lightedAndEnd();
            buffer.pos(fX2, MYmd, hZPd).colored().tex(D_minU, D_maxV).lightedAndEnd();
            buffer.pos(fX1, MYmd, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(fX1, MYPd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
        }
        float fixedV = drillStripe.getV((float)(length - (double)floor));
        double xF = plus ? headPosX + (0.25 + (double)floor) : headPosX - (0.25 + (double)floor);
        double d = xL = plus ? headPosX + (0.25 + length) : headPosX - (0.25 + length);
        if (plus) {
            buffer.pos(xF, MYPd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(xF, MYPd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(xL, MYPd, hZPd).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(xL, MYPd, hZmd).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(xF, MYmd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(xL, MYmd, hZmd).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(xL, MYmd, hZPd).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(xF, MYmd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(xL, MYPd, hZmd).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(xL, MYmd, hZmd).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(xF, MYmd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(xF, MYPd, hZmd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(xL, MYPd, hZPd).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(xF, MYPd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(xF, MYmd, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(xL, MYmd, hZPd).colored().tex(D_minU, fixedV).lightedAndEnd();
        } else {
            buffer.pos(xF, MYPd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(xL, MYPd, hZmd).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(xL, MYPd, hZPd).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(xF, MYPd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(xF, MYmd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(xF, MYmd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(xL, MYmd, hZPd).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(xL, MYmd, hZmd).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(xL, MYPd, hZmd).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(xF, MYPd, hZmd).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(xF, MYmd, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(xL, MYmd, hZmd).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(xL, MYPd, hZPd).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(xL, MYmd, hZPd).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(xF, MYmd, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(xF, MYPd, hZPd).colored().tex(D_maxU, D_minV).lightedAndEnd();
        }
    }

    private static void yLineDrill(Buffer buffer, int floor, double length, TextureAtlasSprite drillStripe, TextureAtlasSprite headSprite, double headPosX, double headPosY, double headPosZ, double hXmd, double hXPd, double MYPd, double hZmd, double hZPd, float D_minU, float D_maxU, float D_minV) {
        float D_I8dV = drillStripe.getV(0.5f);
        float D_16dU = drillStripe.getU1();
        buffer.pos(hXmd, MYPd, hZmd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
        buffer.pos(hXmd, MYPd, hZPd).colored().tex(D_maxU, D_I8dV).lightedAndEnd();
        buffer.pos(hXPd, MYPd, hZPd).colored().tex(D_maxU, drillStripe.getV1()).lightedAndEnd();
        buffer.pos(hXPd, MYPd, hZmd).colored().tex(D_minU, drillStripe.getV1()).lightedAndEnd();
        for (int i1 = 0; i1 < floor; ++i1) {
            int i2 = i1 + 1;
            double MY1 = MYPd - (double)i1;
            double MY2 = MYPd - (double)i2;
            buffer.pos(hXPd, MY1, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MY2, hZmd).colored().tex(D_16dU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MY2, hZmd).colored().tex(D_16dU, D_I8dV).lightedAndEnd();
            buffer.pos(hXmd, MY1, hZmd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
            buffer.pos(hXPd, MY1, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MY1, hZPd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
            buffer.pos(hXmd, MY2, hZPd).colored().tex(D_16dU, D_I8dV).lightedAndEnd();
            buffer.pos(hXPd, MY2, hZPd).colored().tex(D_16dU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MY1, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MY2, hZPd).colored().tex(D_16dU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MY2, hZmd).colored().tex(D_16dU, D_I8dV).lightedAndEnd();
            buffer.pos(hXPd, MY1, hZmd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
            buffer.pos(hXmd, MY1, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MY1, hZmd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
            buffer.pos(hXmd, MY2, hZmd).colored().tex(D_16dU, D_I8dV).lightedAndEnd();
            buffer.pos(hXmd, MY2, hZPd).colored().tex(D_16dU, D_minV).lightedAndEnd();
        }
        float fixedU = drillStripe.getU((float)(length - (double)floor));
        double MYF = MYPd - (double)floor;
        double MYL = MYPd - length;
        buffer.pos(hXPd, MYF, hZmd).colored().tex(D_minU, D_minV).lightedAndEnd();
        buffer.pos(hXPd, MYL, hZmd).colored().tex(fixedU, D_minV).lightedAndEnd();
        buffer.pos(hXmd, MYL, hZmd).colored().tex(fixedU, D_I8dV).lightedAndEnd();
        buffer.pos(hXmd, MYF, hZmd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
        buffer.pos(hXPd, MYF, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
        buffer.pos(hXmd, MYF, hZPd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
        buffer.pos(hXmd, MYL, hZPd).colored().tex(fixedU, D_I8dV).lightedAndEnd();
        buffer.pos(hXPd, MYL, hZPd).colored().tex(fixedU, D_minV).lightedAndEnd();
        buffer.pos(hXPd, MYF, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
        buffer.pos(hXPd, MYL, hZPd).colored().tex(fixedU, D_minV).lightedAndEnd();
        buffer.pos(hXPd, MYL, hZmd).colored().tex(fixedU, D_I8dV).lightedAndEnd();
        buffer.pos(hXPd, MYF, hZmd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
        buffer.pos(hXmd, MYF, hZPd).colored().tex(D_minU, D_minV).lightedAndEnd();
        buffer.pos(hXmd, MYF, hZmd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
        buffer.pos(hXmd, MYL, hZmd).colored().tex(fixedU, D_I8dV).lightedAndEnd();
        buffer.pos(hXmd, MYL, hZPd).colored().tex(fixedU, D_minV).lightedAndEnd();
        buffer.pos(hXmd, MYL, hZmd).colored().tex(D_minU, D_I8dV).lightedAndEnd();
        buffer.pos(hXPd, MYL, hZmd).colored().tex(D_minU, drillStripe.getV1()).lightedAndEnd();
        buffer.pos(hXPd, MYL, hZPd).colored().tex(D_maxU, drillStripe.getV1()).lightedAndEnd();
        buffer.pos(hXmd, MYL, hZPd).colored().tex(D_maxU, D_I8dV).lightedAndEnd();
        double xm = headPosX - 0.125;
        double xP = headPosX + 0.125;
        double zm = headPosZ - 0.125;
        double zP = headPosZ + 0.125;
        double yT = headPosY + 1.0;
        double yB = headPosY + 0.0;
        float hmU = headSprite.getU0();
        float hMU = headSprite.getU1();
        float hmV = headSprite.getV0();
        float hMV = headSprite.getV(0.25f);
        buffer.pos(xP, yT, zm).colored().tex(hmU, hmV).lightedAndEnd();
        buffer.pos(xP, yB, zm).colored().tex(hMU, hmV).lightedAndEnd();
        buffer.pos(xm, yB, zm).colored().tex(hMU, hMV).lightedAndEnd();
        buffer.pos(xm, yT, zm).colored().tex(hmU, hMV).lightedAndEnd();
        buffer.pos(xm, yT, zP).colored().tex(hmU, hmV).lightedAndEnd();
        buffer.pos(xm, yB, zP).colored().tex(hMU, hmV).lightedAndEnd();
        buffer.pos(xP, yB, zP).colored().tex(hMU, hMV).lightedAndEnd();
        buffer.pos(xP, yT, zP).colored().tex(hmU, hMV).lightedAndEnd();
        buffer.pos(xP, yT, zP).colored().tex(hmU, hmV).lightedAndEnd();
        buffer.pos(xP, yB, zP).colored().tex(hMU, hmV).lightedAndEnd();
        buffer.pos(xP, yB, zm).colored().tex(hMU, hMV).lightedAndEnd();
        buffer.pos(xP, yT, zm).colored().tex(hmU, hMV).lightedAndEnd();
        buffer.pos(xm, yT, zm).colored().tex(hmU, hmV).lightedAndEnd();
        buffer.pos(xm, yB, zm).colored().tex(hMU, hmV).lightedAndEnd();
        buffer.pos(xm, yB, zP).colored().tex(hMU, hMV).lightedAndEnd();
        buffer.pos(xm, yT, zP).colored().tex(hmU, hMV).lightedAndEnd();
    }

    private static void zLineDrill(Buffer buffer, boolean plus, int floor, double length, double headPosZ, TextureAtlasSprite drillStripe, double hXmd, double hXPd, double MYmd, double MYPd, float D_minU, float D_maxU, float D_minV, float D_maxV) {
        double zL;
        for (int i1 = 0; i1 < floor; ++i1) {
            double fZ2;
            int i2 = i1 + 1;
            double fZ1 = plus ? headPosZ + (0.25 + (double)i1) : headPosZ - (0.25 + (double)i1);
            double d = fZ2 = plus ? headPosZ + (0.25 + (double)i2) : headPosZ - (0.25 + (double)i2);
            if (plus) {
                buffer.pos(hXmd, MYPd, fZ1).colored().tex(D_minU, D_minV).lightedAndEnd();
                buffer.pos(hXmd, MYPd, fZ2).colored().tex(D_minU, D_maxV).lightedAndEnd();
                buffer.pos(hXPd, MYPd, fZ2).colored().tex(D_maxU, D_maxV).lightedAndEnd();
                buffer.pos(hXPd, MYPd, fZ1).colored().tex(D_maxU, D_minV).lightedAndEnd();
                buffer.pos(hXmd, MYmd, fZ1).colored().tex(D_minU, D_minV).lightedAndEnd();
                buffer.pos(hXPd, MYmd, fZ1).colored().tex(D_maxU, D_minV).lightedAndEnd();
                buffer.pos(hXPd, MYmd, fZ2).colored().tex(D_maxU, D_maxV).lightedAndEnd();
                buffer.pos(hXmd, MYmd, fZ2).colored().tex(D_minU, D_maxV).lightedAndEnd();
                buffer.pos(hXmd, MYPd, fZ2).colored().tex(D_maxU, D_maxV).lightedAndEnd();
                buffer.pos(hXmd, MYPd, fZ1).colored().tex(D_maxU, D_minV).lightedAndEnd();
                buffer.pos(hXmd, MYmd, fZ1).colored().tex(D_minU, D_minV).lightedAndEnd();
                buffer.pos(hXmd, MYmd, fZ2).colored().tex(D_minU, D_maxV).lightedAndEnd();
                buffer.pos(hXPd, MYPd, fZ2).colored().tex(D_maxU, D_maxV).lightedAndEnd();
                buffer.pos(hXPd, MYmd, fZ2).colored().tex(D_minU, D_maxV).lightedAndEnd();
                buffer.pos(hXPd, MYmd, fZ1).colored().tex(D_minU, D_minV).lightedAndEnd();
                buffer.pos(hXPd, MYPd, fZ1).colored().tex(D_maxU, D_minV).lightedAndEnd();
                continue;
            }
            buffer.pos(hXmd, MYPd, fZ1).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, fZ1).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, fZ2).colored().tex(D_maxU, D_maxV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, fZ2).colored().tex(D_minU, D_maxV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, fZ1).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, fZ2).colored().tex(D_minU, D_maxV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, fZ2).colored().tex(D_maxU, D_maxV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, fZ1).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, fZ2).colored().tex(D_maxU, D_maxV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, fZ2).colored().tex(D_minU, D_maxV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, fZ1).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, fZ1).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, fZ2).colored().tex(D_maxU, D_maxV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, fZ1).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, fZ1).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, fZ2).colored().tex(D_minU, D_maxV).lightedAndEnd();
        }
        float fixedV = drillStripe.getV((float)(length - (double)floor));
        double zF = plus ? headPosZ + (0.25 + (double)floor) : headPosZ - (0.25 + (double)floor);
        double d = zL = plus ? headPosZ + (0.25 + length) : headPosZ - (0.25 + length);
        if (plus) {
            buffer.pos(hXmd, MYPd, zF).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, zL).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, zL).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, zF).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, zF).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, zF).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, zL).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, zL).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, zL).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, zF).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, zF).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, zL).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, zL).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, zL).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, zF).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, zF).colored().tex(D_maxU, D_minV).lightedAndEnd();
        } else {
            buffer.pos(hXmd, MYPd, zF).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, zF).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, zL).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, zL).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, zF).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, zL).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, zL).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, zF).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, zL).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, zL).colored().tex(D_minU, fixedV).lightedAndEnd();
            buffer.pos(hXmd, MYmd, zF).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXmd, MYPd, zF).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, zL).colored().tex(D_maxU, fixedV).lightedAndEnd();
            buffer.pos(hXPd, MYPd, zF).colored().tex(D_maxU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, zF).colored().tex(D_minU, D_minV).lightedAndEnd();
            buffer.pos(hXPd, MYmd, zL).colored().tex(D_minU, fixedV).lightedAndEnd();
        }
    }

    public static class RenderQuarryState
    extends BlockEntityRenderState {
        private QuarryEntity quarry;
        private float partialTick;

        void extract(QuarryEntity quarry, float partialTick) {
            this.quarry = quarry;
            this.partialTick = partialTick;
        }
    }
}

