/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class Sprites {
    public static final Sprites INSTANCE = new Sprites();
    private final Map<String, TextureAtlasSprite> spriteMap = new HashMap<String, TextureAtlasSprite>();

    private Sprites() {
    }

    public static ResourceLocation atlas() {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    private TextureAtlasSprite getSprite(String name) {
        return this.spriteMap.computeIfAbsent(name, s -> {
            AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(Sprites.atlas());
            if (texture instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                return atlas.getSprite(Sprites.getSpriteLocation(s));
            }
            return null;
        });
    }

    @NotNull
    private static ResourceLocation getSpriteLocation(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)("entity/" + s));
    }

    public TextureAtlasSprite getMarkerBlue() {
        return this.getSprite("laser_4");
    }

    public TextureAtlasSprite getFrameV() {
        return this.getSprite("stripes_v");
    }

    public TextureAtlasSprite getFrameH() {
        return this.getSprite("stripes_h");
    }

    public TextureAtlasSprite getBoxBlueStripe() {
        return this.getSprite("stripes_blue");
    }

    public TextureAtlasSprite getBoxRedStripe() {
        return this.getSprite("stripes_red");
    }

    public TextureAtlasSprite getDrillStripe() {
        return this.getSprite("drill");
    }

    public TextureAtlasSprite getDrillHeadStripe() {
        return this.getSprite("drill_head");
    }

    public TextureAtlasSprite getWhite() {
        return this.getSprite("white");
    }
}

