/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes;

import cloud.grabsky.bstats.Metrics;
import cloud.grabsky.recipes.command.RecipesCommand;
import cloud.grabsky.recipes.configuration.PluginConfiguration;
import cloud.grabsky.recipes.configuration.adapters.GenericEnumAdapter;
import cloud.grabsky.recipes.configuration.adapters.ItemTypeAdapter;
import cloud.grabsky.recipes.configuration.adapters.NamespacedKeyAdapter;
import cloud.grabsky.recipes.configuration.adapters.RecipeChoiceAdapter;
import cloud.grabsky.recipes.listeners.DiscoverTriggerListener;
import cloud.grabsky.recipes.listeners.ResourcesReloadedListener;
import cloud.grabsky.recipes.model.recipes.RecipeWrapper;
import cloud.grabsky.recipes.registry.CustomItemRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.MavenLibraryResolver;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.BukkitLamp;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.spec.ArrayCommentStyle;
import revxrsal.spec.CommentedConfiguration;
import revxrsal.spec.Specs;

public class Recipes
extends JavaPlugin {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ItemType.class, (Object)ItemTypeAdapter.INSTANCE).registerTypeAdapter(RecipeChoice.class, (Object)RecipeChoiceAdapter.INSTANCE).registerTypeAdapter(NamespacedKey.class, (Object)NamespacedKeyAdapter.INSTANCE).registerTypeAdapter(RecipeWrapper.Type.class, new GenericEnumAdapter<RecipeWrapper.Type>(RecipeWrapper.Type.class, false)).disableHtmlEscaping().setPrettyPrinting().create();
    private static Recipes instance;
    private File configurationFile;
    private CommentedConfiguration commentedConfiguration;
    private PluginConfiguration configuration;
    private CustomItemRegistry customItemRegistry;
    private final List<RecipeWrapper> recipes = new ArrayList<RecipeWrapper>();
    private final List<NamespacedKey> registeredRecipes = new ArrayList<NamespacedKey>();
    private Lamp<BukkitCommandActor> lamp;
    private String namespace;
    private final File recipesDir = new File(this.getDataFolder(), "recipes");
    private final Gson specGson = CommentedConfiguration.GSON.newBuilder().registerTypeAdapter(NamespacedKey.class, (Object)NamespacedKeyAdapter.INSTANCE).create();
    private static final Pattern NAMESPACE_PATTERN;
    private static final Pattern KEY_PATTERN;
    private static boolean isFolia;
    private static final ThreadLocal<Yaml> YAML;

    public void onEnable() {
        instance = this;
        if (this.getPluginMeta().getVersion().endsWith("-DEV")) {
            this.getLogger().warning("You're running a development build of Recipes. Keep in mind that it may contain bugs and compatibility issues.");
        }
        if (isFolia) {
            this.getLogger().severe("Looks like you're using Folia. Make sure to report any issues to our issue tracker on GitHub.");
        }
        this.customItemRegistry = new CustomItemRegistry(this);
        if (!this.onReload(true)) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new DiscoverTriggerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ResourcesReloadedListener(this), (Plugin)this);
        this.lamp = BukkitLamp.builder((JavaPlugin)this).dependency(Recipes.class, (Object)this).responseHandler(String.class, (value, context) -> {
            if (!value.isEmpty()) {
                ((BukkitCommandActor)context.actor()).reply((ComponentLike)MiniMessage.miniMessage().deserialize(value));
            }
        }).build();
        this.lamp.register(new Object[]{RecipesCommand.INSTANCE});
        new Metrics((Plugin)this, 27768);
    }

    public boolean onReload(boolean reloadConfig) {
        if (reloadConfig) {
            this.configurationFile = new File(this.getDataFolder(), "config.yml");
            this.commentedConfiguration = new CommentedConfiguration(this.configurationFile.toPath(), this.specGson, ArrayCommentStyle.COMMENT_FIRST_ELEMENT, YAML.get());
            this.configuration = (PluginConfiguration)Specs.fromConfig(PluginConfiguration.class, (CommentedConfiguration)this.commentedConfiguration);
            this.configuration.save();
            this.configuration.reload();
            this.namespace = this.initializeNamespace();
            this.customItemRegistry.refresh();
        }
        this.registeredRecipes.removeIf(arg_0 -> ((Server)this.getServer()).removeRecipe(arg_0));
        this.recipes.clear();
        this.loadRecipes(this.recipesDir);
        this.registerRecipes();
        this.configuration.disabledRecipes().forEach(Bukkit::removeRecipe);
        this.getLogger().info("Loaded and registered " + this.registeredRecipes.size() + " recipes.");
        return true;
    }

    private void loadRecipes(@NotNull File dir) {
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            this.getLogger().info("No recipes defined in the \"" + dir.getName() + "\" directory.");
            return;
        }
        for (File file : Stream.of(files).sorted(Comparator.naturalOrder()).toList()) {
            if (file.isDirectory()) {
                this.loadRecipes(file);
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(".json")) continue;
            try {
                RecipeWrapper recipe = (RecipeWrapper)GSON.fromJson((Reader)new FileReader(file), RecipeWrapper.class);
                if (recipe == null || !recipe.isValid()) {
                    this.getLogger().warning("Recipe \"" + file.getName() + "\" is invalid.");
                    continue;
                }
                recipe.setFallbackKey(this.getNamespacedKey(file));
                this.recipes.add(recipe);
            }
            catch (JsonParseException | IOException | IllegalArgumentException | IllegalStateException e) {
                this.getLogger().severe("Loading of recipe \"" + file.getName() + "\" failed due to following error(s):");
                if (!this.configuration.minimizeExceptionsStacktrace()) {
                    e.printStackTrace();
                    return;
                }
                this.getLogger().severe(" (1) " + e.getClass().getSimpleName() + ": " + e.getMessage());
                if (e.getCause() == null) continue;
                this.getLogger().severe(" (2) " + e.getCause().getClass().getSimpleName() + ": " + e.getCause().getMessage());
            }
        }
    }

    private void registerRecipes() {
        this.recipes.forEach(recipe -> {
            NamespacedKey key = recipe.getKey();
            if (this.configuration.disabledRecipes().contains(key)) {
                return;
            }
            if (key.getNamespace().equals("minecraft") && this.getServer().getRecipe(key) != null) {
                this.getServer().removeRecipe(key);
                this.getLogger().warning("Recipe \"" + String.valueOf(key) + "\" is now overriding vanilla recipe with the same key.");
            }
            try {
                this.getServer().addRecipe(recipe.toBukkit(), false);
                this.registeredRecipes.add(key);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        this.getServer().updateRecipes();
    }

    @NotNull
    private NamespacedKey getNamespacedKey(@NotNull File file) throws IllegalArgumentException {
        return new NamespacedKey(this.namespace, this.getKey(file));
    }

    @NotNull
    private String initializeNamespace() throws IllegalArgumentException {
        if (this.configuration.namespace() == null) {
            return this.getName().toLowerCase(Locale.ROOT);
        }
        String namespace = Recipes.ignoreNonMatchingCharacters(this.configuration.namespace(), NAMESPACE_PATTERN);
        if (namespace.isEmpty()) {
            throw new IllegalArgumentException("Namespace must contain at least one alphanumeric character.");
        }
        return namespace;
    }

    @NotNull
    private String getKey(@NotNull File file) throws IllegalArgumentException {
        String relativePath = this.recipesDir.toPath().relativize(file.toPath()).toString().toLowerCase(Locale.ROOT).replace(" ", "_").replace("\\", "/").replace(".json", "");
        String key = Recipes.ignoreNonMatchingCharacters(relativePath, KEY_PATTERN);
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Namespace must contain at least one alphanumeric character.");
        }
        return key;
    }

    @NotNull
    private static String ignoreNonMatchingCharacters(@NotNull CharSequence charSequence, @NotNull Pattern pattern) {
        Matcher matcher = pattern.matcher(charSequence);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            builder.append(matcher.group());
        }
        return builder.toString();
    }

    @Generated
    public static Recipes instance() {
        return instance;
    }

    @Generated
    public File configurationFile() {
        return this.configurationFile;
    }

    @Generated
    public CommentedConfiguration commentedConfiguration() {
        return this.commentedConfiguration;
    }

    @Generated
    public PluginConfiguration configuration() {
        return this.configuration;
    }

    @Generated
    public CustomItemRegistry customItemRegistry() {
        return this.customItemRegistry;
    }

    @Generated
    public List<RecipeWrapper> recipes() {
        return this.recipes;
    }

    @Generated
    public List<NamespacedKey> registeredRecipes() {
        return this.registeredRecipes;
    }

    @Generated
    public Lamp<BukkitCommandActor> lamp() {
        return this.lamp;
    }

    @Generated
    public String namespace() {
        return this.namespace;
    }

    @Generated
    public static boolean isFolia() {
        return isFolia;
    }

    static {
        NAMESPACE_PATTERN = Pattern.compile("[a-z0-9._-]+$");
        KEY_PATTERN = Pattern.compile("[a-z0-9/._-]+$");
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            isFolia = true;
        }
        catch (ClassNotFoundException e) {
            isFolia = false;
        }
        YAML = ThreadLocal.withInitial(() -> {
            DumperOptions options = new DumperOptions();
            options.setSplitLines(false);
            options.setProcessComments(false);
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            return new Yaml(options);
        });
    }

    public static final class PluginLoader
    implements io.papermc.paper.plugin.loader.PluginLoader {
        public void classloader(@NotNull PluginClasspathBuilder classpathBuilder) throws IllegalStateException {
            MavenLibraryResolver resolver = new MavenLibraryResolver();
            try (InputStream in = this.getClass().getResourceAsStream("/paper-libraries.json");){
                PluginLibraries libraries = (PluginLibraries)new Gson().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), PluginLibraries.class);
                libraries.asRepositories().forEach(arg_0 -> ((MavenLibraryResolver)resolver).addRepository(arg_0));
                libraries.asDependencies().forEach(arg_0 -> ((MavenLibraryResolver)resolver).addDependency(arg_0));
                classpathBuilder.addLibrary((ClassPathLibrary)resolver);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private static class PluginLibraries {
            private final Map<String, String> repositories;
            private final List<String> dependencies;

            public Stream<RemoteRepository> asRepositories() {
                return this.repositories.entrySet().stream().map(entry -> {
                    try {
                        String MAVEN_CENTRAL_DEFAULT_MIRROR = (String)MavenLibraryResolver.class.getField("MAVEN_CENTRAL_DEFAULT_MIRROR").get(null);
                        if (((String)entry.getValue()).contains("maven.org") || ((String)entry.getValue()).contains("maven.apache.org")) {
                            return new RemoteRepository.Builder((String)entry.getKey(), "default", MAVEN_CENTRAL_DEFAULT_MIRROR).build();
                        }
                        return new RemoteRepository.Builder((String)entry.getKey(), "default", (String)entry.getValue()).build();
                    }
                    catch (IllegalAccessException | NoSuchFieldError | NoSuchFieldException e) {
                        return new RemoteRepository.Builder((String)entry.getKey(), "default", "https://maven-central.storage-download.googleapis.com/maven2").build();
                    }
                });
            }

            public Stream<Dependency> asDependencies() {
                return this.dependencies.stream().map(value -> new Dependency((Artifact)new DefaultArtifact(value), null));
            }

            @Generated
            public PluginLibraries(Map<String, String> repositories, List<String> dependencies) {
                this.repositories = repositories;
                this.dependencies = dependencies;
            }
        }
    }
}

