/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.command;

import cloud.grabsky.recipes.Recipes;
import cloud.grabsky.recipes.utils.Extensions;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Dependency;
import revxrsal.commands.annotation.Optional;
import revxrsal.commands.annotation.SuggestWith;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;
import revxrsal.commands.node.ExecutionContext;

public enum RecipesCommand {
    INSTANCE;

    @Dependency
    private Recipes plugin;

    @Command(value={"recipes reload"})
    @CommandPermission(value="recipes.command.reload")
    public String onReload(@NotNull CommandSender sender) {
        this.plugin.onReload(true);
        return this.plugin.configuration().messages().commandRecipesReloadSuccess();
    }

    @Command(value={"recipes list_recipes"})
    @CommandPermission(value="recipes.command.list_recipes")
    public String onListRecipes(@NotNull CommandSender sender) {
        if (this.plugin.recipes().isEmpty()) {
            return this.plugin.configuration().messages().commandRecipesRecipesListFailureEmpty();
        }
        Extensions.sendTextMessage(sender, this.plugin.configuration().messages().commandRecipesRecipesListHeader());
        AtomicInteger number = new AtomicInteger(0);
        this.plugin.registeredRecipes().forEach(recipe -> Extensions.sendTextMessage(sender, Extensions.repl(this.plugin.configuration().messages().commandRecipesRecipesListEntry(), "{number}", number.incrementAndGet(), "{recipe}", recipe.asString())));
        return this.plugin.configuration().messages().commandRecipesRecipesListFooter();
    }

    @Command(value={"recipes list_items"})
    @CommandPermission(value="recipes.command.list_items")
    public String onListItems(@NotNull CommandSender sender) {
        if (this.plugin.recipes().isEmpty()) {
            return this.plugin.configuration().messages().commandRecipesItemsListFailureEmpty();
        }
        Extensions.sendTextMessage(sender, this.plugin.configuration().messages().commandRecipesItemsListHeader());
        AtomicInteger number = new AtomicInteger(0);
        this.plugin.customItemRegistry().all().keySet().forEach(identifier -> Extensions.sendTextMessage(sender, Extensions.repl(this.plugin.configuration().messages().commandRecipesItemsListEntry(), "{number}", number.incrementAndGet(), "{identifier}", identifier)));
        return this.plugin.configuration().messages().commandRecipesItemsListFooter();
    }

    @Command(value={"recipes register_item"})
    @CommandPermission(value="recipes.command.register_item")
    public String onRegisterItem(@NotNull Player sender, @NotNull String identifier) {
        ItemStack item = sender.getInventory().getItemInMainHand();
        if (!item.isEmpty()) {
            boolean isOverridden;
            boolean bl = isOverridden = this.plugin.customItemRegistry().get(identifier) != null;
            if (this.plugin.customItemRegistry().set(identifier, item)) {
                return isOverridden ? Extensions.repl(this.plugin.configuration().messages().commandRecipesRegisterItemSuccessOverridden(), "{identifier}", identifier) : Extensions.repl(this.plugin.configuration().messages().commandRecipesRegisterItemSuccess(), "{identifier}", identifier);
            }
            return Extensions.repl(this.plugin.configuration().messages().commandRecipesRegisterItemFailureInvalidIdentifier(), "{identifier}", identifier);
        }
        return Extensions.repl(this.plugin.configuration().messages().commandRecipesRegisterItemFailureInvalidItem(), "{identifier}", identifier);
    }

    @Command(value={"recipes unregister_item"})
    @CommandPermission(value="recipes.command.unregister_item")
    public String onUnregisterItem(@NotNull CommandSender sender, @SuggestWith(value=CustomItemSuggestions.class) @NotNull String identifier) {
        if (this.plugin.customItemRegistry().remove(identifier)) {
            return Extensions.repl(this.plugin.configuration().messages().commandRecipesUnregisterItemSuccess(), "{identifier}", identifier);
        }
        return Extensions.repl(this.plugin.configuration().messages().commandRecipesUnregisterItemFailureInvalidIdentifier(), "{identifier}", identifier);
    }

    @Command(value={"recipes give_item"})
    @CommandPermission(value="recipes.command.give_item")
    public String onGiveItem(@NotNull CommandSender sender, @NotNull Player target, @SuggestWith(value=CustomItemSuggestions.class) @NotNull String identifier, @Optional @Nullable Integer amount) {
        @Nullable ItemStack item = this.plugin.customItemRegistry().get(identifier);
        if (item != null && !item.isEmpty()) {
            HashMap remainingItems;
            if (amount != null) {
                item.setAmount(Math.min(amount, item.getMaxStackSize()));
            }
            if (!(remainingItems = target.getInventory().addItem(new ItemStack[]{item})).isEmpty()) {
                remainingItems.values().forEach(remainingItem -> target.getWorld().dropItem(target.getLocation(), remainingItem));
            }
            return Extensions.repl(this.plugin.configuration().messages().commandRecipesGiveItemSuccess(), "{target}", target.getName(), "{amount}", item.getAmount(), "{identifier}", identifier);
        }
        return Extensions.repl(this.plugin.configuration().messages().commandRecipesGiveItemFailure(), "{identifier}", identifier);
    }

    public static final class CustomItemSuggestions
    implements SuggestionProvider<BukkitCommandActor> {
        @NotNull
        public Collection<String> getSuggestions(@NotNull ExecutionContext<BukkitCommandActor> executionContext) {
            return Recipes.instance().customItemRegistry().allKeys();
        }
    }
}

