/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.configuration.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class GenericEnumAdapter<T extends Enum<T>>
implements JsonDeserializer<T> {
    private final Class<T> type;
    private final boolean isCaseSensitive;

    @NotNull
    public T deserialize(@NotNull JsonElement element, @NotNull Type classType, @NotNull JsonDeserializationContext context) throws JsonParseException {
        String value = element.getAsString();
        for (Enum en : (Enum[])this.type.getEnumConstants()) {
            if (this.isCaseSensitive && en.name().equals(value)) {
                return (T)en;
            }
            if (!en.name().equalsIgnoreCase(value)) continue;
            return (T)en;
        }
        throw new JsonParseException("Expected " + this.type.getName() + " but found: " + value);
    }

    @Generated
    public GenericEnumAdapter(Class<T> type, boolean isCaseSensitive) {
        this.type = type;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Generated
    public Class<T> type() {
        return this.type;
    }

    @Generated
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }
}

