/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.model;

import cloud.grabsky.recipes.Recipes;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public final class Item {
    @Nullable
    private final ItemType type;
    @SerializedName(value="registered_item")
    @Nullable
    private final String registeredItem;
    @Nullable
    private final Integer amount;
    @Nullable
    private final String name;
    @Nullable
    private final List<String> lore;
    @Nullable
    private final String components;

    public ItemStack toItemStack() throws IllegalArgumentException {
        if (this.registeredItem != null) {
            @Nullable ItemStack item = Recipes.instance().customItemRegistry().get(this.registeredItem);
            if (item == null) {
                throw new IllegalArgumentException("Custom item \"" + this.registeredItem + "\" does not exist.");
            }
            if (this.amount != null && this.amount > 0) {
                item.setAmount(Math.min(item.getMaxStackSize(), this.amount));
            }
            return item;
        }
        if (this.type != null) {
            ItemStack item = this.type.createItemStack();
            if (this.components != null && !this.components.trim().isEmpty()) {
                Bukkit.getUnsafe().modifyItemStack(item, this.type.key().asString() + this.components);
            }
            if (this.amount != null && this.amount > 0) {
                item.setAmount(Math.min(item.getMaxStackSize(), this.amount));
            }
            if (item.getItemMeta() != null) {
                ItemMeta meta = item.getItemMeta();
                if (this.name != null) {
                    meta.displayName(MiniMessage.miniMessage().deserialize((Object)this.name));
                }
                if (this.lore != null) {
                    meta.lore(this.lore.stream().map(line -> MiniMessage.miniMessage().deserialize(line)).toList());
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        throw new IllegalArgumentException("Impossible to parse item because neither \"registered_item\" nor \"type\" properties were specified.");
    }

    public boolean isValid() {
        return this.registeredItem != null ? Recipes.instance().customItemRegistry().get(this.registeredItem) != null : this.type != null;
    }

    @Generated
    public Item(@Nullable ItemType type, @Nullable String registeredItem, @Nullable Integer amount, @Nullable String name, @Nullable List<String> lore, @Nullable String components) {
        this.type = type;
        this.registeredItem = registeredItem;
        this.amount = amount;
        this.name = name;
        this.lore = lore;
        this.components = components;
    }

    @Nullable
    @Generated
    public ItemType getType() {
        return this.type;
    }

    @Nullable
    @Generated
    public String getRegisteredItem() {
        return this.registeredItem;
    }

    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Nullable
    @Generated
    public String getComponents() {
        return this.components;
    }
}

