/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.model.recipes;

import cloud.grabsky.recipes.configuration.adapters.RecipeWrapperAdapter;
import cloud.grabsky.recipes.model.DiscoverTrigger;
import cloud.grabsky.recipes.model.recipes.BlastingRecipeWrapper;
import cloud.grabsky.recipes.model.recipes.CampfireRecipeWrapper;
import cloud.grabsky.recipes.model.recipes.ShapedRecipeWrapper;
import cloud.grabsky.recipes.model.recipes.ShapelessRecipeWrapper;
import cloud.grabsky.recipes.model.recipes.SmeltingRecipeWrapper;
import cloud.grabsky.recipes.model.recipes.SmithingRecipeWrapper;
import cloud.grabsky.recipes.model.recipes.SmokingRecipeWrapper;
import cloud.grabsky.recipes.model.recipes.StonecuttingRecipeWrapper;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;

@JsonAdapter(value=RecipeWrapperAdapter.class)
public abstract class RecipeWrapper {
    @SerializedName(value="key")
    protected NamespacedKey key;
    @SerializedName(value="type")
    protected Type type;
    @SerializedName(value="discover")
    protected DiscoverTrigger discoverTrigger;

    public RecipeWrapper(@NotNull Type type) {
        this.type = type;
    }

    public void setFallbackKey(@NotNull NamespacedKey key) {
        if (this.key == null) {
            this.key = key;
        }
    }

    public abstract boolean isValid();

    public abstract Recipe toBukkit();

    @Generated
    public NamespacedKey getKey() {
        return this.key;
    }

    @Generated
    public DiscoverTrigger getDiscoverTrigger() {
        return this.discoverTrigger;
    }

    public static enum Type {
        CRAFTING_SHAPED(ShapedRecipeWrapper.class),
        CRAFTING_SHAPELESS(ShapelessRecipeWrapper.class),
        SMELTING(SmeltingRecipeWrapper.class),
        BLASTING(BlastingRecipeWrapper.class),
        SMOKING(SmokingRecipeWrapper.class),
        CAMPFIRE_COOKING(CampfireRecipeWrapper.class),
        SMITHING(SmithingRecipeWrapper.class),
        STONECUTTING(StonecuttingRecipeWrapper.class);

        private final Class<? extends RecipeWrapper> recipeClass;

        @Generated
        private Type(Class<? extends RecipeWrapper> recipeClass) {
            this.recipeClass = recipeClass;
        }

        @Generated
        public Class<? extends RecipeWrapper> getRecipeClass() {
            return this.recipeClass;
        }
    }
}

