/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.configuration;

import revxrsal.spec.annotation.Comment;
import revxrsal.spec.annotation.ConfigSpec;
import revxrsal.spec.annotation.Key;
import revxrsal.spec.annotation.Order;
import revxrsal.spec.annotation.Reload;
import revxrsal.spec.annotation.Reset;
import revxrsal.spec.annotation.Save;

@ConfigSpec
public interface PluginConfiguration {
    @Order(value=0)
    @Key(value="namespace")
    @Comment(value={"Namespace to be used for recipe registration. (Default: recipes)"})
    default public String namespace() {
        return "recipes";
    }

    @Order(value=1)
    @Key(value="minimize_exceptions_stacktrace")
    @Comment(value={"Whether exception stacktrace should be minimized. (Default: true)"})
    default public boolean minimizeExceptionsStacktrace() {
        return true;
    }

    @Order(value=3)
    @Key(value="messages")
    @Comment(value={"Translatable messages used across the entire plugin. MiniMessage is the only supported text format."})
    public Messages messages();

    @Reset
    public void reset();

    @Save
    public void save();

    @Reload
    public void reload();

    @ConfigSpec
    public static interface Messages {
        @Order(value=0)
        @Key(value="command.recipes.reload.success")
        @Comment(value={"Recipes > Reload"})
        default public String commandRecipesReloadSuccess() {
            return "<dark_gray>\u203a <gray>Plugin <gold>Recipes<gray> has been reloaded.";
        }

        @Order(value=1)
        @Key(value="command.recipes.recipes_list.header")
        @Comment(value={"Recipes > Recipes List"})
        default public String commandRecipesRecipesListHeader() {
            return "<dark_gray><st>---------------------</st>  <gray>Recipes  <dark_gray><st>---------------------</st><newline>";
        }

        @Order(value=2)
        @Key(value="command.recipes.recipes_list.entry")
        default public String commandRecipesRecipesListEntry() {
            return " <#848484>{number}. <#E0C865>{recipe}";
        }

        @Order(value=3)
        @Key(value="command.recipes.recipes_list.footer")
        default public String commandRecipesRecipesListFooter() {
            return "<newline><dark_gray><st>---------------------------------------------------</st>";
        }

        @Order(value=4)
        @Key(value="command.recipes.recipes_list.failure.empty")
        default public String commandRecipesRecipesListFailureEmpty() {
            return "<dark_gray>\u203a <red>No recipes were found.";
        }

        @Order(value=5)
        @Key(value="command.recipes.items_list.header")
        @Comment(value={"Recipes > Items List"})
        default public String commandRecipesItemsListHeader() {
            return "<dark_gray><st>-------------------</st>  <gray>Custom Items  <dark_gray><st>-------------------</st><newline>";
        }

        @Order(value=6)
        @Key(value="command.recipes.items_list.entry")
        default public String commandRecipesItemsListEntry() {
            return " <#848484>{number}. <#E0C865>{identifier}";
        }

        @Order(value=7)
        @Key(value="command.recipes.items_list.footer")
        default public String commandRecipesItemsListFooter() {
            return "<newline><dark_gray><st>---------------------------------------------------</st>";
        }

        @Order(value=8)
        @Key(value="command.recipes.items_list.failure.empty")
        default public String commandRecipesItemsListFailureEmpty() {
            return "<dark_gray>\u203a <red>No items were found.";
        }

        @Order(value=9)
        @Key(value="command.recipes.register_item.success")
        @Comment(value={"Message shown when an item is successfully registered"})
        default public String commandRecipesRegisterItemSuccess() {
            return "<dark_gray>\u203a <gray>Item <gold>{identifier}<gray> has been registered.";
        }

        @Order(value=10)
        @Key(value="command.recipes.register_item.success.overridden")
        default public String commandRecipesRegisterItemSuccessOverridden() {
            return "<dark_gray>\u203a <gray>Item <gold>{identifier}<gray> has been overridden.";
        }

        @Order(value=11)
        @Key(value="command.recipes.register_item.failure.invalid_item")
        default public String commandRecipesRegisterItemFailureInvalidItem() {
            return "<dark_gray>\u203a <red>Currently held item cannot be registered.";
        }

        @Order(value=12)
        @Key(value="command.recipes.register_item.failure.invalid_identifier")
        default public String commandRecipesRegisterItemFailureInvalidIdentifier() {
            return "<dark_gray>\u203a <red>Identifier <gold>{identifier}<red> contains invalid characters.";
        }

        @Order(value=13)
        @Key(value="command.recipes.unregister_item.success")
        @Comment(value={"Recipes > Unregister Item"})
        default public String commandRecipesUnregisterItemSuccess() {
            return "<dark_gray>\u203a <gray>Item <gold>{identifier}<gray> has been unregistered.";
        }

        @Order(value=14)
        @Key(value="command.recipes.unregister_item.failure.invalid_identifier")
        default public String commandRecipesUnregisterItemFailureInvalidIdentifier() {
            return "<dark_gray>\u203a <red>Item <gold>{identifier}<red> does not exist.";
        }

        @Order(value=15)
        @Key(value="command.recipes.give_item.success")
        @Comment(value={"Recipes > Give Item"})
        default public String commandRecipesGiveItemSuccess() {
            return "<dark_gray>\u203a <gray>Player <gold>{target}<gray> was given <gold>{amount}x {identifier}<gray>.";
        }

        @Order(value=16)
        @Key(value="command.recipes.give_item.failure")
        default public String commandRecipesGiveItemFailure() {
            return "<dark_gray>\u203a <red>Item <gold>{identifier}<red> does not exist.";
        }
    }
}

