/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.configuration.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum NamespacedKeyAdapter implements JsonDeserializer<NamespacedKey>
{
    INSTANCE;


    @NotNull
    public NamespacedKey deserialize(@NotNull JsonElement element, @NotNull Type classType, @NotNull JsonDeserializationContext context) throws JsonParseException {
        if (!element.isJsonPrimitive()) {
            throw new JsonParseException("Expected " + JsonPrimitive.class.getName() + " but found: " + element.getClass().getName());
        }
        String value = element.getAsString();
        @Nullable NamespacedKey key = NamespacedKey.fromString((String)value);
        if (key == null) {
            throw new JsonParseException("Key \"" + value + "\" is not a valid resource location / namespaced key.");
        }
        return key;
    }
}

