/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.configuration.adapters;

import cloud.grabsky.recipes.model.Item;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.NotNull;

public enum RecipeChoiceAdapter implements JsonDeserializer<RecipeChoice>
{
    INSTANCE;


    public RecipeChoice deserialize(@NotNull JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            if (json.getAsJsonObject().get("type") != null || json.getAsJsonObject().get("registered_item") != null) {
                Item item = (Item)context.deserialize(json, Item.class);
                if (!item.isValid()) {
                    throw new JsonParseException("Required property \"type\" does not exist.");
                }
                if (!RecipeChoiceAdapter.isNotAir(item)) {
                    return RecipeChoice.empty();
                }
                try {
                    return item.getComponents() == null && !item.toItemStack().hasItemMeta() ? new RecipeChoice.MaterialChoice(item.toItemStack().getType()) : new RecipeChoice.ExactChoice(item.toItemStack());
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException("An error occurred while trying to convert to ItemStack.", (Throwable)e);
                }
            }
            if (json.getAsJsonObject().get("tag") != null) {
                String key = json.getAsJsonObject().get("tag").getAsString();
                if (key.charAt(0) == '#') {
                    key = key.substring(1);
                }
                if (NamespacedKey.fromString((String)key) == null) {
                    throw new JsonParseException("Required property \"tag\" does not represent a valid namespaced key.");
                }
                Tag tag = Bukkit.getTag((String)"items", (NamespacedKey)NamespacedKey.fromString((String)key), Material.class);
                if (tag == null) {
                    throw new JsonParseException("Required property \"tag\" does not represent a valid material tag.");
                }
                return new RecipeChoice.MaterialChoice(tag);
            }
            throw new JsonParseException("Expected JsonObject with either the \"type\" or \"tag\" property, but neither was found.");
        }
        if (json.isJsonArray()) {
            List items = (List)context.deserialize(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{Item.class}).getType());
            if (!items.stream().filter(RecipeChoiceAdapter::isNotAir).allMatch(Item::isValid)) {
                throw new JsonParseException("Required property \"type\" does not exist on one or more elements.");
            }
            try {
                return items.stream().filter(RecipeChoiceAdapter::isNotAir).noneMatch(it -> it.getComponents() != null || it.toItemStack().hasItemMeta()) ? new RecipeChoice.MaterialChoice(items.stream().filter(RecipeChoiceAdapter::isNotAir).map(Item::toItemStack).map(ItemStack::getType).collect(Collectors.toList())) : new RecipeChoice.ExactChoice(items.stream().filter(RecipeChoiceAdapter::isNotAir).map(Item::toItemStack).collect(Collectors.toList()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("An error occurred while trying to convert to ItemStack.", (Throwable)e);
            }
        }
        throw new JsonParseException("Expected JsonObject or JsonArray but found " + json.getClass().getSimpleName() + ".");
    }

    private static boolean isNotAir(Item item) {
        return item.getType() != ItemType.AIR;
    }
}

