/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.listeners;

import cloud.grabsky.recipes.Recipes;
import cloud.grabsky.recipes.model.recipes.RecipeWrapper;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.plugin.Plugin;

public final class DiscoverTriggerListener
implements Listener {
    private final Recipes plugin;

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            Player player = event.getPlayer();
            List<NamespacedKey> recipes = this.plugin.recipes().stream().filter(recipe -> {
                if (player.hasDiscoveredRecipe(recipe.getKey())) {
                    return false;
                }
                if (recipe.getDiscoverTrigger() == null) {
                    return true;
                }
                if (recipe.getDiscoverTrigger().getRequiredItems() != null && !recipe.getDiscoverTrigger().getRequiredItems().isEmpty()) {
                    for (ItemStack item : player.getInventory().getContents()) {
                        if (item == null || item.getType() == Material.AIR) continue;
                        for (RecipeChoice choice : recipe.getDiscoverTrigger().getRequiredItems()) {
                            if (!choice.test(item)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }).map(RecipeWrapper::getKey).toList();
            player.getScheduler().run((Plugin)this.plugin, _task -> player.discoverRecipes((Collection)recipes), null);
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack item = event.getItem().getItemStack().clone();
            Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
                List<NamespacedKey> recipes = this.plugin.recipes().stream().filter(recipe -> {
                    if (player.hasDiscoveredRecipe(recipe.getKey())) {
                        return false;
                    }
                    if (recipe.getDiscoverTrigger() == null) {
                        return true;
                    }
                    if (recipe.getDiscoverTrigger().getRequiredItems() != null && !recipe.getDiscoverTrigger().getRequiredItems().isEmpty()) {
                        for (RecipeChoice choice : recipe.getDiscoverTrigger().getRequiredItems()) {
                            if (!choice.test(item)) continue;
                            return true;
                        }
                    }
                    return false;
                }).map(RecipeWrapper::getKey).toList();
                player.getScheduler().run((Plugin)this.plugin, _task -> player.discoverRecipes((Collection)recipes), null);
            });
        }
    }

    @Generated
    public DiscoverTriggerListener(Recipes plugin) {
        this.plugin = plugin;
    }
}

