/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.model.recipes;

import cloud.grabsky.recipes.model.Item;
import cloud.grabsky.recipes.model.recipes.RecipeWrapper;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.Objects;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public final class ShapedRecipeWrapper
extends RecipeWrapper {
    @SerializedName(value="pattern")
    private String[] pattern;
    @SerializedName(value="pattern_key")
    private Map<Character, RecipeChoice> patternKey;
    @SerializedName(value="result")
    private Item result;

    public ShapedRecipeWrapper() {
        super(RecipeWrapper.Type.CRAFTING_SHAPELESS);
    }

    @Override
    public boolean isValid() {
        if (this.pattern == null || this.pattern.length == 0) {
            return false;
        }
        if (this.pattern.length == 3) {
            for (String s : this.pattern) {
                if (s.length() == 3) continue;
                return false;
            }
        } else if (this.pattern.length == 2) {
            for (String s : this.pattern) {
                if (s.length() == 2) continue;
                return false;
            }
        } else {
            return false;
        }
        if (this.patternKey == null || this.patternKey.isEmpty()) {
            return false;
        }
        if (this.patternKey.values().stream().anyMatch(Objects::isNull)) {
            return false;
        }
        for (String s : this.pattern) {
            for (char c : s.toCharArray()) {
                if (this.patternKey.containsKey(Character.valueOf(c)) || c == ' ') continue;
                return false;
            }
        }
        return this.result != null && this.result.isValid();
    }

    public ShapedRecipe toBukkit() {
        ShapedRecipe recipe = new ShapedRecipe(this.key, this.result.toItemStack()).shape(this.pattern);
        this.patternKey.forEach((arg_0, arg_1) -> ((ShapedRecipe)recipe).setIngredient(arg_0, arg_1));
        return recipe;
    }
}

