/*
 * Decompiled with CFR 0.152.
 */
package cloud.grabsky.recipes.registry;

import cloud.grabsky.recipes.Recipes;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CustomItemRegistry {
    private final Recipes plugin;
    private final Map<String, String> internalMap = new HashMap<String, String>();
    private final transient Map<String, ItemStack> registry = new HashMap<String, ItemStack>();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().setLenient().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-]+");

    public void refresh() {
        File file = new File(this.plugin.getDataFolder(), "item_registry.json");
        if (!file.exists()) {
            this.plugin.saveResource("item_registry.json", false);
            return;
        }
        try {
            if (!this.internalMap.isEmpty()) {
                BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                GSON.toJson(this.internalMap, MAP_TYPE, (Appendable)writer);
                writer.close();
            }
            BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
            Map map = (Map)GSON.fromJson((Reader)reader, MAP_TYPE);
            reader.close();
            this.internalMap.clear();
            this.internalMap.putAll(map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.registry.clear();
        this.internalMap.forEach((identifier, encoded) -> {
            byte[] decoded = Base64.getDecoder().decode(encoded.getBytes(StandardCharsets.UTF_8));
            this.registry.put((String)identifier, ItemStack.deserializeBytes((byte[])decoded));
        });
    }

    @Nullable
    public ItemStack get(@NotNull String identifier) {
        return this.registry.get(identifier);
    }

    public boolean set(@NotNull String identifier, @NotNull ItemStack item) {
        if (!IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            return false;
        }
        item.setAmount(1);
        String bytes = new String(Base64.getEncoder().encode(item.serializeAsBytes()), StandardCharsets.UTF_8);
        this.internalMap.put(identifier, bytes);
        this.refresh();
        return true;
    }

    public boolean remove(@NotNull String identifier) {
        if (!this.internalMap.containsKey(identifier)) {
            return false;
        }
        this.internalMap.remove(identifier);
        this.refresh();
        return true;
    }

    @NotNull
    public @Unmodifiable Collection<String> allKeys() {
        return Collections.unmodifiableCollection(this.registry.keySet());
    }

    @NotNull
    public @Unmodifiable Map<String, ItemStack> all() {
        return ImmutableMap.copyOf(this.registry);
    }

    @Generated
    public CustomItemRegistry(Recipes plugin) {
        this.plugin = plugin;
    }
}

