/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mca;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.LongArrayTag;

public class Section {
    private CompoundTag data;
    private Map<String, List<PaletteIndex>> valueIndexedPalette = new HashMap<String, List<PaletteIndex>>();
    private ListTag<CompoundTag> palette;
    private byte[] blockLight;
    private long[] blockStates;
    private byte[] skyLight;
    int dataVersion;

    public Section(CompoundTag sectionRoot, int dataVersion) {
        this(sectionRoot, dataVersion, -1L);
    }

    public Section(CompoundTag sectionRoot, int dataVersion, long loadFlags) {
        this.data = sectionRoot;
        this.dataVersion = dataVersion;
        ListTag<?> rawPalette = sectionRoot.getListTag("Palette");
        if (rawPalette == null) {
            return;
        }
        this.palette = rawPalette.asCompoundTagList();
        for (int i = 0; i < this.palette.size(); ++i) {
            CompoundTag data = this.palette.get(i);
            this.putValueIndexedPalette(data, i);
        }
        ByteArrayTag blockLight = sectionRoot.getByteArrayTag("BlockLight");
        LongArrayTag blockStates = sectionRoot.getLongArrayTag("BlockStates");
        ByteArrayTag skyLight = sectionRoot.getByteArrayTag("SkyLight");
        if ((loadFlags & 0x800L) != 0L) {
            byte[] byArray = this.blockLight = blockLight != null ? (byte[])blockLight.getValue() : null;
        }
        if ((loadFlags & 0x1000L) != 0L) {
            long[] lArray = this.blockStates = blockStates != null ? (long[])blockStates.getValue() : null;
        }
        if ((loadFlags & 0x2000L) != 0L) {
            this.skyLight = skyLight != null ? (byte[])skyLight.getValue() : null;
        }
    }

    Section() {
    }

    void putValueIndexedPalette(CompoundTag data, int index) {
        PaletteIndex leaf = new PaletteIndex(data, index);
        String name = data.getString("Name");
        List<PaletteIndex> leaves = this.valueIndexedPalette.get(name);
        if (leaves == null) {
            leaves = new ArrayList<PaletteIndex>(1);
            leaves.add(leaf);
            this.valueIndexedPalette.put(name, leaves);
        } else {
            for (PaletteIndex pal : leaves) {
                if (!pal.data.equals(data)) continue;
                return;
            }
            leaves.add(leaf);
        }
    }

    PaletteIndex getValueIndexedPalette(CompoundTag data) {
        List<PaletteIndex> leaves = this.valueIndexedPalette.get(data.getString("Name"));
        if (leaves == null) {
            return null;
        }
        for (PaletteIndex leaf : leaves) {
            if (!leaf.data.equals(data)) continue;
            return leaf;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public CompoundTag getBlockStateAt(int blockX, int blockY, int blockZ) {
        int index = this.getBlockIndex(blockX, blockY, blockZ);
        int paletteIndex = this.getPaletteIndex(index);
        return this.palette.get(paletteIndex);
    }

    public void setBlockStateAt(int blockX, int blockY, int blockZ, CompoundTag state, boolean cleanup) {
        int paletteSizeBefore = this.palette.size();
        int paletteIndex = this.addToPalette(state);
        if (paletteSizeBefore != this.palette.size() && (paletteIndex & paletteIndex - 1) == 0) {
            this.adjustBlockStateBits(null, this.blockStates);
            cleanup = true;
        }
        this.setPaletteIndex(this.getBlockIndex(blockX, blockY, blockZ), paletteIndex, this.blockStates);
        if (cleanup) {
            this.cleanupPaletteAndBlockStates();
        }
    }

    public int getPaletteIndex(int blockStateIndex) {
        int bits = this.blockStates.length >> 6;
        if (this.dataVersion < 2527) {
            double blockStatesIndex = (double)blockStateIndex / (4096.0 / (double)this.blockStates.length);
            int longIndex = (int)blockStatesIndex;
            int startBit = (int)((blockStatesIndex - Math.floor(blockStatesIndex)) * 64.0);
            if (startBit + bits > 64) {
                long prev = Section.bitRange(this.blockStates[longIndex], startBit, 64);
                long next = Section.bitRange(this.blockStates[longIndex + 1], 0, startBit + bits - 64);
                return (int)((next << 64 - startBit) + prev);
            }
            return (int)Section.bitRange(this.blockStates[longIndex], startBit, startBit + bits);
        }
        int indicesPerLong = (int)(64.0 / (double)bits);
        int blockStatesIndex = blockStateIndex / indicesPerLong;
        int startBit = blockStateIndex % indicesPerLong * bits;
        return (int)Section.bitRange(this.blockStates[blockStatesIndex], startBit, startBit + bits);
    }

    public void setPaletteIndex(int blockIndex, int paletteIndex, long[] blockStates) {
        int bits = blockStates.length >> 6;
        if (this.dataVersion < 2527) {
            double blockStatesIndex = (double)blockIndex / (4096.0 / (double)blockStates.length);
            int longIndex = (int)blockStatesIndex;
            int startBit = (int)((blockStatesIndex - Math.floor(longIndex)) * 64.0);
            if (startBit + bits > 64) {
                blockStates[longIndex] = Section.updateBits(blockStates[longIndex], paletteIndex, startBit, 64);
                blockStates[longIndex + 1] = Section.updateBits(blockStates[longIndex + 1], paletteIndex, startBit - 64, startBit + bits - 64);
            } else {
                blockStates[longIndex] = Section.updateBits(blockStates[longIndex], paletteIndex, startBit, startBit + bits);
            }
        } else {
            int indicesPerLong = (int)(64.0 / (double)bits);
            int blockStatesIndex = blockIndex / indicesPerLong;
            int startBit = blockIndex % indicesPerLong * bits;
            blockStates[blockStatesIndex] = Section.updateBits(blockStates[blockStatesIndex], paletteIndex, startBit, startBit + bits);
        }
    }

    public ListTag<CompoundTag> getPalette() {
        return this.palette;
    }

    int addToPalette(CompoundTag data) {
        PaletteIndex index = this.getValueIndexedPalette(data);
        if (index != null) {
            return index.index;
        }
        this.palette.add(data);
        this.putValueIndexedPalette(data, this.palette.size() - 1);
        return this.palette.size() - 1;
    }

    int getBlockIndex(int blockX, int blockY, int blockZ) {
        return (blockY & 0xF) * 256 + (blockZ & 0xF) * 16 + (blockX & 0xF);
    }

    static long updateBits(long n, long m, int i, int j) {
        long mShifted = i > 0 ? (m & (1L << j - i) - 1L) << i : (m & (1L << j - i) - 1L) >>> -i;
        return n & ((j > 63 ? 0L : -1L << j) | (i < 0 ? 0L : (1L << i) - 1L)) | mShifted;
    }

    static long bitRange(long value, int from, int to) {
        int waste = 64 - to;
        return value << waste >>> waste + from;
    }

    public void cleanupPaletteAndBlockStates() {
        Map<Integer, Integer> oldToNewMapping = this.cleanupPalette();
        this.adjustBlockStateBits(oldToNewMapping, this.blockStates);
    }

    private Map<Integer, Integer> cleanupPalette() {
        HashMap<Integer, Integer> allIndices = new HashMap<Integer, Integer>();
        for (int i = 0; i < 4096; ++i) {
            int paletteIndex = this.getPaletteIndex(i);
            allIndices.put(paletteIndex, paletteIndex);
        }
        int index = 1;
        this.valueIndexedPalette = new HashMap<String, List<PaletteIndex>>(this.valueIndexedPalette.size());
        this.putValueIndexedPalette(this.palette.get(0), 0);
        for (int i = 1; i < this.palette.size(); ++i) {
            if (!allIndices.containsKey(index)) {
                this.palette.remove(i);
                --i;
            } else {
                this.putValueIndexedPalette(this.palette.get(i), i);
                allIndices.put(index, i);
            }
            ++index;
        }
        return allIndices;
    }

    void adjustBlockStateBits(Map<Integer, Integer> oldToNewMapping, long[] blockStates) {
        int i;
        long[] newBlockStates;
        int newBits = 32 - Integer.numberOfLeadingZeros(this.palette.size() - 1);
        newBits = Math.max(newBits, 4);
        if (this.dataVersion < 2527) {
            newBlockStates = newBits == blockStates.length / 64 ? blockStates : new long[newBits * 64];
        } else {
            int newLength = (int)Math.ceil(4096.0 / Math.floor(64.0 / (double)newBits));
            long[] lArray = newBlockStates = newBits == blockStates.length / 64 ? blockStates : new long[newLength];
        }
        if (oldToNewMapping != null) {
            for (i = 0; i < 4096; ++i) {
                this.setPaletteIndex(i, oldToNewMapping.get(this.getPaletteIndex(i)), newBlockStates);
            }
        } else {
            for (i = 0; i < 4096; ++i) {
                this.setPaletteIndex(i, this.getPaletteIndex(i), newBlockStates);
            }
        }
        this.blockStates = newBlockStates;
    }

    public byte[] getBlockLight() {
        return this.blockLight;
    }

    public void setBlockLight(byte[] blockLight) {
        if (blockLight != null && blockLight.length != 2048) {
            throw new IllegalArgumentException("BlockLight array must have a length of 2048");
        }
        this.blockLight = blockLight;
    }

    public long[] getBlockStates() {
        return this.blockStates;
    }

    public void setBlockStates(long[] blockStates) {
        if (blockStates == null) {
            throw new NullPointerException("BlockStates cannot be null");
        }
        if (blockStates.length % 64 != 0 || blockStates.length < 256 || blockStates.length > 4096) {
            throw new IllegalArgumentException("BlockStates must have a length > 255 and < 4097 and must be divisible by 64");
        }
        this.blockStates = blockStates;
    }

    public byte[] getSkyLight() {
        return this.skyLight;
    }

    public void setSkyLight(byte[] skyLight) {
        if (skyLight != null && skyLight.length != 2048) {
            throw new IllegalArgumentException("SkyLight array must have a length of 2048");
        }
        this.skyLight = skyLight;
    }

    public static Section newSection() {
        Section s = new Section();
        s.blockStates = new long[256];
        s.palette = new ListTag<CompoundTag>(CompoundTag.class);
        CompoundTag air = new CompoundTag();
        air.putString("Name", "minecraft:air");
        s.palette.add(air);
        s.data = new CompoundTag();
        return s;
    }

    public CompoundTag updateHandle(int y) {
        this.data.putByte("Y", (byte)y);
        if (this.palette != null) {
            this.data.put("Palette", this.palette);
        }
        if (this.blockLight != null) {
            this.data.putByteArray("BlockLight", this.blockLight);
        }
        if (this.blockStates != null) {
            this.data.putLongArray("BlockStates", this.blockStates);
        }
        if (this.skyLight != null) {
            this.data.putByteArray("SkyLight", this.skyLight);
        }
        return this.data;
    }

    private static class PaletteIndex {
        CompoundTag data;
        int index;

        PaletteIndex(CompoundTag data, int index) {
            this.data = data;
            this.index = index;
        }
    }
}

