/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.constants.Messages;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.block_history.BlockHistoryStates;
import ro.flcristian.terraformer.terraformer_properties.block_history.BrushAction;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.MaterialMode;
import ro.flcristian.terraformer.utility.MaterialObjectsParser;
import ro.flcristian.terraformer.utility.schematics.SchematicParserImpl;
import ro.flcristian.terraformer.utility.schematics.records.SchematicData;

class TerraformCommand
implements CommandExecutor {
    private final Terraformer plugin;
    Map<String, Component> commands;
    Map<Integer, Component[]> pages;

    public TerraformCommand(Terraformer plugin) {
        this.plugin = plugin;
        this.commands = new LinkedHashMap<String, Component>();
        this.commands.put("help", Component.text((String)"/terraform help ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"(page) - Show help information for terraform command", (TextColor)NamedTextColor.WHITE)));
        this.commands.put("start", Component.text((String)"/terraform start ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Start terraforming mode", (TextColor)NamedTextColor.WHITE)));
        this.commands.put("stop", Component.text((String)"/terraform stop ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Stop terraforming mode", (TextColor)NamedTextColor.WHITE)));
        this.commands.put("undo", Component.text((String)"/terraform undo ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Undo last modification", (TextColor)NamedTextColor.WHITE)));
        this.commands.put("redo", Component.text((String)"/terraform redo ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Redo last modification", (TextColor)NamedTextColor.WHITE)));
        this.commands.put("brushes", Component.text((String)"/terraform brushes ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Show all brush types", (TextColor)NamedTextColor.WHITE)));
        this.commands.put("brush", ((TextComponent)Component.text((String)"/terraform brush <brush> ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Set terraforming brush type.", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf b <brush>", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("size", ((TextComponent)Component.text((String)"/terraform size <size> ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Set terraforming brush size.", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf s <size>", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("depth", ((TextComponent)Component.text((String)"/terraform depth <depth> ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Set terraforming brush size.", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf d <depth>", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("materials", ((TextComponent)Component.text((String)"/terraform materials <materials> ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Set terraforming materials.", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf m <materials>", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("materialmode", ((TextComponent)Component.text((String)"/terraform materialmode <material mode> ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Set terraforming material mode.", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf mm <material mode>", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("materialmodes", Component.text((String)"/terraform materialmodes ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Show all material modes", (TextColor)NamedTextColor.WHITE)));
        this.commands.put("mask", ((TextComponent)Component.text((String)"/terraform mask ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Set terraforming mask blocks", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf mk <mask>", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("randomheight", ((TextComponent)Component.text((String)"/terraform randomheight ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Toggle random height for foliage brush", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf rh", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("schematic", ((TextComponent)Component.text((String)"/terraform schematic <list/load>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- List all the schematics / Load a schematic", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf schem <li/ld>", (TextColor)NamedTextColor.YELLOW)).appendNewline().append((Component)Component.text((String)"- You also need to provide the schematic name/s, ex: /tf schem ld tree,tree2", (TextColor)NamedTextColor.WHITE)));
        this.commands.put("randomrotation", ((TextComponent)Component.text((String)"/terraform randomrotation ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Toggle random rotation for schematic brush", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf rr", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("blockupdates", ((TextComponent)Component.text((String)"/terraform blockupdates ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Toggle block updates for all brushes except foliage and schematic", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf bu", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("minheight", ((TextComponent)Component.text((String)"/terraform minheight <height> ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Set minimum paint height", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf minh <height>", (TextColor)NamedTextColor.YELLOW)));
        this.commands.put("maxheight", ((TextComponent)Component.text((String)"/terraform maxheight <height> ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"- Set maximum paint height", (TextColor)NamedTextColor.WHITE))).appendNewline().append((Component)Component.text((String)"Alias: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"/tf maxh <height>", (TextColor)NamedTextColor.YELLOW)));
        this.pages = new LinkedHashMap<Integer, Component[]>();
        this.pages.put(1, new Component[]{this.commands.get("help"), this.commands.get("start"), this.commands.get("stop"), this.commands.get("undo"), this.commands.get("redo")});
        this.pages.put(2, new Component[]{this.commands.get("brushes"), this.commands.get("brush"), this.commands.get("size"), this.commands.get("depth")});
        this.pages.put(3, new Component[]{this.commands.get("materials"), this.commands.get("materialmode"), this.commands.get("materialmodes")});
        this.pages.put(4, new Component[]{this.commands.get("mask"), this.commands.get("randomheight"), this.commands.get("randomrotation")});
        this.pages.put(5, new Component[]{this.commands.get("schematic")});
        this.pages.put(6, new Component[]{this.commands.get("blockupdates"), this.commands.get("minheight")});
        this.pages.put(7, new Component[]{this.commands.get("maxheight")});
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Messages.SENDER_NOT_PLAYER);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showPluginInfo(player);
            return true;
        }
        TerraformerProperties properties = this.plugin.getTerraformer(player);
        switch (args[0].toLowerCase()) {
            case "help": {
                int page = 1;
                if (args.length > 1) {
                    try {
                        page = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                page = Math.min(page, this.pages.keySet().size());
                this.showHelpInfo(player, page);
                return true;
            }
            case "start": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties != null && properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_ALREADY_STARTED);
                    return true;
                }
                this.plugin.setTerraformer(player);
                player.sendMessage(Messages.START_TERRAFORM);
                return true;
            }
            case "stop": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                this.plugin.removeTerraformer(player);
                player.sendMessage(Messages.STOP_TERRAFORM);
                return true;
            }
            case "undo": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                BlockHistoryStates undoStates = properties.History.undo();
                if (undoStates == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.NOTHING_TO_UNDO);
                    return true;
                }
                this.plugin.undo(undoStates.states(), properties.Brush.BlockUpdates);
                player.sendMessage(Messages.UNDO_SUCCESSFUL);
                return true;
            }
            case "redo": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                BrushAction redoAction = properties.History.redo();
                if (redoAction == null) {
                    player.sendMessage(Messages.NOTHING_TO_REDO);
                    return true;
                }
                properties.applyRedo(this.plugin, player, redoAction);
                player.sendMessage(Messages.REDO_SUCCESSFUL);
                return true;
            }
            case "brush": 
            case "b": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage(Messages.USAGE_BRUSH);
                    return true;
                }
                BrushType brushType = BrushType.getBrushType(args[1]);
                if (brushType == null) {
                    player.sendMessage(Messages.INVALID_BRUSH_TYPE);
                    return true;
                }
                BrushType oldBrushType = properties.Brush.Type;
                properties.Brush.Type = brushType;
                if (oldBrushType != BrushType.FOLIAGE && brushType == BrushType.FOLIAGE) {
                    properties.Brush.setMode(MaterialMode.RANDOM);
                } else if (oldBrushType == BrushType.FOLIAGE && brushType != BrushType.FOLIAGE) {
                    properties.Brush.setMode(properties.Brush.Mode);
                }
                player.sendMessage(Messages.CHANGED_BRUSH(brushType));
                return true;
            }
            case "brushes": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                Component brushes = Component.text((String)"All brush types: ").appendNewline();
                for (BrushType brush : BrushType.values()) {
                    brushes = brushes.append((Component)Component.text((String)(brush.toString() + (brush != BrushType.values()[BrushType.values().length - 1] ? ", " : ""))));
                }
                brushes = brushes.color((TextColor)NamedTextColor.LIGHT_PURPLE);
                player.sendMessage(brushes);
                return true;
            }
            case "size": 
            case "s": {
                int size;
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage(Messages.USAGE_BRUSH_SIZE);
                    return true;
                }
                try {
                    size = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(Messages.INVALID_BRUSH_SIZE);
                    return true;
                }
                if (size < 1) {
                    player.sendMessage(Messages.INVALID_BRUSH_SIZE);
                    return true;
                }
                if (size > 9) {
                    boolean hasForceFlag;
                    boolean bl = hasForceFlag = args.length > 2 && args[2].equalsIgnoreCase("-f");
                    if (!hasForceFlag) {
                        player.sendMessage(Messages.INVALID_BRUSH_SIZE);
                        return true;
                    }
                    player.sendMessage(Messages.EXTREME_BRUSH_SIZE);
                }
                properties.Brush.BrushSize = size;
                player.sendMessage(Messages.CHANGED_BRUSH_SIZE(size));
                return true;
            }
            case "depth": 
            case "d": {
                int depth;
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage(Messages.USAGE_BRUSH_DEPTH);
                    return true;
                }
                try {
                    depth = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(Messages.INVALID_BRUSH_DEPTH);
                    return true;
                }
                if (depth < 1) {
                    player.sendMessage(Messages.INVALID_BRUSH_DEPTH);
                    return true;
                }
                if (depth > 20) {
                    boolean hasForceFlag;
                    boolean bl = hasForceFlag = args.length > 2 && args[2].equalsIgnoreCase("-f");
                    if (!hasForceFlag) {
                        player.sendMessage(Messages.INVALID_BRUSH_DEPTH);
                        return true;
                    }
                    player.sendMessage(Messages.EXTREME_BRUSH_DEPTH);
                }
                properties.Brush.BrushDepth = depth;
                player.sendMessage(Messages.CHANGED_BRUSH_DEPTH(depth));
                return true;
            }
            case "materials": 
            case "m": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    properties.Brush.setMode(properties.Brush.Mode);
                    player.sendMessage(Messages.CLEARED_MATERIALS);
                    return true;
                }
                if (args.length > 2) {
                    player.sendMessage(Messages.USAGE_MATERIALS);
                    return true;
                }
                try {
                    StringBuilder materialsString = new StringBuilder();
                    for (int i = 1; i < args.length; ++i) {
                        materialsString.append(args[i]);
                    }
                    properties.Brush.Materials = MaterialObjectsParser.parseMaterialPercentages(properties.Brush.Type, materialsString.toString(), properties.Brush.Mode);
                    player.sendMessage(Component.text((String)"Materials updated successfully!").color((TextColor)NamedTextColor.GREEN));
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage(Component.text((String)e.getMessage()).color((TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "materialmode": 
            case "mm": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage(Messages.USAGE_MATERIAL_MODE);
                    return true;
                }
                MaterialMode materialMode = MaterialMode.getMaterialMode(args[1]);
                if (materialMode == null) {
                    player.sendMessage(Messages.INVALID_MATERIAL_MODE);
                    return true;
                }
                properties.Brush.setMode(materialMode);
                player.sendMessage(Messages.CHANGED_MATERIAL_MODE(materialMode));
                return true;
            }
            case "materialmodes": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                Component modes = Component.text((String)"All brush types: ").appendNewline();
                for (MaterialMode mode : MaterialMode.values()) {
                    modes = modes.append((Component)Component.text((String)(mode.toString() + (mode != MaterialMode.values()[MaterialMode.values().length - 1] ? ", " : ""))));
                }
                modes = modes.color((TextColor)NamedTextColor.LIGHT_PURPLE);
                player.sendMessage(modes);
                return true;
            }
            case "mask": 
            case "mk": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    properties.Brush.Mask = new ArrayList<Material>();
                    player.sendMessage(Messages.CLEARED_MASK);
                    return true;
                }
                if (args.length > 2) {
                    player.sendMessage(Messages.USAGE_MASK);
                    return true;
                }
                try {
                    StringBuilder maskString = new StringBuilder();
                    for (int i = 1; i < args.length; ++i) {
                        maskString.append(args[i]);
                    }
                    properties.Brush.Mask = MaterialObjectsParser.parseMaskMaterials(maskString.toString());
                    player.sendMessage(Component.text((String)"Mask materials updated successfully!").color((TextColor)NamedTextColor.GREEN));
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage(Component.text((String)e.getMessage()).color((TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "randomheight": 
            case "rh": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                properties.Brush.RandomHeightFoliage = !properties.Brush.RandomHeightFoliage;
                player.sendMessage(Messages.CHANGED_RANDOM_HEIGHT(properties.Brush.RandomHeightFoliage));
                return true;
            }
            case "randomrotation": 
            case "rr": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                properties.Brush.RandomSchematicRotation = !properties.Brush.RandomSchematicRotation;
                player.sendMessage(Messages.CHANGED_RANDOM_ROTATION(properties.Brush.RandomSchematicRotation));
                return true;
            }
            case "schematic": 
            case "schem": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage(Messages.USAGE_SCHEMATIC);
                    return true;
                }
                switch (args[1].toLowerCase()) {
                    case "list": 
                    case "li": {
                        File schematicsFolder = new File(this.plugin.getDataFolder(), "Schematics");
                        if (!schematicsFolder.exists() || !schematicsFolder.isDirectory()) {
                            player.sendMessage(Component.text((String)"Schematics folder not found!").color((TextColor)NamedTextColor.RED));
                            return true;
                        }
                        File[] schemFiles = schematicsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".schem") || name.toLowerCase().endsWith(".schematic"));
                        if (schemFiles == null || schemFiles.length == 0) {
                            player.sendMessage(Component.text((String)"No schematics found!").color((TextColor)NamedTextColor.YELLOW));
                            return true;
                        }
                        Component message = ((TextComponent)Component.text((String)"Available schematics:").color((TextColor)NamedTextColor.GREEN)).appendNewline();
                        for (int i = 0; i < schemFiles.length; ++i) {
                            message = message.append(Component.text((String)("- " + schemFiles[i].getName())).color((TextColor)NamedTextColor.GRAY));
                            if (i == schemFiles.length - 1) continue;
                            message = message.appendNewline();
                        }
                        player.sendMessage(message);
                        return true;
                    }
                    case "load": 
                    case "ld": {
                        String[] fileNames = args[2].split(",");
                        ArrayList<File> validatedFiles = new ArrayList<File>();
                        File schematicsDir = new File(this.plugin.getDataFolder(), "Schematics");
                        for (String fileName : fileNames) {
                            File schematicFile = new File(schematicsDir, fileName = fileName.trim());
                            if (!schematicFile.exists()) {
                                schematicFile = new File(schematicsDir, fileName + ".schem");
                            }
                            if (!schematicFile.exists()) {
                                schematicFile = new File(schematicsDir, fileName + ".schematic");
                            }
                            if (!schematicFile.exists()) {
                                player.sendMessage(Component.text((String)("Schematic file not found: " + fileName)).color((TextColor)NamedTextColor.RED));
                                return true;
                            }
                            validatedFiles.add(schematicFile);
                        }
                        ArrayList<SchematicData> loadedSchematics = new ArrayList<SchematicData>();
                        try {
                            for (File file : validatedFiles) {
                                SchematicData schematicData = SchematicParserImpl.getInstance().readSchematicFile(player, file);
                                loadedSchematics.add(schematicData);
                                player.sendMessage(Component.text((String)("Loaded schematic: " + file.getName())).color((TextColor)NamedTextColor.GREEN));
                            }
                            properties.Brush.LoadedSchematicsData = loadedSchematics;
                        }
                        catch (IOException e) {
                            player.sendMessage(Component.text((String)"Error loading schematics. No changes applied.").color((TextColor)NamedTextColor.RED));
                            return true;
                        }
                        return true;
                    }
                }
                player.sendMessage(Component.text((String)"Invalid schematic command. Use 'list' or 'load'.").color((TextColor)NamedTextColor.RED));
                return true;
            }
            case "blockupdates": 
            case "bu": {
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                properties.Brush.BlockUpdates = !properties.Brush.BlockUpdates;
                player.sendMessage(Messages.CHANGED_BLOCK_UPDATES(properties.Brush.BlockUpdates));
                return true;
            }
            case "minheight": 
            case "minh": {
                int minHeight;
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage(Messages.CLEARED_MINHEIGHT);
                    return true;
                }
                try {
                    minHeight = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(Messages.INVALID_HEIGHT);
                    return true;
                }
                if (minHeight < -64 || minHeight > 320) {
                    player.sendMessage(Messages.INVALID_HEIGHT);
                    return true;
                }
                properties.Brush.PaintRange = new BrushProperties.BrushPaintRange(minHeight, properties.Brush.PaintRange.maxY());
                player.sendMessage(Component.text((String)("Minimum paint height set to " + minHeight)).color((TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "maxheight": 
            case "maxh": {
                int maxHeight;
                if (!player.hasPermission("terraformer.mode")) {
                    player.sendMessage(Messages.NO_PERMISSION);
                    return true;
                }
                if (properties == null || !properties.IsTerraformer) {
                    player.sendMessage(Messages.TERRAFORM_MODE_NECESSARY);
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage(Messages.CLEARED_MAXHEIGHT);
                    return true;
                }
                try {
                    maxHeight = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(Messages.INVALID_HEIGHT);
                    return true;
                }
                if (maxHeight < -64 || maxHeight > 320) {
                    player.sendMessage(Messages.INVALID_HEIGHT);
                    return true;
                }
                properties.Brush.PaintRange = new BrushProperties.BrushPaintRange(properties.Brush.PaintRange.minY(), maxHeight);
                player.sendMessage(Component.text((String)("Maximum paint height set to " + maxHeight)).color((TextColor)NamedTextColor.GREEN));
                return true;
            }
        }
        player.sendMessage(Messages.UNKNOWN_COMMAND);
        return true;
    }

    private void showPluginInfo(Player player) {
        BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"=-=-=-=-=-=-=-=-=-="))).appendNewline()).append(((TextComponent)Component.text((String)this.plugin.getDescription().getName()).color((TextColor)NamedTextColor.AQUA)).appendNewline().append(Component.text((String)"Version: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.plugin.getDescription().getVersion()).color((TextColor)NamedTextColor.WHITE)).appendNewline().append(Component.text((String)"Created by: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)((String)this.plugin.getDescription().getAuthors().get(0))).color((TextColor)NamedTextColor.WHITE)))).appendNewline()).append((Component)Component.text((String)"=-=-=-=-=-=-=-=-=-="))).build();
        player.sendMessage((Component)message);
    }

    private void showHelpInfo(Player player, int page) {
        Component message = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Terraformer Help").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)" - ").color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)("Page " + page + "/" + this.pages.keySet().size())).color((TextColor)NamedTextColor.GOLD))).appendNewline().append(Component.text((String)"=-=-=-=-=-=-=-=-=-=-=-=").color((TextColor)NamedTextColor.WHITE)).appendNewline();
        TextComponent content = Component.empty();
        for (Component command : this.pages.get(page)) {
            content = content.append(command).appendNewline();
        }
        message = message.append((Component)content);
        player.sendMessage(message);
    }
}

