/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.MaterialMode;

public class TerraformTabCompleter
implements TabCompleter {
    private final Terraformer plugin;

    public TerraformTabCompleter(Terraformer plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        File[] schemFiles;
        File schematicsFolder;
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("terraformer.use")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("help", "start", "stop", "undo", "redo", "brush", "brushes", "size", "depth", "materials", "materialmode", "materialmodes", "mask", "randomheight", "randomrotation", "schematic", "blockupdates", "minheight", "maxheight"));
        } else if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "brush": 
                case "b": {
                    if (!player.hasPermission("terraformer.mode")) break;
                    completions.addAll(Arrays.stream(BrushType.values()).map(type -> type.toString().toLowerCase()).toList());
                    break;
                }
                case "materialmode": 
                case "mm": {
                    if (!player.hasPermission("terraformer.mode")) break;
                    completions.addAll(Arrays.stream(MaterialMode.values()).map(mode -> mode.toString().toLowerCase()).toList());
                    break;
                }
                case "help": {
                    completions.addAll(Arrays.asList("1", "2", "3", "4"));
                    break;
                }
                case "size": 
                case "s": {
                    if (!player.hasPermission("terraformer.mode")) break;
                    completions.addAll(IntStream.rangeClosed(1, 9).mapToObj(Integer::toString).toList());
                    break;
                }
                case "depth": 
                case "d": {
                    if (!player.hasPermission("terraformer.mode")) break;
                    completions.addAll(IntStream.rangeClosed(1, 20).mapToObj(Integer::toString).toList());
                    break;
                }
                case "schematic": 
                case "schem": {
                    if (!player.hasPermission("terraformer.mode")) break;
                    completions.addAll(Arrays.asList("list", "load"));
                }
            }
        } else if (args.length == 3 && (args[0].equalsIgnoreCase("schematic") || args[0].equalsIgnoreCase("schem")) && args[1].equalsIgnoreCase("load") && (schematicsFolder = new File(this.plugin.getDataFolder(), "Schematics")).exists() && schematicsFolder.isDirectory() && (schemFiles = schematicsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".schem") || name.toLowerCase().endsWith(".schematic"))) != null) {
            String currentArg = args[2];
            String[] parts = currentArg.split(",");
            String prefix = String.join((CharSequence)",", Arrays.copyOfRange(parts, 0, parts.length - 1));
            String lastPart = parts[parts.length - 1].trim();
            List<String> matchingFiles = Arrays.stream(schemFiles).map(File::getName).map(name -> name.replaceAll("\\.(schem|schematic)$", "")).filter(name -> name.toLowerCase().startsWith(lastPart.toLowerCase())).map(match -> prefix.isEmpty() ? match : prefix + "," + match).toList();
            completions.addAll(matchingFiles);
        }
        return completions.isEmpty() ? null : completions.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).sorted().toList();
    }
}

