/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.constants;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.MaterialMode;

public final class Messages {
    public static final Component SENDER_NOT_PLAYER = Component.text((String)"This command can only be used by players!").color((TextColor)NamedTextColor.DARK_RED);
    public static final Component UNKNOWN_COMMAND = Component.text((String)"Unknown subcommand! Use /terraform help for a list of commands.").color((TextColor)NamedTextColor.RED);
    public static final Component NO_PERMISSION = Component.text((String)"You don't have permission to use this command!").color((TextColor)NamedTextColor.DARK_RED);
    public static final Component INVALID_BRUSH_TYPE = Component.text((String)"Invalid brush type.").color((TextColor)NamedTextColor.RED);
    public static final Component INVALID_BRUSH_SIZE = Component.text((String)"Invalid brush size. Size must be between 1 and 9.").color((TextColor)NamedTextColor.RED);
    public static final Component INVALID_BRUSH_DEPTH = Component.text((String)"Invalid brush depth. depth must be between 1 and 20.").color((TextColor)NamedTextColor.RED);
    public static final Component INVALID_MATERIAL_MODE = Component.text((String)"Invalid material mode.").color((TextColor)NamedTextColor.RED);
    public static final Component INVALID_HEIGHT = Component.text((String)"Height must be between -64 and 320").color((TextColor)NamedTextColor.RED);
    public static final Component NOTHING_TO_UNDO = Component.text((String)"Nothing to undo!").color((TextColor)NamedTextColor.RED);
    public static final Component NOTHING_TO_REDO = Component.text((String)"Nothing to redo!").color((TextColor)NamedTextColor.RED);
    public static final Component USAGE_MATERIALS = Component.text((String)"Usage: '/terraform materials <materials>' or '/terraform m <materials>'").color((TextColor)NamedTextColor.RED);
    public static final Component USAGE_MATERIAL_MODE = Component.text((String)"Usage: '/terraform materialmode <material mode>' or '/terraform mm <material mode>'. All material modes: Random, Layer, Gradient").color((TextColor)NamedTextColor.RED);
    public static final Component USAGE_BRUSH = Component.text((String)"Usage: '/terraform brush <brush>' or '/terraform b <brush>'").color((TextColor)NamedTextColor.RED);
    public static final Component USAGE_BRUSH_SIZE = Component.text((String)"Usage: '/terraform size <size>' or '/terraform s <size>'").color((TextColor)NamedTextColor.RED);
    public static final Component USAGE_BRUSH_DEPTH = Component.text((String)"Usage: '/terraform depth <d>' or '/terraform d <depth>'").color((TextColor)NamedTextColor.RED);
    public static final Component USAGE_MASK = Component.text((String)"Usage: '/terraform mask <mask>' or '/terraform mk <mask>'").color((TextColor)NamedTextColor.RED);
    public static final Component USAGE_SCHEMATIC = Component.text((String)"Usage: '/terraform schematic <list/load>' or '/terraform schem <li/ld>'").color((TextColor)NamedTextColor.RED);
    public static final Component TERRAFORM_MODE_NECESSARY = Component.text((String)"You must be in terraforming mode!").color((TextColor)NamedTextColor.YELLOW);
    public static final Component TERRAFORM_MODE_ALREADY_STARTED = Component.text((String)"You are already in terraforming mode!").color((TextColor)NamedTextColor.YELLOW);
    public static final Component NOT_ALL_MATERIALS_APPEAR = Component.text((String)"Warning! For the specified brush settings, not all materials will appear!").color((TextColor)NamedTextColor.YELLOW);
    public static final Component EXTREME_BRUSH_SIZE = Component.text((String)"WARNING! The specified brush size is very large, be careful how you use this, you server will crash if the size is too big!").color((TextColor)NamedTextColor.GOLD);
    public static final Component EXTREME_BRUSH_DEPTH = Component.text((String)"WARNING! The specified brush depth is very large, be careful how you use this, you server will crash if the depth is too big!").color((TextColor)NamedTextColor.GOLD);
    public static final Component START_TERRAFORM = Component.text((String)"Initiated terraforming mode!").color((TextColor)NamedTextColor.DARK_GREEN);
    public static final Component STOP_TERRAFORM = Component.text((String)"Left terraforming mode!").color((TextColor)NamedTextColor.DARK_PURPLE);
    public static final Component UNDO_SUCCESSFUL = Component.text((String)"Undone last modification!").color((TextColor)NamedTextColor.GREEN);
    public static final Component REDO_SUCCESSFUL = Component.text((String)"Redone last modification!").color((TextColor)NamedTextColor.LIGHT_PURPLE);
    public static final Component CHANGED_MATERIALS = Component.text((String)"Changed materials list");
    public static final Component APPLIED_BRUSH_HISTORY = Component.text((String)"Applied brush history");
    public static final Component APPLIED_MATERIAL_HISTORY = Component.text((String)"Applied material history");
    public static final Component CANT_APPLY_MATERIAL_HISTORY = Component.text((String)"Can't apply this material history for this brush type!");
    public static final Component CLEARED_MATERIALS = Component.text((String)"Materials reset!").color((TextColor)NamedTextColor.GREEN);
    public static final Component CLEARED_MASK = Component.text((String)"Mask materials cleared!").color((TextColor)NamedTextColor.GREEN);
    public static final Component CLEARED_MINHEIGHT = Component.text((String)"Reset brush paint minimum height!").color((TextColor)NamedTextColor.GREEN);
    public static final Component CLEARED_MAXHEIGHT = Component.text((String)"Reset brush paint maximum height!").color((TextColor)NamedTextColor.GREEN);

    private Messages() {
    }

    public static Component CHANGED_BRUSH_SIZE(int size) {
        return Component.text((String)"Changed brush size to ").append(Component.text((int)size).color((TextColor)NamedTextColor.GOLD));
    }

    public static Component CHANGED_BRUSH_DEPTH(int depth) {
        return Component.text((String)"Changed brush depth to ").append(Component.text((int)depth).color((TextColor)NamedTextColor.YELLOW));
    }

    public static Component CHANGED_BRUSH(BrushType brushType) {
        return Component.text((String)"Changed brush type to ").append(brushType.getName());
    }

    public static Component CHANGED_MATERIAL_MODE(MaterialMode mode) {
        return Component.text((String)"Changed material mode to ").append(mode.getName());
    }

    public static Component CHANGED_RANDOM_HEIGHT(boolean randomHeightFoliage) {
        return Component.text((String)"Changed random height foliage to ").append(Component.text((String)(randomHeightFoliage ? "enabled" : "disabled")).color((TextColor)(randomHeightFoliage ? NamedTextColor.GREEN : NamedTextColor.RED)));
    }

    public static Component CHANGED_RANDOM_ROTATION(boolean randomSchematicRotation) {
        return Component.text((String)"Changed random schematic rotation to ").append(Component.text((String)(randomSchematicRotation ? "enabled" : "disabled")).color((TextColor)(randomSchematicRotation ? NamedTextColor.GREEN : NamedTextColor.RED)));
    }

    public static Component CHANGED_BLOCK_UPDATES(boolean blockUpdates) {
        return Component.text((String)"Changed block updates to ").append(Component.text((String)(blockUpdates ? "enabled" : "disabled")).color((TextColor)(blockUpdates ? NamedTextColor.GREEN : NamedTextColor.RED)));
    }
}

