/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties;

import java.util.LinkedHashMap;
import java.util.Stack;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.block_history.BrushAction;
import ro.flcristian.terraformer.terraformer_properties.block_history.BrushBlockHistory;
import ro.flcristian.terraformer.terraformer_properties.material_history.MaterialHistory;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.Palette;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;

public class TerraformerProperties {
    public boolean IsTerraformer;
    public BrushProperties Brush;
    public Stack<BrushProperties> BrushHistory;
    public Stack<MaterialHistory> MaterialHistory;
    public BrushBlockHistory History;
    public Palette Palette;

    public TerraformerProperties() {
        this.IsTerraformer = true;
        this.Brush = new BrushProperties();
        this.BrushHistory = new Stack();
        this.MaterialHistory = new Stack();
        this.History = new BrushBlockHistory();
        this.Palette = new Palette();
    }

    public TerraformerProperties(boolean isTerraformer, BrushProperties brush, Stack<BrushProperties> brushHistory, Stack<MaterialHistory> materialHistory, BrushBlockHistory history, Palette palette) {
        this.IsTerraformer = isTerraformer;
        this.Brush = brush;
        this.BrushHistory = brushHistory;
        this.MaterialHistory = materialHistory;
        this.History = history;
        this.Palette = palette;
    }

    public void applyRedo(Terraformer plugin, Player player, BrushAction brushAction) {
        BrushType.applyBrush(plugin, player, brushAction.brushProperties(), brushAction.targetLocation(), true);
    }

    public void addBrushHistory(BrushProperties brushProperties) {
        int i;
        int MAX_HISTORY_SIZE = 9;
        for (i = 0; i < this.BrushHistory.size(); ++i) {
            if (!((BrushProperties)this.BrushHistory.get(i)).equals(brushProperties)) continue;
            this.BrushHistory.remove(i);
            break;
        }
        for (i = 0; i < this.MaterialHistory.size(); ++i) {
            if (!((MaterialHistory)this.MaterialHistory.get(i)).equals(new MaterialHistory(brushProperties.Materials, brushProperties.Mode))) continue;
            this.MaterialHistory.remove(i);
            break;
        }
        if (this.BrushHistory.size() >= MAX_HISTORY_SIZE) {
            this.BrushHistory.remove(0);
        }
        if (this.MaterialHistory.size() >= MAX_HISTORY_SIZE) {
            this.MaterialHistory.remove(0);
        }
        this.BrushHistory.push(brushProperties.clone());
        this.MaterialHistory.push(new MaterialHistory(brushProperties.Materials, brushProperties.Mode));
    }

    public void applyBrushHistory(BrushProperties brushProperties) {
        BrushProperties toApply = brushProperties.clone();
        this.Brush = new BrushProperties(toApply.Type, toApply.BrushSize, toApply.BrushDepth, this.Brush.Materials, this.Brush.Mode, this.Brush.Mask, this.Brush.RandomHeightFoliage, this.Brush.RandomSchematicRotation, this.Brush.LoadedSchematicsData, this.Brush.BlockUpdates, this.Brush.PaintRange);
    }

    public void applyMaterialHistory(MaterialHistory materialHistory) {
        this.Brush.Materials = new LinkedHashMap<Material, Integer>(materialHistory.Materials);
        this.Brush.Mode = materialHistory.Mode;
    }
}

