/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.block_history;

import java.util.Stack;
import ro.flcristian.terraformer.terraformer_properties.block_history.BlockHistoryStates;
import ro.flcristian.terraformer.terraformer_properties.block_history.BrushAction;

public class BrushBlockHistory {
    private static final int MAX_STACK_SIZE = 50;
    private final Stack<BlockHistoryStates> undoStack = new Stack();
    private final Stack<BrushAction> redoStack = new Stack();

    public void pushModification(BlockHistoryStates states) {
        this.undoStack.push(states);
        this.trimStackSize(this.undoStack);
        this.redoStack.clear();
    }

    public void pushRedo(BlockHistoryStates states) {
        this.undoStack.push(states);
        this.trimStackSize(this.undoStack);
    }

    public BlockHistoryStates undo() {
        if (this.undoStack.isEmpty()) {
            return null;
        }
        BlockHistoryStates historyStates = this.undoStack.pop();
        this.redoStack.push(new BrushAction(historyStates.targetLocation(), historyStates.brushProperties()));
        this.trimStackSize(this.redoStack);
        return historyStates;
    }

    public BrushAction redo() {
        return this.redoStack.isEmpty() ? null : this.redoStack.pop();
    }

    private <T> void trimStackSize(Stack<T> stack) {
        while (stack.size() > 50) {
            stack.remove(0);
        }
    }
}

