/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.MaterialMode;
import ro.flcristian.terraformer.utility.schematics.records.SchematicData;

public class BrushProperties
implements Cloneable {
    public BrushType Type;
    public int BrushSize;
    public int BrushDepth;
    public Map<Material, Integer> Materials;
    public MaterialMode Mode;
    public List<Material> Mask;
    public boolean RandomHeightFoliage;
    public boolean RandomSchematicRotation;
    public List<SchematicData> LoadedSchematicsData;
    public boolean BlockUpdates;
    public BrushPaintRange PaintRange;

    public BrushProperties() {
        this.Type = BrushType.BALL;
        this.BrushSize = 4;
        this.BrushDepth = 1;
        this.Materials = new LinkedHashMap<Material, Integer>();
        this.Materials.put(Material.STONE, 100);
        this.Mode = MaterialMode.RANDOM;
        this.Mask = new ArrayList<Material>();
        this.RandomHeightFoliage = false;
        this.RandomSchematicRotation = false;
        this.LoadedSchematicsData = new ArrayList<SchematicData>();
        this.BlockUpdates = true;
        this.PaintRange = new BrushPaintRange(-64, 320);
    }

    public BrushProperties(BrushType brushType, int brushSize, int brushDepth, Map<Material, Integer> materials, MaterialMode materialsMode, List<Material> mask, boolean randomHeightFoliage, boolean randomSchematicRotation, List<SchematicData> loadedSchematicsData, boolean blockUpdates, BrushPaintRange paintRange) {
        this.Type = brushType;
        this.BrushSize = brushSize;
        this.BrushDepth = brushDepth;
        this.Materials = new LinkedHashMap<Material, Integer>(materials);
        this.Mode = materialsMode;
        this.Mask = mask;
        this.RandomHeightFoliage = randomHeightFoliage;
        this.RandomSchematicRotation = randomSchematicRotation;
        this.LoadedSchematicsData = loadedSchematicsData;
        this.BlockUpdates = blockUpdates;
        this.PaintRange = paintRange;
    }

    public void applyBrush(Terraformer plugin, Player player, Location targetLocation) {
        BrushType.applyBrush(plugin, player, this, targetLocation, false);
    }

    public Material getMaterial(Location location, Location targetLocation) {
        return this.Mode.getMaterial(location, targetLocation, this);
    }

    public BrushProperties clone() {
        return new BrushProperties(this.Type, this.BrushSize, this.BrushDepth, new LinkedHashMap<Material, Integer>(this.Materials), this.Mode, new ArrayList<Material>(this.Mask), this.RandomHeightFoliage, this.RandomSchematicRotation, new ArrayList<SchematicData>(this.LoadedSchematicsData), this.BlockUpdates, this.PaintRange.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BrushProperties)) {
            return false;
        }
        BrushProperties other = (BrushProperties)obj;
        return this.Type == other.Type && this.BrushSize == other.BrushSize && this.BrushDepth == other.BrushDepth;
    }

    public void setMode(MaterialMode mode) {
        this.Mode = mode;
        this.Materials = new LinkedHashMap<Material, Integer>();
        switch (this.Mode) {
            case RANDOM: {
                if (this.Type == BrushType.FOLIAGE) {
                    this.Materials.put(Material.SHORT_GRASS, 50);
                    break;
                }
                this.Materials.put(Material.STONE, 100);
                break;
            }
            case LAYER: {
                this.Materials.put(Material.STONE, 100);
                break;
            }
            case GRADIENT: {
                this.Materials.put(Material.WHITE_CONCRETE, 0);
                this.Materials.put(Material.BLACK_CONCRETE, 100);
            }
        }
    }

    public record BrushPaintRange(int minY, int maxY) implements Cloneable
    {
        public BrushPaintRange clone() {
            return new BrushPaintRange(this.minY, this.maxY);
        }

        public boolean contains(Location location) {
            int y = location.getBlockY();
            return y >= this.minY && y <= this.maxY;
        }
    }
}

