/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.brushes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.block_history.BlockHistoryStates;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.Brush;

public class BrushErode
extends Brush {
    public static boolean brush(Terraformer plugin, Player player, BrushProperties brushProperties, Location targetLocation, boolean isRedo) {
        Stack<BlockState> states = new Stack<BlockState>();
        HashMap<Location, BlockData> erodedBlocks = new HashMap<Location, BlockData>();
        int brushSize = brushProperties.BrushSize;
        for (int x = -brushSize; x <= brushSize; ++x) {
            for (int y = -brushSize; y <= brushSize; ++y) {
                for (int z = -brushSize; z <= brushSize; ++z) {
                    Location location = targetLocation.clone().add((double)x, (double)y, (double)z);
                    if (!(location.distance(targetLocation) <= (double)brushSize)) continue;
                    states.push(location.getBlock().getState());
                }
            }
        }
        BlockHistoryStates historyStates = new BlockHistoryStates(states, targetLocation, brushProperties.clone());
        TerraformerProperties terraformerProperties = plugin.getTerraformer(player);
        if (terraformerProperties == null) {
            throw new IllegalArgumentException("Player is not in terraformer mode");
        }
        if (!isRedo) {
            terraformerProperties.History.pushModification(historyStates);
        } else {
            terraformerProperties.History.pushRedo(historyStates);
        }
        for (BlockState blockState : states) {
            Location loc = blockState.getLocation();
            boolean isCurrentSolid = blockState.getBlock().isSolid();
            ArrayList<Block> neighbors = new ArrayList<Block>();
            int solidCount = 0;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dz == 0) continue;
                    Location neighborLoc = loc.clone().add((double)dx, 0.0, (double)dz);
                    Block neighborBlock = neighborLoc.getBlock();
                    neighbors.add(neighborBlock);
                    if (!neighborBlock.getType().isSolid()) continue;
                    ++solidCount;
                }
            }
            double solidPercentage = (double)solidCount / (double)neighbors.size();
            if (!isCurrentSolid && solidPercentage > 0.75) {
                List<BlockData> solidNeighbors = neighbors.stream().filter(b -> b.getType().isSolid()).map(Block::getBlockData).collect(Collectors.toList());
                BlockData mostCommon = BrushErode.findMostCommonBlock(solidNeighbors);
                if (mostCommon == null) continue;
                erodedBlocks.put(loc, mostCommon);
                continue;
            }
            if (!isCurrentSolid || !(solidPercentage <= 0.68)) continue;
            erodedBlocks.put(loc, Material.AIR.createBlockData());
        }
        for (Map.Entry entry : erodedBlocks.entrySet()) {
            ((Location)entry.getKey()).getBlock().setBlockData((BlockData)entry.getValue(), brushProperties.BlockUpdates);
        }
        return true;
    }
}

