/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.brushes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.block_history.BlockHistoryStates;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.Brush;

public class BrushExtrude
extends Brush {
    public static boolean brush(Terraformer plugin, Player player, BrushProperties brushProperties, Location targetLocation, boolean isRedo) {
        Stack<BlockState> states = new Stack<BlockState>();
        HashMap<Location, BlockData> extrudeedBlocks = new HashMap<Location, BlockData>();
        int brushSize = brushProperties.BrushSize;
        for (int x = -brushSize; x <= brushSize; ++x) {
            for (int y = -brushSize; y <= brushSize; ++y) {
                for (int z = -brushSize; z <= brushSize; ++z) {
                    Location location = targetLocation.clone().add((double)x, (double)y, (double)z);
                    if (!(location.distance(targetLocation) <= (double)brushSize)) continue;
                    states.push(location.getBlock().getState());
                }
            }
        }
        BlockHistoryStates historyStates = new BlockHistoryStates(states, targetLocation, brushProperties.clone());
        TerraformerProperties terraformerProperties = plugin.getTerraformer(player);
        if (terraformerProperties == null) {
            throw new IllegalArgumentException("Player is not in terraformer mode");
        }
        if (!isRedo) {
            terraformerProperties.History.pushModification(historyStates);
        } else {
            terraformerProperties.History.pushRedo(historyStates);
        }
        for (BlockState blockState : states) {
            BlockData extrudeed;
            Location loc = blockState.getLocation();
            ArrayList<BlockData> neighbors = new ArrayList<BlockData>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    Location neighborLoc;
                    Block neighborBlock;
                    if (dx == 0 && dz == 0 || !(neighborBlock = (neighborLoc = loc.clone().add((double)dx, 0.0, (double)dz)).getBlock()).getType().isSolid()) continue;
                    neighbors.add(neighborBlock.getBlockData());
                }
            }
            if (!BrushExtrude.shouldExtrude(blockState.getBlockData(), neighbors) || (extrudeed = BrushExtrude.findMostCommonBlock(neighbors)) == null) continue;
            extrudeedBlocks.put(loc, extrudeed);
        }
        for (Map.Entry entry : extrudeedBlocks.entrySet()) {
            ((Location)entry.getKey()).getBlock().setBlockData((BlockData)entry.getValue(), brushProperties.BlockUpdates);
        }
        return true;
    }

    private static boolean shouldExtrude(BlockData current, List<BlockData> neighbors) {
        if (neighbors.size() == 0) {
            return false;
        }
        int differentNeighbors = 0;
        for (BlockData neighbor : neighbors) {
            if (neighbor.getMaterial().equals((Object)current.getMaterial())) continue;
            ++differentNeighbors;
        }
        return (double)differentNeighbors > (double)neighbors.size() * 0.5;
    }
}

