/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.brushes;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.block_history.BlockHistoryStates;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.Brush;

public class BrushFoliage
extends Brush {
    public static boolean brush(Terraformer plugin, Player player, BrushProperties brushProperties, Location targetLocation, boolean isRedo) {
        Block block;
        Stack<BlockState> states = new Stack<BlockState>();
        int brushSize = brushProperties.BrushSize;
        HashMap<CallSite, Location> surfaceLocationMap = new HashMap<CallSite, Location>();
        for (int x = -brushSize; x <= brushSize; ++x) {
            for (int z = -brushSize; z <= brushSize; ++z) {
                Location checkLoc;
                int y;
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)brushSize)) continue;
                Location surfaceLocation = targetLocation.clone().add((double)x, 0.0, (double)z);
                boolean bl = false;
                for (int searchDepth = 0; searchDepth <= brushSize; ++searchDepth) {
                    Location checkLoc2 = surfaceLocation.clone().add(0.0, (double)(-searchDepth), 0.0);
                    Material currentBlock = checkLoc2.getBlock().getType();
                    Material blockAbove = checkLoc2.clone().add(0.0, 1.0, 0.0).getBlock().getType();
                    if (!currentBlock.isSolid() || blockAbove.isSolid()) continue;
                    surfaceLocation = checkLoc2;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                int availableAirBlocks = 0;
                for (y = 1; y <= brushProperties.BrushDepth && !(checkLoc = surfaceLocation.clone().add(0.0, (double)y, 0.0)).getBlock().getType().isSolid(); ++y) {
                    ++availableAirBlocks;
                }
                for (y = 1; y <= availableAirBlocks; ++y) {
                    Location foliageLocation = surfaceLocation.clone().add(0.0, (double)y, 0.0);
                    block = foliageLocation.getBlock();
                    states.push(block.getState());
                }
                surfaceLocationMap.put((CallSite)((Object)(surfaceLocation.getBlockX() + "," + surfaceLocation.getBlockZ())), surfaceLocation);
            }
        }
        BlockHistoryStates historyStates = new BlockHistoryStates(states, targetLocation, brushProperties.clone());
        TerraformerProperties terraformerProperties = plugin.getTerraformer(player);
        if (terraformerProperties == null) {
            throw new IllegalArgumentException("Player is not in terraformer mode");
        }
        if (!isRedo) {
            terraformerProperties.History.pushModification(historyStates);
        } else {
            terraformerProperties.History.pushRedo(historyStates);
        }
        LinkedHashMap<Material, Integer> oldMaterials = new LinkedHashMap<Material, Integer>(brushProperties.Materials);
        int totalPercentage = 0;
        for (Material material : brushProperties.Materials.keySet()) {
            totalPercentage += brushProperties.Materials.get(material).intValue();
        }
        brushProperties.Materials.put(Material.AIR, 100 - totalPercentage);
        for (Map.Entry entry : surfaceLocationMap.entrySet()) {
            Location surfaceLocation = (Location)entry.getValue();
            if (!brushProperties.Mask.isEmpty() && !brushProperties.Mask.contains(surfaceLocation.getBlock().getType())) continue;
            Location location = surfaceLocation.clone().add(0.0, 1.0, 0.0);
            Material material = brushProperties.getMaterial(location, location);
            if (material == Material.SUGAR_CANE || material == Material.BAMBOO || material == Material.CACTUS || material == Material.AIR) {
                block = location.getBlock();
                block.setType(material, false);
                location = location.clone().add(0.0, 1.0, 0.0);
                for (int y = 2; y <= brushProperties.BrushDepth && (location.getBlock().getType() == Material.AIR || material == Material.AIR && location.getBlock().getType() != Material.AIR && !location.getBlock().getType().isSolid()); ++y) {
                    block = location.getBlock();
                    block.setType(material, false);
                    location = location.clone().add(0.0, 1.0, 0.0);
                }
                continue;
            }
            if (BrushFoliage.isTallMaterial(material) && brushProperties.BrushDepth > 1) {
                block = location.getBlock();
                block.setType(material, false);
                Bisected data = (Bisected)block.getBlockData();
                data.setHalf(Bisected.Half.BOTTOM);
                block.setBlockData((BlockData)data, false);
                if ((location = location.clone().add(0.0, 1.0, 0.0)).getBlock().getType() != Material.AIR) continue;
                block = location.getBlock();
                block.setType(material, false);
                data = (Bisected)block.getBlockData();
                data.setHalf(Bisected.Half.TOP);
                block.setBlockData((BlockData)data, false);
                continue;
            }
            block = location.getBlock();
            block.setType(material, false);
            if (!brushProperties.RandomHeightFoliage || !BrushFoliage.isTallMaterial(material)) continue;
            Random random = new Random();
            boolean height = random.nextBoolean();
            Bisected data = (Bisected)block.getBlockData();
            data.setHalf(height ? Bisected.Half.BOTTOM : Bisected.Half.TOP);
            block.setBlockData((BlockData)data, false);
        }
        brushProperties.Materials = oldMaterials;
        return true;
    }

    private static boolean isTallMaterial(Material material) {
        return switch (material) {
            case Material.TALL_GRASS, Material.LARGE_FERN, Material.TALL_SEAGRASS, Material.SUNFLOWER, Material.LILAC, Material.ROSE_BUSH, Material.PEONY, Material.PITCHER_PLANT -> true;
            default -> false;
        };
    }
}

