/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.brushes;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Stack;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.block_history.BlockHistoryStates;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.Brush;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;

public class BrushPaint
extends Brush {
    public static boolean brush(Terraformer plugin, Player player, BrushProperties brushProperties, Location targetLocation, boolean isRedo) {
        if (BrushPaint.checkMaterialPercentages(brushProperties, player)) {
            return false;
        }
        Stack<BlockState> states = new Stack<BlockState>();
        int brushSize = brushProperties.BrushSize;
        int brushDepth = brushProperties.BrushDepth;
        HashMap<CallSite, Location> surfaceLocationMap = new HashMap<CallSite, Location>();
        for (int x = -brushSize; x <= brushSize; ++x) {
            block7: for (int z = -brushSize; z <= brushSize; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)brushSize)) continue;
                switch (brushProperties.Type) {
                    case PAINT_TOP: {
                        for (int y = 0; y < brushDepth; ++y) {
                            Location loc = targetLocation.clone().add((double)x, (double)(-y), (double)z);
                            Block block = loc.getBlock();
                            if (!block.getType().isSolid()) continue;
                            states.push(block.getState());
                        }
                        continue block7;
                    }
                    case PAINT_SURFACE: {
                        Block block;
                        Location loc;
                        int y;
                        Location surfaceLocation = targetLocation.clone().add((double)x, 0.0, (double)z);
                        boolean foundSurface = false;
                        for (int searchDepth = 0; searchDepth <= brushSize; ++searchDepth) {
                            Location checkLoc = surfaceLocation.clone().add(0.0, (double)(-searchDepth), 0.0);
                            if (!checkLoc.getBlock().getType().isSolid() || checkLoc.clone().add(0.0, 1.0, 0.0).getBlock().getType().isSolid()) continue;
                            surfaceLocation = checkLoc;
                            foundSurface = true;
                            break;
                        }
                        if (!foundSurface) continue block7;
                        surfaceLocationMap.put((CallSite)((Object)(surfaceLocation.getBlockX() + "," + surfaceLocation.getBlockZ())), surfaceLocation);
                        for (y = 0; y < brushDepth; ++y) {
                            loc = surfaceLocation.clone().add(0.0, (double)(-y), 0.0);
                            block = loc.getBlock();
                            if (!block.getType().isSolid()) continue;
                            states.push(block.getState());
                        }
                        continue block7;
                    }
                    case PAINT_WALL: {
                        Block block;
                        Location loc;
                        int y;
                        int n = y = brushDepth % 2 == 1 ? -brushDepth / 2 : -brushDepth / 2 + 1;
                        while (y <= brushDepth / 2) {
                            loc = targetLocation.clone().add((double)x, (double)y, (double)z);
                            block = loc.getBlock();
                            if (block.getType().isSolid()) {
                                states.push(block.getState());
                            }
                            ++y;
                        }
                        continue block7;
                    }
                    case PAINT_BOTTOM: {
                        Block block;
                        Location loc;
                        int y;
                        for (y = 0; y < brushDepth; ++y) {
                            loc = targetLocation.clone().add((double)x, (double)y, (double)z);
                            block = loc.getBlock();
                            if (!block.getType().isSolid()) continue;
                            states.push(block.getState());
                        }
                        continue block7;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        BlockHistoryStates historyStates = new BlockHistoryStates(states, targetLocation, brushProperties.clone());
        TerraformerProperties terraformerProperties = plugin.getTerraformer(player);
        if (terraformerProperties == null) {
            throw new IllegalArgumentException("Player is not in terraformer mode");
        }
        if (!isRedo) {
            terraformerProperties.History.pushModification(historyStates);
        } else {
            terraformerProperties.History.pushRedo(historyStates);
        }
        for (BlockState state : states) {
            if (state.getBlock().getType().isSolid() || !brushProperties.PaintRange.contains(state.getLocation())) continue;
            state.getBlock().setType(Material.AIR, brushProperties.BlockUpdates);
        }
        for (BlockState state : states) {
            Block block = state.getBlock();
            if (!brushProperties.PaintRange.contains(block.getLocation())) continue;
            if (brushProperties.Type != BrushType.PAINT_SURFACE) {
                if (!block.getType().isSolid() || !brushProperties.Mask.isEmpty() && !brushProperties.Mask.contains(block.getType())) continue;
                block.setType(brushProperties.getMaterial(block.getLocation(), targetLocation), brushProperties.BlockUpdates);
                continue;
            }
            Location surfaceLocation = (Location)surfaceLocationMap.get(block.getLocation().getBlockX() + "," + block.getLocation().getBlockZ());
            if (surfaceLocation == null || !block.getType().isSolid() || !brushProperties.Mask.isEmpty() && !brushProperties.Mask.contains(block.getType())) continue;
            block.setType(brushProperties.getMaterial(block.getLocation(), surfaceLocation), brushProperties.BlockUpdates);
        }
        return true;
    }
}

