/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.brushes;

import java.util.Random;
import java.util.Stack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.block_history.BlockHistoryStates;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.Brush;
import ro.flcristian.terraformer.utility.Pair;
import ro.flcristian.terraformer.utility.schematics.records.SchematicBlockPos;
import ro.flcristian.terraformer.utility.schematics.records.SchematicData;

public class BrushSchematic
extends Brush {
    public static boolean brush(Terraformer plugin, Player player, BrushProperties brushProperties, Location targetLocation, boolean isRedo) {
        if (brushProperties == null || brushProperties.LoadedSchematicsData.size() == 0) {
            player.sendMessage(Component.text((String)"No schematic loaded").color((TextColor)NamedTextColor.RED));
            return false;
        }
        try {
            SchematicData schematic;
            if (brushProperties.LoadedSchematicsData.size() == 1) {
                schematic = brushProperties.LoadedSchematicsData.get(0);
            } else {
                Random random = new Random();
                int index = random.nextInt(0, brushProperties.LoadedSchematicsData.size());
                schematic = brushProperties.LoadedSchematicsData.get(index);
            }
            if (targetLocation.getBlock().getType().isSolid()) {
                targetLocation = targetLocation.clone().add(0.0, 1.0, 0.0);
            }
            Stack<BlockState> states = new Stack<BlockState>();
            int rotationAngle = 0;
            if (brushProperties.RandomSchematicRotation) {
                rotationAngle = (int)(Math.random() * 4.0) * 90;
            }
            int width = Math.max(1, schematic.width());
            int length = Math.max(1, schematic.length());
            int[] rotatedDims = BrushSchematic.getRotatedDimensions(width, length, rotationAngle);
            int rotatedWidth = rotatedDims[0];
            int rotatedLength = rotatedDims[1];
            int offsetX = -rotatedWidth / 2;
            int offsetY = 0;
            int offsetZ = -rotatedLength / 2;
            for (Pair<SchematicBlockPos, String> blockPair : schematic.blocks()) {
                SchematicBlockPos originalPos = blockPair.getFirst();
                if (originalPos == null) continue;
                SchematicBlockPos rotatedPos = BrushSchematic.rotatePosition(originalPos, rotationAngle, width, length);
                Location blockLocation = targetLocation.clone().add((double)(rotatedPos.x() + offsetX), (double)(rotatedPos.y() + offsetY), (double)(rotatedPos.z() + offsetZ));
                Block block = blockLocation.getBlock();
                if (!brushProperties.Mask.isEmpty() && !brushProperties.Mask.contains(block.getType())) continue;
                states.push(block.getState());
            }
            BlockHistoryStates historyStates = new BlockHistoryStates(states, targetLocation, brushProperties.clone());
            TerraformerProperties terraformerProperties = plugin.getTerraformer(player);
            if (terraformerProperties == null) {
                throw new IllegalArgumentException("Player is not in terraformer mode");
            }
            if (!isRedo) {
                terraformerProperties.History.pushModification(historyStates);
            } else {
                terraformerProperties.History.pushRedo(historyStates);
            }
            for (Pair<SchematicBlockPos, String> blockPair : schematic.blocks()) {
                SchematicBlockPos originalPos = blockPair.getFirst();
                String blockData = blockPair.getSecond();
                if (originalPos == null || blockData == null) continue;
                SchematicBlockPos rotatedPos = BrushSchematic.rotatePosition(originalPos, rotationAngle, width, length);
                Location blockLocation = targetLocation.clone().add((double)(rotatedPos.x() + offsetX), (double)(rotatedPos.y() + offsetY), (double)(rotatedPos.z() + offsetZ));
                Block block = blockLocation.getBlock();
                if (!brushProperties.Mask.isEmpty() && !brushProperties.Mask.contains(block.getType())) continue;
                try {
                    int colonIndex = blockData.indexOf(":");
                    int bracketIndex = blockData.indexOf("[");
                    if (colonIndex == -1) continue;
                    String materialName = bracketIndex != -1 ? blockData.substring(colonIndex + 1, bracketIndex) : blockData.substring(colonIndex + 1);
                    Material material = Material.valueOf((String)materialName.toUpperCase());
                    block.setType(material, false);
                    BlockData blockData2 = block.getBlockData();
                    if (!(blockData2 instanceof Leaves)) continue;
                    Leaves leaves = (Leaves)blockData2;
                    leaves.setPersistent(true);
                    block.setBlockData((BlockData)leaves, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (Exception e) {
            player.sendMessage(Component.text((String)("Error placing schematic: " + e.getMessage())).color((TextColor)NamedTextColor.RED));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static SchematicBlockPos rotatePosition(SchematicBlockPos pos, int degrees, int width, int length) {
        double centerX = (double)width / 2.0;
        double centerZ = (double)length / 2.0;
        double relativeX = (double)pos.x() - centerX;
        double relativeZ = (double)pos.z() - centerZ;
        double radians = Math.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        int newX = (int)Math.round(relativeX * cos - relativeZ * sin);
        int newZ = (int)Math.round(relativeX * sin + relativeZ * cos);
        int[] rotatedDims = BrushSchematic.getRotatedDimensions(width, length, degrees);
        double newCenterX = (double)rotatedDims[0] / 2.0;
        double newCenterZ = (double)rotatedDims[1] / 2.0;
        return new SchematicBlockPos(newX + (int)newCenterX, pos.y(), newZ + (int)newCenterZ);
    }

    private static int[] getRotatedDimensions(int width, int length, int rotationAngle) {
        if (rotationAngle == 90 || rotationAngle == 270) {
            return new int[]{length, width};
        }
        return new int[]{width, length};
    }
}

