/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.brushes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.block_history.BlockHistoryStates;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.Brush;

public class BrushSmooth
extends Brush {
    public static boolean brush(Terraformer plugin, Player player, BrushProperties brushProperties, Location targetLocation, boolean isRedo) {
        Stack states = new Stack();
        int brushSize = brushProperties.BrushSize;
        HashMap<Integer, List> blocksByLevel = new HashMap<Integer, List>();
        for (int x = -brushSize; x <= brushSize; ++x) {
            for (int y = -brushSize; y <= brushSize; ++y) {
                for (int z = -brushSize; z <= brushSize; ++z) {
                    Location blockLoc = targetLocation.clone().add((double)x, (double)y, (double)z);
                    if (!(blockLoc.distance(targetLocation) <= (double)brushSize)) continue;
                    blocksByLevel.computeIfAbsent(blockLoc.getBlockY(), k -> new ArrayList()).add(blockLoc.getBlock());
                }
            }
        }
        List allBlocks = blocksByLevel.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        states = allBlocks.stream().map(Block::getState).collect(Collectors.toCollection(Stack::new));
        BlockHistoryStates historyStates = new BlockHistoryStates((Stack<BlockState>)states, targetLocation, brushProperties.clone());
        TerraformerProperties terraformerProperties = plugin.getTerraformer(player);
        if (terraformerProperties == null) {
            throw new IllegalArgumentException("Player is not in terraformer mode");
        }
        if (!isRedo) {
            terraformerProperties.History.pushModification(historyStates);
        } else {
            terraformerProperties.History.pushRedo(historyStates);
        }
        for (Block block : allBlocks) {
            if (block.getType().isSolid() || block.getType() == Material.WATER || block.getType() == Material.LAVA) continue;
            block.setType(Material.AIR, brushProperties.BlockUpdates);
        }
        Iterator<Object> iterator = blocksByLevel.keySet().iterator();
        while (iterator.hasNext()) {
            int y = (Integer)iterator.next();
            for (int radius = brushSize; radius > 1; --radius) {
                ArrayList<Location> edgePositions = new ArrayList<Location>();
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        double distance = Math.sqrt(x * x + z * z);
                        if (!(Math.abs(distance - (double)radius) < 0.5)) continue;
                        Location edge = targetLocation.clone().add((double)x, (double)y - targetLocation.getY(), (double)z);
                        edgePositions.add(edge);
                    }
                }
                if (!BrushSmooth.areEdgesSolid(edgePositions)) continue;
                BrushSmooth.fillInterior(targetLocation, radius, y, (List)blocksByLevel.get(y), brushProperties.BlockUpdates);
            }
        }
        for (Block block : allBlocks) {
            if (!block.getType().isSolid()) continue;
            BrushSmooth.erodeBlock(block, brushProperties.BlockUpdates);
        }
        for (Block block : allBlocks) {
            if (block.getType().isSolid()) continue;
            BrushSmooth.fillHole(block, brushProperties.BlockUpdates);
        }
        for (Block block : allBlocks) {
            BrushSmooth.smoothBlock(block, brushProperties.BlockUpdates);
        }
        return true;
    }

    private static void erodeBlock(Block centerBlock, boolean blockUpdates) {
        int[][] directions = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
        Block blockBelow = centerBlock.getRelative(0, -1, 0);
        Block blockAbove = centerBlock.getRelative(0, 1, 0);
        if (blockBelow.getType().isSolid() && blockAbove.getType().isSolid()) {
            return;
        }
        int sameLayerNeighbors = 0;
        for (int[] dir : directions) {
            if (!centerBlock.getRelative(dir[0], 0, dir[1]).getType().isSolid()) continue;
            ++sameLayerNeighbors;
        }
        if (sameLayerNeighbors >= 5) {
            return;
        }
        boolean isProtrusion = false;
        if (!blockAbove.getType().isSolid() && blockBelow.getType().isSolid()) {
            int solidNeighborsBelow = 0;
            for (int[] dir : directions) {
                if (!blockBelow.getRelative(dir[0], 0, dir[1]).getType().isSolid()) continue;
                ++solidNeighborsBelow;
            }
            boolean bl = isProtrusion = solidNeighborsBelow >= 6 && sameLayerNeighbors <= 3;
        }
        if (!isProtrusion) {
            int totalNeighbors = 0;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0 || !centerBlock.getRelative(x, y, z).getType().isSolid()) continue;
                        ++totalNeighbors;
                    }
                }
            }
            boolean bl = isProtrusion = totalNeighbors <= 12 && sameLayerNeighbors <= 4;
        }
        if (isProtrusion) {
            centerBlock.setType(Material.AIR, blockUpdates);
        }
    }

    private static boolean areEdgesSolid(List<Location> edgePositions) {
        return edgePositions.stream().map(Location::getBlock).allMatch(block -> block.getType().isSolid());
    }

    private static boolean isExposedToAir(Block block) {
        return !block.getRelative(0, 1, 0).getType().isSolid();
    }

    private static void fillInterior(Location targetLocation, double brushSize, int y, List<Block> edgeBlocks, boolean blockUpdates) {
        int radius = (int)Math.ceil(brushSize);
        List<BlockData> exposedBlocks = edgeBlocks.stream().filter(blockData -> BrushSmooth.isExposedToAir(blockData)).collect(Collectors.toList()).stream().map(Block::getBlockData).collect(Collectors.toList());
        BlockData mostCommonBlock = exposedBlocks.isEmpty() ? BrushSmooth.findMostCommonBlock(edgeBlocks.stream().map(Block::getBlockData).collect(Collectors.toList())) : BrushSmooth.findMostCommonBlock(exposedBlocks);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Location interior;
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance < brushSize) || !BrushSmooth.isExposedToAir((interior = targetLocation.clone().add((double)x, (double)y - targetLocation.getY(), (double)z)).getBlock())) continue;
                interior.getBlock().setType(mostCommonBlock.getMaterial(), blockUpdates);
            }
        }
    }

    private static void fillHole(Block centerBlock, boolean blockUpdates) {
        int solidNeighbors = 0;
        Material commonSolid = null;
        HashMap<Material, Integer> solidMaterials = new HashMap<Material, Integer>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Block neighbor;
                    if (x == 0 && y == 0 && z == 0 || !(neighbor = centerBlock.getRelative(x, y, z)).getType().isSolid()) continue;
                    ++solidNeighbors;
                    solidMaterials.merge(neighbor.getType(), 1, Integer::sum);
                }
            }
        }
        if (!solidMaterials.isEmpty()) {
            commonSolid = solidMaterials.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        }
        if (solidNeighbors >= 14 && commonSolid != null) {
            centerBlock.setType(commonSolid, blockUpdates);
        }
    }

    private static void smoothBlock(Block centerBlock, boolean blockUpdates) {
        Material mostCommon;
        int mostCommonCount;
        HashMap<Material, Integer> materialCounts = new HashMap<Material, Integer>();
        if (centerBlock.getType().isSolid()) {
            materialCounts.put(centerBlock.getType(), 1);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Block neighbor;
                    if (x == 0 && y == 0 && z == 0 || !(neighbor = centerBlock.getRelative(x, y, z)).getType().isSolid()) continue;
                    materialCounts.merge(neighbor.getType(), 1, Integer::sum);
                    if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1) continue;
                    materialCounts.merge(neighbor.getType(), 1, Integer::sum);
                }
            }
        }
        if (!materialCounts.isEmpty() && (mostCommonCount = ((Integer)materialCounts.get(mostCommon = materialCounts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(centerBlock.getType()))).intValue()) >= 18) {
            centerBlock.setType(mostCommon, blockUpdates);
        }
    }
}

