/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.brushes;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushBall;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushDig;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushErase;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushErode;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushExtrude;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushFoliage;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushPaint;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushRise;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushSchematic;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushSmooth;
import ro.flcristian.terraformer.terraformer_properties.properties.menus.BrushSettings;
import ro.flcristian.terraformer.terraformer_properties.properties.menus.MaterialSettings;
import ro.flcristian.terraformer.utility.SkullTexturesApplier;

public enum BrushType {
    BALL,
    ERASE,
    SMOOTH,
    ERODE,
    EXTRUDE,
    PAINT_TOP,
    PAINT_SURFACE,
    PAINT_WALL,
    PAINT_BOTTOM,
    RISE,
    DIG,
    FOLIAGE,
    SCHEMATIC;


    public Component getName() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (TextComponent)Component.text((String)"Ball").color((TextColor)NamedTextColor.DARK_GREEN);
            case 1 -> (TextComponent)Component.text((String)"Erase").color((TextColor)NamedTextColor.WHITE);
            case 2 -> (TextComponent)Component.text((String)"Smooth").color((TextColor)NamedTextColor.AQUA);
            case 3 -> (TextComponent)Component.text((String)"Erode").color((TextColor)NamedTextColor.RED);
            case 4 -> (TextComponent)Component.text((String)"Extrude").color((TextColor)NamedTextColor.LIGHT_PURPLE);
            case 5 -> (TextComponent)Component.text((String)"Paint Top").color((TextColor)NamedTextColor.BLUE);
            case 6 -> (TextComponent)Component.text((String)"Paint Surface").color((TextColor)NamedTextColor.BLUE);
            case 7 -> (TextComponent)Component.text((String)"Paint Wall").color((TextColor)NamedTextColor.BLUE);
            case 8 -> (TextComponent)Component.text((String)"Paint Bottom").color((TextColor)NamedTextColor.BLUE);
            case 9 -> (TextComponent)Component.text((String)"Rise").color((TextColor)NamedTextColor.DARK_PURPLE);
            case 10 -> (TextComponent)Component.text((String)"Dig").color((TextColor)NamedTextColor.DARK_RED);
            case 11 -> (TextComponent)Component.text((String)"Foliage").color((TextColor)NamedTextColor.DARK_GREEN);
            case 12 -> (TextComponent)Component.text((String)"Schematic").color((TextColor)NamedTextColor.YELLOW);
        };
    }

    public static BrushType getBrushType(String brushName) {
        return switch (brushName.toLowerCase()) {
            case "ball" -> BALL;
            case "erase" -> ERASE;
            case "smooth" -> SMOOTH;
            case "erode" -> ERODE;
            case "extrude" -> EXTRUDE;
            case "painttop" -> PAINT_TOP;
            case "paintsurface" -> PAINT_SURFACE;
            case "paintwall" -> PAINT_WALL;
            case "paintbottom" -> PAINT_BOTTOM;
            case "rise" -> RISE;
            case "dig" -> DIG;
            case "foliage" -> FOLIAGE;
            case "schematic" -> SCHEMATIC;
            default -> null;
        };
    }

    public String toString() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "ball";
            case 1 -> "erase";
            case 2 -> "smooth";
            case 3 -> "erode";
            case 4 -> "extrude";
            case 5 -> "painttop";
            case 6 -> "paintsurface";
            case 7 -> "paintwall";
            case 8 -> "paintbottom";
            case 9 -> "rise";
            case 10 -> "dig";
            case 11 -> "foliage";
            case 12 -> "schematic";
        };
    }

    public static ItemStack getBrushSettingsItem(BrushType brushType) {
        ItemStack item = switch (brushType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ItemStack(Material.SLIME_BALL);
            case 1 -> new ItemStack(Material.WHITE_DYE);
            case 2 -> new ItemStack(Material.SNOWBALL);
            case 3 -> new ItemStack(Material.WIND_CHARGE);
            case 4 -> new ItemStack(Material.REDSTONE);
            case 5 -> new ItemStack(Material.PLAYER_HEAD);
            case 6 -> new ItemStack(Material.PLAYER_HEAD);
            case 7 -> new ItemStack(Material.PLAYER_HEAD);
            case 8 -> new ItemStack(Material.PLAYER_HEAD);
            case 9 -> new ItemStack(Material.GUNPOWDER);
            case 10 -> new ItemStack(Material.FIRE_CHARGE);
            case 11 -> new ItemStack(Material.OAK_LEAVES);
            case 12 -> new ItemStack(Material.PAPER);
        };
        ItemMeta meta = item.getItemMeta();
        meta.customName(brushType.getName());
        boolean hasMaterialSettings = List.of(BALL, PAINT_TOP, PAINT_BOTTOM, PAINT_WALL, PAINT_SURFACE).contains((Object)brushType);
        boolean hasMaskSettings = List.of(BALL, ERASE, RISE, DIG, PAINT_TOP, PAINT_BOTTOM, PAINT_WALL, PAINT_SURFACE).contains((Object)brushType);
        meta.lore(List.of((TextComponent)((TextComponent)Component.text((String)"Set the brush type to ").color((TextColor)NamedTextColor.LIGHT_PURPLE)).append(brushType.getName().color((TextColor)NamedTextColor.LIGHT_PURPLE)), (TextComponent)((TextComponent)Component.text((String)"Materials ").color((TextColor)NamedTextColor.LIGHT_PURPLE)).append(Component.text((String)(hasMaterialSettings ? "affect this brush" : "do not affect this brush")).color((TextColor)(hasMaterialSettings ? NamedTextColor.GREEN : NamedTextColor.RED))), (TextComponent)((TextComponent)Component.text((String)"Mask ").color((TextColor)NamedTextColor.LIGHT_PURPLE)).append(Component.text((String)(hasMaskSettings ? "affects this brush" : "do not affect this brush")).color((TextColor)(hasMaskSettings ? NamedTextColor.GREEN : NamedTextColor.RED))), (TextComponent)Component.text((String)"Click to select").color((TextColor)NamedTextColor.LIGHT_PURPLE)));
        switch (brushType.ordinal()) {
            case 5: {
                SkullTexturesApplier.applyTextures(meta, "http://textures.minecraft.net/texture/cc5b9542ca46b00235d3dddada02993bc4d2f7e63a5bf45b04ae6e7259c73e48");
                break;
            }
            case 7: {
                SkullTexturesApplier.applyTextures(meta, "http://textures.minecraft.net/texture/18660691d1ca029f120a3ff0eabab93a2306b37a7d61119fcd141ff2f6fcd798");
                break;
            }
            case 8: {
                SkullTexturesApplier.applyTextures(meta, "http://textures.minecraft.net/texture/960a5ab0eb3eaf4e276b8f763ee47d241c4af0091cc1b045d994cd511417af7c");
                break;
            }
            case 6: {
                SkullTexturesApplier.applyTextures(meta, "http://textures.minecraft.net/texture/44f7bc1fa8217b18b323af841372a3f7c602a435c828faa403d176c6b37b605b");
                break;
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static void applyBrush(Terraformer plugin, Player player, BrushProperties properties, Location targetLocation, boolean isRedo) {
        boolean applied;
        TerraformerProperties terraformerProperties = plugin.getTerraformer(player);
        switch (properties.Type.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean bl = BrushBall.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 1: {
                boolean bl = BrushErase.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 2: {
                boolean bl = BrushSmooth.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 3: {
                boolean bl = BrushErode.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 4: {
                boolean bl = BrushExtrude.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 5: {
                boolean bl = BrushPaint.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 6: {
                boolean bl = BrushPaint.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 7: {
                boolean bl = BrushPaint.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 8: {
                boolean bl = BrushPaint.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 9: {
                boolean bl = BrushRise.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 10: {
                boolean bl = BrushDig.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 11: {
                boolean bl = BrushFoliage.brush(plugin, player, properties, targetLocation, isRedo);
                break;
            }
            case 12: {
                boolean bl = applied = BrushSchematic.brush(plugin, player, properties, targetLocation, isRedo);
            }
        }
        if (applied) {
            terraformerProperties.addBrushHistory(properties.clone());
        }
    }

    public void openBrushSettings(Terraformer plugin, Player player, TerraformerProperties properties) {
        BrushSettings settings = switch (this.ordinal()) {
            case 5, 6, 7, 8, 9, 10, 11 -> new BrushSettings(plugin, properties, true);
            default -> new BrushSettings(plugin, properties, false);
        };
        player.openInventory(settings.getInventory());
    }

    public void openMaterialSettings(Terraformer plugin, Player player, TerraformerProperties properties) {
        MaterialSettings settings = switch (this.ordinal()) {
            case 0, 5, 6, 7, 8, 11 -> new MaterialSettings(plugin, properties, true);
            default -> new MaterialSettings(plugin, properties, false);
        };
        player.openInventory(settings.getInventory());
    }

    public void openMaterialSettings(Terraformer plugin, Player player, TerraformerProperties properties, int currentMaterialPage) {
        MaterialSettings settings = switch (this.ordinal()) {
            case 0, 5, 6, 7, 8, 11 -> new MaterialSettings(plugin, properties, true, currentMaterialPage);
            default -> new MaterialSettings(plugin, properties, false, currentMaterialPage);
        };
        player.openInventory(settings.getInventory());
    }
}

