/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.menus;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.constants.BrushSettingsItems;
import ro.flcristian.terraformer.constants.Messages;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.menus.SelectPaintMode;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.MaterialMode;

public class BrushSettings
implements InventoryHolder {
    private static final Component paintName = Component.text((String)"Paint").color((TextColor)NamedTextColor.BLUE);
    private static final Component depthSlotBlocked = Component.text((String)"This brush doesn't use depth").color((TextColor)NamedTextColor.GRAY);
    private static final Component brushesSoon = Component.text((String)"Soon there will be more brushes!").color((TextColor)NamedTextColor.RED);
    private static final Component brushHistoryEmpty = Component.text((String)"Your brush properties will appear here.").color((TextColor)NamedTextColor.DARK_AQUA);
    private static final Component brushHistoryEntry = Component.text((String)"Brush History").color((TextColor)NamedTextColor.DARK_AQUA);
    private final Inventory inventory;
    private final boolean usesDepth;

    public BrushSettings(Terraformer plugin, TerraformerProperties properties, boolean usesDepth) {
        this.usesDepth = usesDepth;
        Component inventoryName = ((TextComponent)Component.text((String)"Brush Settings").color((TextColor)NamedTextColor.DARK_AQUA)).append(((TextComponent)Component.text((String)" - ").color((TextColor)NamedTextColor.GRAY)).append(properties.Brush.Type.getName()));
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 45, inventoryName);
        this.setUpMenu(properties);
    }

    private void setUpMenu(TerraformerProperties properties) {
        int i;
        List brushes = Stream.of(BrushType.values()).filter(brushType -> brushType != BrushType.PAINT_TOP && brushType != BrushType.PAINT_WALL && brushType != BrushType.PAINT_BOTTOM && brushType != BrushType.PAINT_SURFACE).map(brushType -> {
            ItemStack item = BrushType.getBrushSettingsItem(brushType);
            if (brushType == properties.Brush.Type) {
                item.addUnsafeEnchantment(Enchantment.UNBREAKING, 1);
                item.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            return item;
        }).collect(Collectors.toList());
        ItemStack paint = new ItemStack(Material.BLUE_DYE);
        ItemMeta paintMeta = paint.getItemMeta();
        paintMeta.customName(paintName);
        paintMeta.lore(List.of((TextComponent)((TextComponent)Component.text((String)"Set the brush type to ").color((TextColor)NamedTextColor.LIGHT_PURPLE)).append(paintName.color((TextColor)NamedTextColor.LIGHT_PURPLE)), (TextComponent)((TextComponent)Component.text((String)"Materials ").color((TextColor)NamedTextColor.LIGHT_PURPLE)).append(Component.text((String)"affect this brush").color((TextColor)NamedTextColor.GREEN)), (TextComponent)((TextComponent)Component.text((String)"Mask ").color((TextColor)NamedTextColor.LIGHT_PURPLE)).append(Component.text((String)"affects this brush").color((TextColor)NamedTextColor.GREEN)), (TextComponent)Component.text((String)"Click to select").color((TextColor)NamedTextColor.LIGHT_PURPLE)));
        paint.setItemMeta(paintMeta);
        brushes.add(paint);
        for (int i2 = 0; i2 < brushes.size(); ++i2) {
            this.inventory.setItem(0 + i2, (ItemStack)brushes.get(i2));
        }
        ItemStack brushesSoonItem = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta brushesSoonItemMeta = brushesSoonItem.getItemMeta();
        brushesSoonItemMeta.customName(brushesSoon);
        brushesSoonItem.setItemMeta(brushesSoonItemMeta);
        for (int i3 = brushes.size(); i3 < 18; ++i3) {
            this.inventory.setItem(0 + i3, brushesSoonItem);
        }
        for (int size = 1; size <= 9; ++size) {
            ItemStack brushSizeItem = new ItemStack(Material.HEART_OF_THE_SEA, size);
            if (size == properties.Brush.BrushSize) {
                brushSizeItem.addUnsafeEnchantment(Enchantment.UNBREAKING, 1);
                brushSizeItem.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            ItemMeta brushSizeItemMeta = brushSizeItem.getItemMeta();
            brushSizeItemMeta.customName(BrushSettingsItems.SETTINGS_BRUSH_SIZE(size));
            brushSizeItemMeta.lore(List.of((TextComponent)Component.text((String)("Set the brush size to " + size)).color((TextColor)NamedTextColor.LIGHT_PURPLE), (TextComponent)Component.text((String)"Click to select").color((TextColor)NamedTextColor.LIGHT_PURPLE), (TextComponent)((TextComponent)Component.text((String)"Works for all brushes").color((TextColor)NamedTextColor.DARK_GRAY)).decorate(TextDecoration.ITALIC)));
            brushSizeItem.setItemMeta(brushSizeItemMeta);
            this.inventory.setItem(18 + size - 1, brushSizeItem);
        }
        if (this.usesDepth) {
            for (int depth = 1; depth <= 9; ++depth) {
                ItemStack brushDepthItem = new ItemStack(Material.NAUTILUS_SHELL, depth);
                if (depth == properties.Brush.BrushDepth) {
                    brushDepthItem.addUnsafeEnchantment(Enchantment.UNBREAKING, 1);
                    brushDepthItem.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                ItemMeta brushDepthItemMeta = brushDepthItem.getItemMeta();
                brushDepthItemMeta.customName(BrushSettingsItems.SETTINGS_BRUSH_DEPTH(depth));
                brushDepthItemMeta.lore(List.of((TextComponent)Component.text((String)("Set the brush depth to " + depth)).color((TextColor)NamedTextColor.LIGHT_PURPLE), (TextComponent)Component.text((String)"Click to select").color((TextColor)NamedTextColor.LIGHT_PURPLE), (TextComponent)((TextComponent)Component.text((String)"Works for: Paint, Rise, Dig").color((TextColor)NamedTextColor.DARK_GRAY)).decorate(TextDecoration.ITALIC)));
                brushDepthItem.setItemMeta(brushDepthItemMeta);
                this.inventory.setItem(27 + depth - 1, brushDepthItem);
            }
        } else {
            ItemStack depthSlot = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
            ItemMeta depthSlotMeta = depthSlot.getItemMeta();
            depthSlotMeta.customName(depthSlotBlocked);
            depthSlot.setItemMeta(depthSlotMeta);
            for (int i4 = 27; i4 < 36; ++i4) {
                this.inventory.setItem(i4, depthSlot);
            }
        }
        ItemStack brushHistorySlot = new ItemStack(Material.CYAN_STAINED_GLASS_PANE);
        ItemMeta brushHistorySlotMeta = brushHistorySlot.getItemMeta();
        brushHistorySlotMeta.customName(brushHistoryEmpty);
        brushHistorySlot.setItemMeta(brushHistorySlotMeta);
        for (i = 36; i < 45; ++i) {
            this.inventory.setItem(i, brushHistorySlot);
        }
        for (i = 0; i < properties.BrushHistory.size(); ++i) {
            BrushProperties brushProperties = (BrushProperties)properties.BrushHistory.get(properties.BrushHistory.size() - 1 - i);
            ItemStack brushHistory = new ItemStack(BrushType.getBrushSettingsItem(brushProperties.Type));
            ItemMeta brushHistoryMeta = brushHistory.getItemMeta();
            brushHistoryMeta.lore(List.of((TextComponent)((TextComponent)Component.text((String)"Type: ").append(brushProperties.Type.getName())).color((TextColor)NamedTextColor.LIGHT_PURPLE), (TextComponent)((TextComponent)Component.text((String)"Size: ").append(Component.text((int)brushProperties.BrushSize).color((TextColor)NamedTextColor.GOLD))).color((TextColor)NamedTextColor.LIGHT_PURPLE), (TextComponent)((TextComponent)Component.text((String)"Depth: ").append(Component.text((int)brushProperties.BrushDepth).color((TextColor)NamedTextColor.GOLD))).color((TextColor)NamedTextColor.LIGHT_PURPLE), (TextComponent)Component.text((String)"Click to apply").color((TextColor)NamedTextColor.LIGHT_PURPLE)));
            brushHistoryMeta.customName(brushHistoryEntry);
            brushHistory.setItemMeta(brushHistoryMeta);
            this.inventory.setItem(i + 36, brushHistory);
        }
    }

    public void onInventoryClick(Terraformer plugin, InventoryClickEvent event, Player player, TerraformerProperties properties) {
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (event.getClickedInventory() != this.inventory) {
            return;
        }
        event.setCancelled(true);
        if (meta.customName() != null) {
            int index;
            BrushType[] brushTypes;
            if (meta.customName().equals((Object)depthSlotBlocked)) {
                return;
            }
            for (int size = 1; size <= 9; ++size) {
                if (!meta.customName().equals((Object)BrushSettingsItems.SETTINGS_BRUSH_SIZE(size))) continue;
                properties.Brush.BrushSize = size;
                player.sendMessage(Messages.CHANGED_BRUSH_SIZE(size));
                properties.Brush.Type.openBrushSettings(plugin, player, properties);
                return;
            }
            if (this.usesDepth) {
                for (int depth = 1; depth <= 9; ++depth) {
                    if (!meta.customName().equals((Object)BrushSettingsItems.SETTINGS_BRUSH_DEPTH(depth))) continue;
                    properties.Brush.BrushDepth = depth;
                    player.sendMessage(Messages.CHANGED_BRUSH_DEPTH(depth));
                    properties.Brush.Type.openBrushSettings(plugin, player, properties);
                    return;
                }
            }
            for (BrushType brush : brushTypes = (BrushType[])Stream.of(BrushType.values()).filter(brushType -> brushType != BrushType.PAINT_TOP && brushType != BrushType.PAINT_WALL && brushType != BrushType.PAINT_BOTTOM && brushType != BrushType.PAINT_SURFACE).toArray(BrushType[]::new)) {
                if (!meta.customName().equals((Object)brush.getName())) continue;
                BrushType oldBrushType = properties.Brush.Type;
                properties.Brush.Type = brush;
                if (oldBrushType != BrushType.FOLIAGE && brush == BrushType.FOLIAGE) {
                    properties.Brush.setMode(MaterialMode.RANDOM);
                } else if (oldBrushType == BrushType.FOLIAGE && brush != BrushType.FOLIAGE) {
                    properties.Brush.setMode(properties.Brush.Mode);
                }
                player.sendMessage(Messages.CHANGED_BRUSH(brush));
                properties.Brush.Type.openBrushSettings(plugin, player, properties);
                return;
            }
            if (meta.customName().equals((Object)paintName)) {
                SelectPaintMode paintMode = new SelectPaintMode(plugin, properties);
                player.openInventory(paintMode.getInventory());
                return;
            }
            if (meta.customName().equals((Object)brushHistoryEntry) && (index = event.getSlot() - 36) < properties.BrushHistory.size()) {
                properties.applyBrushHistory((BrushProperties)properties.BrushHistory.get(properties.BrushHistory.size() - 1 - index));
                player.sendMessage(Messages.APPLIED_BRUSH_HISTORY);
                properties.Brush.Type.openBrushSettings(plugin, player, properties);
            }
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

