/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.menus;

import java.util.ArrayList;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.constants.Messages;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.material_history.MaterialHistory;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.MaterialMode;
import ro.flcristian.terraformer.utility.MaterialNameFormatter;
import ro.flcristian.terraformer.utility.MaterialObjectsParser;
import ro.flcristian.terraformer.utility.SkullTexturesApplier;

public class MaterialSettings
implements InventoryHolder {
    private static final Component materialSlotBlocked = Component.text((String)"This brush doesn't use materials").color((TextColor)NamedTextColor.RED);
    private static final Component materialSlotEmptyPercentage = Component.text((String)"Place a material in the empty slot").color((TextColor)NamedTextColor.RED);
    private static final Component materialSlotEmpty = Component.text((String)"Empty slot").color((TextColor)NamedTextColor.GRAY);
    private static final Component terraformer = Component.text((String)"Terraformer").color((TextColor)NamedTextColor.GRAY);
    private static final Component nextPage = Component.text((String)"Next Page \u27a1").color((TextColor)NamedTextColor.GREEN);
    private static final Component previousPage = Component.text((String)"\u2b05 Previous Page").color((TextColor)NamedTextColor.GREEN);
    private static final Component materialHistoryEmpty = Component.text((String)"Your material properties will appear here.").color((TextColor)NamedTextColor.DARK_RED);
    private static final Component materialHistoryEntry = Component.text((String)"Material History").color((TextColor)NamedTextColor.DARK_RED);
    private static final Component materialAdd1ToAll = Component.text((String)"Add 1% to all materials").color((TextColor)NamedTextColor.BLUE);
    private static final Component materialAdd10ToAll = Component.text((String)"Add 10% to all materials").color((TextColor)NamedTextColor.BLUE);
    private static final Component materialSubtract1FromAll = Component.text((String)"Subtract 1% from all materials").color((TextColor)NamedTextColor.RED);
    private static final Component materialSubtract10FromAll = Component.text((String)"Subtract 10% from all materials").color((TextColor)NamedTextColor.RED);
    private static final Component materialResetAll = Component.text((String)"Reset materials").color((TextColor)NamedTextColor.LIGHT_PURPLE);
    private final boolean usesMaterials;
    private final Inventory inventory;
    private int currentMaterialPage;

    public MaterialSettings(Terraformer plugin, TerraformerProperties properties, boolean usesMaterials) {
        this.usesMaterials = usesMaterials;
        this.currentMaterialPage = 1;
        Component inventoryName = ((TextComponent)Component.text((String)"Material Settings").color((TextColor)NamedTextColor.DARK_RED)).append(((TextComponent)Component.text((String)" - ").color((TextColor)NamedTextColor.GRAY)).append(properties.Brush.Type.getName()));
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 45, inventoryName);
        this.setUpMenu(properties);
    }

    public MaterialSettings(Terraformer plugin, TerraformerProperties properties, boolean usesMaterials, int currentMaterialPage) {
        this.usesMaterials = usesMaterials;
        this.currentMaterialPage = currentMaterialPage;
        Component inventoryName = ((TextComponent)Component.text((String)"Material Settings").color((TextColor)NamedTextColor.DARK_RED)).append(((TextComponent)Component.text((String)" - ").color((TextColor)NamedTextColor.GRAY)).append(properties.Brush.Type.getName()));
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 45, inventoryName);
        this.setUpMenu(properties);
    }

    private void setUpMenu(TerraformerProperties properties) {
        ItemStack empty = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta emptyMeta = empty.getItemMeta();
        emptyMeta.customName(terraformer);
        empty.setItemMeta(emptyMeta);
        for (int i = 0; i < 9; ++i) {
            this.inventory.setItem(i, empty);
            this.inventory.setItem(27 + i, empty);
        }
        ItemStack materialSlot = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta materialSlotMeta = materialSlot.getItemMeta();
        if (this.usesMaterials) {
            int i;
            int i2;
            this.inventory.setItem(31, MaterialMode.getBrushSettingsItem(properties.Brush.Mode));
            try {
                ItemStack materialSubtract1 = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta materialSubtract1Meta = materialSubtract1.getItemMeta();
                materialSubtract1Meta.customName(materialSubtract1FromAll);
                SkullTexturesApplier.applyTextures(materialSubtract1Meta, "http://textures.minecraft.net/texture/a39c846f65d5f272a839fd9c2aeb11bdc8e3f8229fbe3583486e78f4c23c8b5b");
                materialSubtract1.setItemMeta(materialSubtract1Meta);
                this.inventory.setItem(0, materialSubtract1);
                ItemStack materialSubtract10 = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta materialSubtract10Meta = materialSubtract10.getItemMeta();
                materialSubtract10Meta.customName(materialSubtract10FromAll);
                SkullTexturesApplier.applyTextures(materialSubtract10Meta, "http://textures.minecraft.net/texture/ff32222def1c7b3bd04513b1a40493407c4287b6ec3943f7333f715773d4cb61");
                materialSubtract10.setItemMeta(materialSubtract10Meta);
                this.inventory.setItem(1, materialSubtract10);
                ItemStack materialReset = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta materialResetMeta = materialReset.getItemMeta();
                materialResetMeta.customName(materialResetAll);
                SkullTexturesApplier.applyTextures(materialResetMeta, "http://textures.minecraft.net/texture/3f4105c62e3f75ab2792976068d8f2e1b48d671975e095a3e7a30c097a4e1c68");
                materialReset.setItemMeta(materialResetMeta);
                this.inventory.setItem(4, materialReset);
                ItemStack materialAdd10 = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta materialAdd10Meta = materialAdd10.getItemMeta();
                materialAdd10Meta.customName(materialAdd10ToAll);
                SkullTexturesApplier.applyTextures(materialAdd10Meta, "http://textures.minecraft.net/texture/979f9a59c897af032d4002596fab2e4e9f22f5ae1ea370f755a5ee9396b372c9");
                materialAdd10.setItemMeta(materialAdd10Meta);
                this.inventory.setItem(7, materialAdd10);
                ItemStack materialAdd1 = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta materialAdd1Meta = materialAdd1.getItemMeta();
                materialAdd1Meta.customName(materialAdd1ToAll);
                SkullTexturesApplier.applyTextures(materialAdd1Meta, "http://textures.minecraft.net/texture/28edefae8e1cce597e9c70c877b83943ee282166f10c0a3def3035e34d91b9a4");
                materialAdd1.setItemMeta(materialAdd1Meta);
                this.inventory.setItem(8, materialAdd1);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            materialSlotMeta.customName(materialSlotEmptyPercentage);
            materialSlot.setItemMeta(materialSlotMeta);
            ItemStack[] materials = (ItemStack[])properties.Brush.Materials.keySet().stream().map(material -> MaterialObjectsParser.getItemStackFromMaterial(material)).toArray(ItemStack[]::new);
            ItemStack materialPercentage = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE);
            ItemMeta materialPercentageMeta = materialPercentage.getItemMeta();
            int materialsPerPage = 9;
            int startIndex = (this.currentMaterialPage - 1) * materialsPerPage;
            int endIndex = Math.min(startIndex + materialsPerPage, materials.length);
            for (i2 = 9; i2 < 27; ++i2) {
                this.inventory.setItem(i2, null);
            }
            for (i2 = startIndex; i2 < endIndex; ++i2) {
                int slot = i2 - startIndex;
                ItemMeta materialMeta = materials[i2].getItemMeta();
                Material stackMaterial = MaterialObjectsParser.getMaterialFromItemStack(materials[i2]);
                materialMeta.customName(Component.text((String)MaterialNameFormatter.format(stackMaterial.toString())).color((TextColor)NamedTextColor.DARK_GREEN));
                materials[i2].setItemMeta(materialMeta);
                this.inventory.setItem(18 + slot, materials[i2]);
                materialPercentageMeta.customName(Component.text((String)(String.valueOf(properties.Brush.Materials.get(stackMaterial)) + "%")).color((TextColor)NamedTextColor.YELLOW));
                materialPercentage.setItemMeta(materialPercentageMeta);
                this.inventory.setItem(9 + slot, materialPercentage);
            }
            ItemStack emptySlot = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemMeta emptySlotMeta = emptySlot.getItemMeta();
            emptySlotMeta.customName(materialSlotEmpty);
            emptySlot.setItemMeta(emptySlotMeta);
            for (int i3 = endIndex - startIndex; i3 < 9; ++i3) {
                this.inventory.setItem(9 + i3, materialSlot);
                this.inventory.setItem(18 + i3, emptySlot);
            }
            if (this.currentMaterialPage > 1) {
                ItemStack prevButton = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
                ItemMeta prevMeta = prevButton.getItemMeta();
                prevMeta.customName(previousPage);
                prevButton.setItemMeta(prevMeta);
                this.inventory.setItem(27, prevButton);
            }
            if (materials.length >= this.currentMaterialPage * materialsPerPage) {
                ItemStack nextButton = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
                ItemMeta nextMeta = nextButton.getItemMeta();
                nextMeta.customName(nextPage);
                nextButton.setItemMeta(nextMeta);
                this.inventory.setItem(35, nextButton);
            }
            ItemStack materialHistorySlot = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta materialHistorySlotMeta = materialHistorySlot.getItemMeta();
            materialHistorySlotMeta.customName(materialHistoryEmpty);
            materialHistorySlot.setItemMeta(materialHistorySlotMeta);
            for (i = 36; i < 45; ++i) {
                this.inventory.setItem(i, materialHistorySlot);
            }
            for (i = 0; i < properties.MaterialHistory.size(); ++i) {
                MaterialHistory materialPropertiesHistory = (MaterialHistory)properties.MaterialHistory.get(properties.MaterialHistory.size() - 1 - i);
                ItemStack materialHistory = new ItemStack(MaterialMode.getBrushSettingsItem(materialPropertiesHistory.Mode));
                ItemMeta materialHistoryMeta = materialHistory.getItemMeta();
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(((TextComponent)Component.text((String)"Mode: ").append(materialPropertiesHistory.Mode.getName())).color((TextColor)NamedTextColor.GOLD));
                lore.add(Component.empty());
                for (Map.Entry<Material, Integer> entry : materialPropertiesHistory.Materials.entrySet()) {
                    lore.add(Component.text((String)(MaterialNameFormatter.format(entry.getKey().toString()) + ": " + String.valueOf(entry.getValue()) + "%")).color((TextColor)NamedTextColor.GRAY));
                }
                lore.add(Component.empty());
                lore.add(Component.text((String)"Click to apply").color((TextColor)NamedTextColor.LIGHT_PURPLE));
                materialHistoryMeta.lore(lore);
                materialHistoryMeta.customName(materialHistoryEntry);
                materialHistory.setItemMeta(materialHistoryMeta);
                this.inventory.setItem(i + 36, materialHistory);
            }
        } else {
            int i;
            materialSlotMeta.customName(materialSlotBlocked);
            materialSlot.setItemMeta(materialSlotMeta);
            for (i = 9; i < 27; ++i) {
                this.inventory.setItem(i, materialSlot);
            }
            for (i = 36; i < 45; ++i) {
                this.inventory.setItem(i, materialSlot);
            }
        }
    }

    public void onInventoryClick(Terraformer plugin, InventoryClickEvent event, Player player, TerraformerProperties properties) {
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (event.getClickedInventory() != this.inventory) {
            return;
        }
        event.setCancelled(true);
        if (meta.customName() != null) {
            int index;
            MaterialMode[] materialModeArray;
            if (meta.customName().equals((Object)materialSlotBlocked) || meta.customName().equals((Object)terraformer) || meta.customName().equals((Object)materialSlotEmptyPercentage) || meta.customName().equals((Object)materialHistoryEmpty)) {
                return;
            }
            if (properties.Brush.Type == BrushType.FOLIAGE) {
                MaterialMode[] materialModeArray2 = new MaterialMode[1];
                materialModeArray = materialModeArray2;
                materialModeArray2[0] = MaterialMode.RANDOM;
            } else {
                materialModeArray = MaterialMode.values();
            }
            MaterialMode[] materialModes = materialModeArray;
            for (int i = 0; i < materialModes.length; ++i) {
                if (!meta.customName().equals((Object)materialModes[i].getName())) continue;
                properties.Brush.setMode(materialModes[(i + 1) % materialModes.length]);
                player.sendMessage(Messages.CHANGED_MATERIAL_MODE(properties.Brush.Mode));
                properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                return;
            }
            if (meta.customName().equals((Object)nextPage)) {
                ++this.currentMaterialPage;
                this.setUpMenu(properties);
                return;
            }
            if (meta.customName().equals((Object)previousPage)) {
                --this.currentMaterialPage;
                this.setUpMenu(properties);
                return;
            }
            if (event.getSlot() >= 9 && event.getSlot() < 18) {
                Material material = MaterialObjectsParser.getMaterialFromItemStack(this.inventory.getItem(event.getSlot() + 9));
                ClickType clickType = event.getClick();
                switch (clickType) {
                    case LEFT: {
                        properties.Brush.Materials.put(material, Math.min(100, properties.Brush.Materials.get(material) + 1));
                        break;
                    }
                    case SHIFT_LEFT: {
                        properties.Brush.Materials.put(material, Math.min(100, properties.Brush.Materials.get(material) + 10));
                        break;
                    }
                    case RIGHT: {
                        properties.Brush.Materials.put(material, Math.max(0, properties.Brush.Materials.get(material) - 1));
                        break;
                    }
                    case SHIFT_RIGHT: {
                        properties.Brush.Materials.put(material, Math.max(0, properties.Brush.Materials.get(material) - 10));
                        break;
                    }
                }
                properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                return;
            }
            if (event.getSlot() >= 18 && event.getSlot() < 27) {
                Material materialToAdd;
                if (!meta.customName().equals((Object)materialSlotEmpty)) {
                    System.out.println("Material slot is not empty");
                    System.out.println("Item: " + String.valueOf(item));
                    System.out.println("Item: " + String.valueOf(MaterialObjectsParser.getMaterialFromItemStack(this.inventory.getItem(event.getSlot()))));
                    properties.Brush.Materials.remove(MaterialObjectsParser.getMaterialFromItemStack(this.inventory.getItem(event.getSlot())));
                    properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                    return;
                }
                if (event.getClick() == ClickType.NUMBER_KEY) {
                    int hotbarIndex = event.getHotbarButton();
                    materialToAdd = player.getInventory().getItem(hotbarIndex).getType();
                } else {
                    materialToAdd = event.getCursor().getType();
                }
                Material material = MaterialObjectsParser.getTrueMaterial(materialToAdd);
                if (material.isBlock()) {
                    properties.Brush.Materials.put(material, 0);
                    properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                    return;
                }
            }
            if (meta.customName().equals((Object)materialSubtract1FromAll)) {
                for (Material material : properties.Brush.Materials.keySet()) {
                    properties.Brush.Materials.put(material, Math.max(0, properties.Brush.Materials.get(material) - 1));
                }
                properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                return;
            }
            if (meta.customName().equals((Object)materialSubtract10FromAll)) {
                for (Material material : properties.Brush.Materials.keySet()) {
                    properties.Brush.Materials.put(material, Math.max(0, properties.Brush.Materials.get(material) - 10));
                }
                properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                return;
            }
            if (meta.customName().equals((Object)materialResetAll)) {
                properties.Brush.setMode(properties.Brush.Mode);
                properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                return;
            }
            if (meta.customName().equals((Object)materialAdd1ToAll)) {
                for (Material material : properties.Brush.Materials.keySet()) {
                    properties.Brush.Materials.put(material, Math.min(100, properties.Brush.Materials.get(material) + 1));
                }
                properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                return;
            }
            if (meta.customName().equals((Object)materialAdd10ToAll)) {
                for (Material material : properties.Brush.Materials.keySet()) {
                    properties.Brush.Materials.put(material, Math.min(100, properties.Brush.Materials.get(material) + 10));
                }
                properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
                return;
            }
            if (meta.customName().equals((Object)materialHistoryEntry) && (index = event.getSlot() - 36) < properties.MaterialHistory.size()) {
                int materialHistoryIndex = properties.MaterialHistory.size() - 1 - index;
                properties.applyMaterialHistory((MaterialHistory)properties.MaterialHistory.get(materialHistoryIndex));
                player.sendMessage(Messages.APPLIED_MATERIAL_HISTORY);
                properties.Brush.Type.openMaterialSettings(plugin, player, properties, this.currentMaterialPage);
            }
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

