/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.menus;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ro.flcristian.terraformer.Terraformer;
import ro.flcristian.terraformer.constants.Messages;
import ro.flcristian.terraformer.terraformer_properties.TerraformerProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;

public class SelectPaintMode
implements InventoryHolder {
    private final Inventory inventory;

    public SelectPaintMode(Terraformer plugin, TerraformerProperties properties) {
        Component inventoryName = Component.text((String)"Select Paint Brush Mode").color((TextColor)NamedTextColor.BLUE);
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 9, inventoryName);
        ItemStack empty = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta emptyMeta = empty.getItemMeta();
        emptyMeta.customName(inventoryName);
        empty.setItemMeta(emptyMeta);
        for (int i = 0; i < 9; i += 2) {
            this.inventory.setItem(i, empty);
        }
        ArrayList<ItemStack> paintModes = new ArrayList<ItemStack>(List.of(BrushType.getBrushSettingsItem(BrushType.PAINT_TOP), BrushType.getBrushSettingsItem(BrushType.PAINT_WALL), BrushType.getBrushSettingsItem(BrushType.PAINT_BOTTOM), BrushType.getBrushSettingsItem(BrushType.PAINT_SURFACE)));
        int i = 0;
        int j = 1;
        while (i < paintModes.size()) {
            this.inventory.setItem(j, (ItemStack)paintModes.get(i));
            ++i;
            j += 2;
        }
    }

    public void onInventoryClick(Terraformer plugin, InventoryClickEvent event, Player player, TerraformerProperties properties) {
        BrushType[] brushTypes;
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        for (BrushType brush : brushTypes = new BrushType[]{BrushType.PAINT_TOP, BrushType.PAINT_WALL, BrushType.PAINT_BOTTOM, BrushType.PAINT_SURFACE}) {
            if (!meta.customName().equals((Object)brush.getName())) continue;
            properties.Brush.Type = brush;
            player.sendMessage(Messages.CHANGED_BRUSH(brush));
            properties.Brush.Type.openBrushSettings(plugin, player, properties);
            return;
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

