/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.modes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.Material;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.Mode;
import ro.flcristian.terraformer.utility.BlockColorMap;
import ro.flcristian.terraformer.utility.Color;

public class GradientMode
implements Mode {
    private final Map<GradientCacheKey, List<Material>> gradientCache = new HashMap<GradientCacheKey, List<Material>>();
    private static final Supplier<GradientMode> instance = new Supplier<GradientMode>(){
        private final GradientMode singletonInstance = new GradientMode();

        @Override
        public GradientMode get() {
            return this.singletonInstance;
        }
    };

    private GradientMode() {
    }

    public static GradientMode getInstance() {
        return instance.get();
    }

    public List<Material> generateGradient(int gradientLengthInBlocks, Map<Material, Integer> gradientBlockPositions) {
        ArrayList<Material> gradient = new ArrayList<Material>();
        TreeMap<Integer, Color> colorPositions = new TreeMap<Integer, Color>();
        Color defaultStartColor = BlockColorMap.getInstance().BlockColors.get(Material.WHITE_CONCRETE);
        Color defaultEndColor = BlockColorMap.getInstance().BlockColors.get(Material.BLACK_CONCRETE);
        for (Map.Entry<Material, Integer> entry : gradientBlockPositions.entrySet()) {
            Color blockColor = BlockColorMap.getInstance().BlockColors.get(entry.getKey());
            if (blockColor == null || entry.getValue() < 0 || entry.getValue() > 100) continue;
            colorPositions.put(entry.getValue(), blockColor);
        }
        if (!colorPositions.containsKey(0)) {
            colorPositions.put(0, defaultStartColor);
        }
        if (!colorPositions.containsKey(100)) {
            colorPositions.put(100, defaultEndColor);
        }
        for (int i = 0; i < gradientLengthInBlocks; ++i) {
            Color interpolatedColor;
            float position = (float)i * 100.0f / (float)(gradientLengthInBlocks - 1);
            Map.Entry beforeEntry = colorPositions.floorEntry((int)position);
            Map.Entry afterEntry = colorPositions.ceilingEntry((int)position);
            if (beforeEntry.getKey().equals(afterEntry.getKey())) {
                interpolatedColor = (Color)beforeEntry.getValue();
            } else {
                float ratio = (position - (float)beforeEntry.getKey().intValue()) / (float)(afterEntry.getKey() - beforeEntry.getKey());
                interpolatedColor = this.interpolateColor((Color)beforeEntry.getValue(), (Color)afterEntry.getValue(), ratio);
            }
            Material closestBlock = BlockColorMap.getInstance().findClosestColorBlock(interpolatedColor);
            gradient.add(closestBlock);
        }
        return gradient;
    }

    private Color interpolateColor(Color c1, Color c2, float ratio) {
        int red = (int)((float)c1.getRed() * (1.0f - ratio) + (float)c2.getRed() * ratio);
        int green = (int)((float)c1.getGreen() * (1.0f - ratio) + (float)c2.getGreen() * ratio);
        int blue = (int)((float)c1.getBlue() * (1.0f - ratio) + (float)c2.getBlue() * ratio);
        return new Color(red, green, blue);
    }

    @Override
    public Material getMaterial(Location location, Location targetLocation, BrushProperties properties) {
        List<Material> gradient;
        int totalHeight;
        int size;
        if (properties.Materials.isEmpty()) {
            return Material.STONE;
        }
        if (properties.Type == BrushType.BALL) {
            size = properties.BrushSize;
            totalHeight = properties.BrushSize * 2 - 1;
        } else {
            size = properties.BrushDepth % 2 == 1 ? properties.BrushDepth / 2 : properties.BrushDepth / 2 + 1;
            totalHeight = properties.BrushDepth;
        }
        GradientCacheKey cacheKey = new GradientCacheKey(properties.Materials, totalHeight);
        if (this.gradientCache.containsKey(cacheKey)) {
            gradient = this.gradientCache.get(cacheKey);
        } else {
            gradient = this.generateGradient(totalHeight, properties.Materials);
            this.gradientCache.put(cacheKey, gradient);
        }
        int relativeY = properties.Type == BrushType.PAINT_TOP || properties.Type == BrushType.PAINT_SURFACE ? targetLocation.getBlockY() - location.getBlockY() : (properties.Type == BrushType.PAINT_BOTTOM ? location.getBlockY() - targetLocation.getBlockY() : (properties.BrushDepth % 2 == 1 ? targetLocation.getBlockY() - (location.getBlockY() - size) : targetLocation.getBlockY() - (location.getBlockY() - size) - 1));
        if (relativeY < 0 || relativeY >= gradient.size()) {
            return Material.STONE;
        }
        return gradient.get(relativeY);
    }

    private static class GradientCacheKey {
        private final Map<Material, Integer> materials;
        private final int length;

        public GradientCacheKey(Map<Material, Integer> materials, int length) {
            this.materials = materials;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GradientCacheKey that = (GradientCacheKey)o;
            return this.length == that.length && this.materials.equals(that.materials);
        }

        public int hashCode() {
            return 31 * this.materials.hashCode() + this.length;
        }
    }
}

