/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.modes;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.Material;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.Mode;

public class LayerMode
implements Mode {
    private static final Supplier<LayerMode> instance = new Supplier<LayerMode>(){
        private final LayerMode singletonInstance = new LayerMode();

        @Override
        public LayerMode get() {
            return this.singletonInstance;
        }
    };

    private LayerMode() {
    }

    public static LayerMode getInstance() {
        return instance.get();
    }

    @Override
    public Material getMaterial(Location location, Location targetLocation, BrushProperties properties) {
        double layerHeight;
        int size;
        ArrayList<Material> materials = new ArrayList<Material>(properties.Materials.keySet());
        if (materials.isEmpty()) {
            return Material.STONE;
        }
        if (properties.Type == BrushType.BALL) {
            size = properties.BrushSize;
            layerHeight = (double)(properties.BrushSize * 2 - 1) / (double)materials.size();
        } else {
            size = properties.BrushDepth % 2 == 1 ? properties.BrushDepth / 2 : properties.BrushDepth / 2 + 1;
            layerHeight = (double)properties.BrushDepth / (double)materials.size();
        }
        int relativeY = properties.Type == BrushType.PAINT_TOP || properties.Type == BrushType.PAINT_SURFACE ? targetLocation.getBlockY() - location.getBlockY() : (properties.Type == BrushType.PAINT_BOTTOM ? location.getBlockY() - targetLocation.getBlockY() : (properties.BrushDepth % 2 == 1 ? targetLocation.getBlockY() - (location.getBlockY() - size) : targetLocation.getBlockY() - (location.getBlockY() - size) - 1));
        int materialIndex = (int)((double)relativeY / layerHeight);
        materialIndex = Math.min(materialIndex, materials.size() - 1);
        materialIndex = Math.max(0, materialIndex);
        return (Material)materials.get(materialIndex);
    }
}

