/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.terraformer_properties.properties.modes;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ro.flcristian.terraformer.terraformer_properties.properties.BrushProperties;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.GradientMode;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.LayerMode;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.RandomMode;
import ro.flcristian.terraformer.utility.SkullTexturesApplier;

public enum MaterialMode {
    RANDOM,
    LAYER,
    GRADIENT;


    public Component getName() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (TextComponent)Component.text((String)"Random").color(TextColor.color((int)196, (int)39, (int)107));
            case 1 -> (TextComponent)Component.text((String)"Layer").color(TextColor.color((int)59, (int)161, (int)235));
            case 2 -> (TextComponent)Component.text((String)"Gradient").color(TextColor.color((int)247, (int)132, (int)74));
        };
    }

    public static MaterialMode getMaterialMode(String materialMode) {
        return switch (materialMode.toLowerCase()) {
            case "random" -> RANDOM;
            case "layer" -> LAYER;
            case "gradient" -> GRADIENT;
            default -> null;
        };
    }

    public String toString() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "random";
            case 1 -> "layer";
            case 2 -> "gradient";
        };
    }

    public Material getMaterial(Location location, Location targetLocation, BrushProperties properties) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> RandomMode.getInstance().getMaterial(location, targetLocation, properties);
            case 1 -> LayerMode.getInstance().getMaterial(location, targetLocation, properties);
            case 2 -> GradientMode.getInstance().getMaterial(location, targetLocation, properties);
        };
    }

    public static ItemStack getBrushSettingsItem(MaterialMode materialMode) {
        ItemStack item = switch (materialMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ItemStack(Material.PLAYER_HEAD);
            case 1 -> new ItemStack(Material.PLAYER_HEAD);
            case 2 -> new ItemStack(Material.PLAYER_HEAD);
        };
        ItemMeta meta = item.getItemMeta();
        meta.customName(materialMode.getName());
        meta.lore(List.of((TextComponent)((TextComponent)Component.text((String)"Set the material mode to ").color((TextColor)NamedTextColor.LIGHT_PURPLE)).append(materialMode.getName().color((TextColor)NamedTextColor.LIGHT_PURPLE)), (TextComponent)Component.text((String)"Click to select").color((TextColor)NamedTextColor.LIGHT_PURPLE)));
        switch (materialMode.ordinal()) {
            case 0: {
                SkullTexturesApplier.applyTextures(meta, "http://textures.minecraft.net/texture/91c581a8b597692b5b94d3b8beb9c52f56999d62f7395668fac57ac952fe4dc4");
                break;
            }
            case 1: {
                SkullTexturesApplier.applyTextures(meta, "http://textures.minecraft.net/texture/9818dde7bf4fc9f3d9df0592b07ca959a945e8f712c3bf67998af155ec3bd83b");
                break;
            }
            case 2: {
                SkullTexturesApplier.applyTextures(meta, "http://textures.minecraft.net/texture/3fe1ce1fceafff25cddaf6772a975afe13d23f1bbb84bc62f0b7052310ce658a");
            }
        }
        item.setItemMeta(meta);
        return item;
    }
}

