/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.utility;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import ro.flcristian.terraformer.terraformer_properties.properties.brushes.BrushType;
import ro.flcristian.terraformer.terraformer_properties.properties.modes.MaterialMode;
import ro.flcristian.terraformer.utility.Pair;

public class MaterialObjectsParser {
    private static List<Pair<Material, Material>> materialItemStackPairs = new ArrayList<Pair>(List.of(new Pair<Material, Material>(Material.WATER, Material.WATER_BUCKET), new Pair<Material, Material>(Material.LAVA, Material.LAVA_BUCKET), new Pair<Material, Material>(Material.SWEET_BERRY_BUSH, Material.SWEET_BERRIES), new Pair<Material, Material>(Material.CAVE_VINES, Material.GLOW_BERRIES), new Pair<Material, Material>(Material.SWEET_BERRY_BUSH, Material.SWEET_BERRIES), new Pair<Material, Material>(Material.COCOA, Material.COCOA_BEANS), new Pair<Material, Material>(Material.CHORUS_PLANT, Material.CHORUS_FRUIT), new Pair<Material, Material>(Material.POTATOES, Material.POTATO), new Pair<Material, Material>(Material.CARROTS, Material.CARROT), new Pair<Material, Material>(Material.BEETROOTS, Material.BEETROOT), new Pair<Material, Material>(Material.KELP_PLANT, Material.KELP)));

    private MaterialObjectsParser() {
    }

    public static Map<Material, Integer> parseMaterialPercentages(BrushType brushType, String materials, MaterialMode materialMode) {
        LinkedHashMap<Material, Integer> materialMap = new LinkedHashMap<Material, Integer>();
        if (materials.contains("%")) {
            String[] materialEntries;
            for (String entry : materialEntries = materials.split(",")) {
                String[] parts = entry.trim().split("%");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid material format. Expected format: '70%material_name1,30%material_name2'");
                }
                int percentage = Integer.parseInt(parts[0]);
                String materialName = parts[1].toUpperCase();
                Material material = MaterialObjectsParser.getTrueMaterial(Material.getMaterial((String)materialName));
                if (material == null || !material.isBlock()) {
                    throw new IllegalArgumentException("Invalid material: " + materialName);
                }
                materialMap.put(material, percentage);
            }
        } else {
            String[] materialNames = materials.split(",");
            if (materialMode == MaterialMode.GRADIENT) {
                int numMaterials = materialNames.length;
                if (numMaterials == 1) {
                    Material material = MaterialObjectsParser.getTrueMaterial(Material.getMaterial((String)materialNames[0].trim().toUpperCase()));
                    if (material == null || !material.isBlock()) {
                        throw new IllegalArgumentException("Invalid material: " + materialNames[0]);
                    }
                    materialMap.put(material, 50);
                } else {
                    int interval = 100 / (numMaterials - 1);
                    for (int i = 0; i < materialNames.length; ++i) {
                        Material material = MaterialObjectsParser.getTrueMaterial(Material.getMaterial((String)materialNames[i].trim().toUpperCase()));
                        if (material == null || !material.isBlock()) {
                            throw new IllegalArgumentException("Invalid material: " + materialNames[i]);
                        }
                        int percentage = i == materialNames.length - 1 ? 100 : i * interval;
                        materialMap.put(material, percentage);
                    }
                }
            } else {
                int equalPercentage = 100 / materialNames.length;
                int remainder = 100 % materialNames.length;
                for (String materialName : materialNames) {
                    Material material = MaterialObjectsParser.getTrueMaterial(Material.getMaterial((String)materialName.trim().toUpperCase()));
                    if (material == null || !material.isBlock()) {
                        throw new IllegalArgumentException("Invalid material: " + materialName);
                    }
                    int percentage = equalPercentage + (remainder > 0 ? 1 : 0);
                    --remainder;
                    materialMap.put(material, percentage);
                }
            }
        }
        materialMap.remove(Material.AIR);
        materialMap.remove(Material.FIRE);
        return materialMap;
    }

    public static List<Material> parseMaskMaterials(String materials) {
        String[] materialNames;
        ArrayList<Material> maskMaterials = new ArrayList<Material>();
        for (String materialName : materialNames = materials.split(",")) {
            Material material = Material.getMaterial((String)materialName.trim().toUpperCase());
            if (material == null) {
                throw new IllegalArgumentException("Invalid material: " + materialName);
            }
            maskMaterials.add(material);
        }
        return maskMaterials;
    }

    public static ItemStack getItemStackFromMaterial(Material material) {
        return MaterialObjectsParser.materialItemStackMap().get(material) == null ? new ItemStack(material) : MaterialObjectsParser.materialItemStackMap().get(material);
    }

    public static Material getMaterialFromItemStack(ItemStack item) {
        return MaterialObjectsParser.materialMaterialMap().get(item.getType()) == null ? item.getType() : MaterialObjectsParser.materialMaterialMap().get(item.getType());
    }

    public static Material getTrueMaterial(Material material) {
        return MaterialObjectsParser.materialMaterialMap().get(material) == null ? material : MaterialObjectsParser.materialMaterialMap().get(material);
    }

    private static Map<Material, ItemStack> materialItemStackMap() {
        LinkedHashMap<Material, ItemStack> map = new LinkedHashMap<Material, ItemStack>();
        for (Pair<Material, Material> pair : materialItemStackPairs) {
            map.put(pair.getFirst(), new ItemStack(pair.getSecond()));
        }
        return map;
    }

    private static Map<Material, Material> materialMaterialMap() {
        LinkedHashMap<Material, Material> map = new LinkedHashMap<Material, Material>();
        for (Pair<Material, Material> pair : materialItemStackPairs) {
            map.put(pair.getSecond(), pair.getFirst());
        }
        return map;
    }
}

